/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

DROP TABLE IF EXISTS `#__action_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__action_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) NOT NULL DEFAULT '',
  `message` mediumtext NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `ip_address` varchar(40) NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

DROP TABLE IF EXISTS `#__action_logs_extensions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__action_logs_extensions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__action_logs_extensions` DISABLE KEYS */;
INSERT INTO `#__action_logs_extensions` (`id`, `extension`) VALUES 
(1,'com_banners')
,(2,'com_cache')
,(3,'com_categories')
,(4,'com_config')
,(5,'com_contact')
,(6,'com_content')
,(7,'com_installer')
,(8,'com_media')
,(9,'com_menus')
,(10,'com_messages')
,(11,'com_modules')
,(12,'com_newsfeeds')
,(13,'com_plugins')
,(14,'com_redirect')
,(15,'com_tags')
,(16,'com_templates')
,(17,'com_users')
,(18,'com_checkin')
,(19,'com_scheduler');
/*!40000 ALTER TABLE `#__action_logs_extensions` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__action_logs_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__action_logs_users` (
  `user_id` int(11) unsigned NOT NULL,
  `notify` tinyint(1) unsigned NOT NULL,
  `extensions` mediumtext NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__action_logs_users` DISABLE KEYS */;
INSERT INTO `#__action_logs_users` (`user_id`, `notify`, `extensions`) VALUES 
(42,0,'[\"com_content\",\"com_banners\",\"com_cache\",\"com_categories\",\"com_config\",\"com_contact\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]');
/*!40000 ALTER TABLE `#__action_logs_users` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__action_log_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__action_log_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `id_holder` varchar(255) DEFAULT NULL,
  `title_holder` varchar(255) DEFAULT NULL,
  `table_name` varchar(255) DEFAULT NULL,
  `text_prefix` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__action_log_config` DISABLE KEYS */;
INSERT INTO `#__action_log_config` (`id`, `type_title`, `type_alias`, `id_holder`, `title_holder`, `table_name`, `text_prefix`) VALUES 
(1,'article','com_content.article','id','title','j08b41_content','PLG_ACTIONLOG_JOOMLA')
,(2,'article','com_content.form','id','title','j08b41_content','PLG_ACTIONLOG_JOOMLA')
,(3,'banner','com_banners.banner','id','name','j08b41_banners','PLG_ACTIONLOG_JOOMLA')
,(4,'user_note','com_users.note','id','subject','j08b41_user_notes','PLG_ACTIONLOG_JOOMLA')
,(5,'media','com_media.file','','name','','PLG_ACTIONLOG_JOOMLA')
,(6,'category','com_categories.category','id','title','j08b41_categories','PLG_ACTIONLOG_JOOMLA')
,(7,'menu','com_menus.menu','id','title','j08b41_menu_types','PLG_ACTIONLOG_JOOMLA')
,(8,'menu_item','com_menus.item','id','title','j08b41_menu','PLG_ACTIONLOG_JOOMLA')
,(9,'newsfeed','com_newsfeeds.newsfeed','id','name','j08b41_newsfeeds','PLG_ACTIONLOG_JOOMLA')
,(10,'link','com_redirect.link','id','old_url','j08b41_redirect_links','PLG_ACTIONLOG_JOOMLA')
,(11,'tag','com_tags.tag','id','title','j08b41_tags','PLG_ACTIONLOG_JOOMLA')
,(12,'style','com_templates.style','id','title','j08b41_template_styles','PLG_ACTIONLOG_JOOMLA')
,(13,'plugin','com_plugins.plugin','extension_id','name','j08b41_extensions','PLG_ACTIONLOG_JOOMLA')
,(14,'component_config','com_config.component','extension_id','name','','PLG_ACTIONLOG_JOOMLA')
,(15,'contact','com_contact.contact','id','name','j08b41_contact_details','PLG_ACTIONLOG_JOOMLA')
,(16,'module','com_modules.module','id','title','j08b41_modules','PLG_ACTIONLOG_JOOMLA')
,(17,'access_level','com_users.level','id','title','j08b41_viewlevels','PLG_ACTIONLOG_JOOMLA')
,(18,'banner_client','com_banners.client','id','name','j08b41_banner_clients','PLG_ACTIONLOG_JOOMLA')
,(19,'application_config','com_config.application','','name','','PLG_ACTIONLOG_JOOMLA')
,(20,'task','com_scheduler.task','id','title','#__scheduler_tasks','PLG_ACTIONLOG_JOOMLA');
/*!40000 ALTER TABLE `#__action_log_config` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__assets` DISABLE KEYS */;
INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES 
(1,0,0,231,0,'root.1','Root Asset','{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}')
,(2,1,1,2,1,'com_admin','com_admin','{}')
,(3,1,3,6,1,'com_banners','com_banners','{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}')
,(4,1,7,8,1,'com_cache','com_cache','{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}')
,(5,1,9,10,1,'com_checkin','com_checkin','{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}')
,(6,1,11,12,1,'com_config','com_config','{}')
,(7,1,13,16,1,'com_contact','com_contact','{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}')
,(8,1,17,56,1,'com_content','com_content','{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}')
,(9,1,57,58,1,'com_cpanel','com_cpanel','{}')
,(10,1,59,60,1,'com_installer','com_installer','{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}')
,(11,1,61,62,1,'com_languages','com_languages','{\"core.admin\":{\"7\":1}}')
,(12,1,63,64,1,'com_login','com_login','{}')
,(13,1,65,66,1,'com_mailto','com_mailto','{}')
,(14,1,67,68,1,'com_massmail','com_massmail','{}')
,(15,1,69,70,1,'com_media','com_media','{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}')
,(16,1,71,82,1,'com_menus','com_menus','{\"core.admin\":{\"7\":1}}')
,(17,1,83,84,1,'com_messages','com_messages','{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}')
,(18,1,85,172,1,'com_modules','com_modules','{\"core.admin\":{\"7\":1}}')
,(19,1,173,176,1,'com_newsfeeds','com_newsfeeds','{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}')
,(20,1,177,178,1,'com_plugins','com_plugins','{\"core.admin\":{\"7\":1}}')
,(21,1,179,180,1,'com_redirect','com_redirect','{\"core.admin\":{\"7\":1}}')
,(22,1,181,182,1,'com_search','com_search','{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}')
,(23,1,183,184,1,'com_templates','com_templates','{\"core.admin\":{\"7\":1}}')
,(24,1,185,190,1,'com_users','com_users','{\"core.admin\":{\"7\":1}}')
,(26,1,191,192,1,'com_wrapper','com_wrapper','{}')
,(27,8,18,29,2,'com_content.category.2','Others','{}')
,(28,3,4,5,2,'com_banners.category.3','Uncategorised','{}')
,(29,7,14,15,2,'com_contact.category.4','Uncategorised','{}')
,(30,19,174,175,2,'com_newsfeeds.category.5','Uncategorised','{}')
,(32,24,186,187,2,'com_users.category.7','Uncategorised','{}')
,(33,1,193,194,1,'com_finder','com_finder','{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}')
,(34,1,195,196,1,'com_joomlaupdate','com_joomlaupdate','{}')
,(35,1,197,198,1,'com_tags','com_tags','{}')
,(36,1,199,200,1,'com_contenthistory','com_contenthistory','{}')
,(37,1,201,202,1,'com_ajax','com_ajax','{}')
,(38,1,203,204,1,'com_postinstall','com_postinstall','{}')
,(40,18,86,87,2,'com_modules.module.2','Login','{}')
,(41,18,88,89,2,'com_modules.module.3','Popular Articles','{}')
,(42,18,90,91,2,'com_modules.module.4','Recently Added Articles','{}')
,(43,18,92,93,2,'com_modules.module.8','Toolbar','{}')
,(44,18,94,95,2,'com_modules.module.9','Quick Icons','{}')
,(45,18,96,97,2,'com_modules.module.10','Logged-in Users','{}')
,(46,18,98,99,2,'com_modules.module.12','Admin Menu','{}')
,(47,18,100,101,2,'com_modules.module.13','Admin Submenu','{}')
,(48,18,102,103,2,'com_modules.module.14','User Status','{}')
,(49,18,104,105,2,'com_modules.module.15','Title','{}')
,(52,18,106,107,2,'com_modules.module.79','Multilanguage status','{}')
,(53,18,108,109,2,'com_modules.module.86','Joomla Version','{}')
,(55,18,110,111,2,'com_modules.module.88','Site Information','{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}')
,(56,18,112,113,2,'com_modules.module.89','Release News','{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}')
,(61,27,19,20,3,'com_content.article.1','Getting Started','{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}')
,(63,1,205,206,1,'com_privacy','com_privacy','{\"core.admin\":{\"7\":1}}')
,(64,1,207,208,1,'com_actionlogs','com_actionlogs','{\"core.admin\":{\"7\":1}}')
,(65,1,209,210,1,'com_fields','com_fields','{}')
,(66,1,211,212,1,'com_associations','com_associations','{}')
,(67,18,114,115,2,'com_modules.module.95','Hero','{}')
,(68,18,116,117,2,'com_modules.module.96','Top Left','{}')
,(69,18,118,119,2,'com_modules.module.97','JA Masthead','{}')
,(70,8,30,55,2,'com_content.category.8','Our Blog','{}')
,(71,70,31,38,3,'com_content.category.9','Learner News','{}')
,(72,70,39,46,3,'com_content.category.10','Learner Stories','{}')
,(73,70,47,54,3,'com_content.category.11','Business','{}')
,(74,71,36,37,4,'com_content.article.2','World Access to Higher Education Day: Behind the Mission and Purpose','{}')
,(75,71,34,35,4,'com_content.article.3','How To Become A Little More Organised','{}')
,(76,71,32,33,4,'com_content.article.4','How To Start Learning A Music Instrument This Month','{}')
,(77,18,120,121,2,'com_modules.module.98','Login','{}')
,(78,18,122,123,2,'com_modules.module.99','Banner 1','{}')
,(79,18,124,125,2,'com_modules.module.100','Categories','{}')
,(80,18,126,127,2,'com_modules.module.101','News & Update','{}')
,(81,1,213,214,1,'j08b41_ucm_content.2','j08b41_ucm_content.2','{}')
,(82,1,215,216,1,'j08b41_ucm_content.3','j08b41_ucm_content.3','{}')
,(83,72,40,41,4,'com_content.article.5','Don\'t Be Afraid to Ask Questions','{}')
,(84,72,42,43,4,'com_content.article.6','Accent Modification for Career Success','{}')
,(85,1,217,218,1,'j08b41_ucm_content.4','j08b41_ucm_content.4','{}')
,(86,72,44,45,4,'com_content.article.7','Learning English at 5 AM','{}')
,(87,1,219,220,1,'j08b41_ucm_content.5','j08b41_ucm_content.5','{}')
,(88,73,48,49,4,'com_content.article.8','Accessible and Relatable Grammar Instruction','{}')
,(89,1,221,222,1,'j08b41_ucm_content.6','j08b41_ucm_content.6','{}')
,(90,73,50,51,4,'com_content.article.9','July\'s Featured Tutor Spotlight','{}')
,(91,1,223,224,1,'j08b41_ucm_content.7','j08b41_ucm_content.7','{}')
,(92,73,52,53,4,'com_content.article.10','July\'s Featured Supplementary Material','{}')
,(93,1,225,226,1,'j08b41_ucm_content.8','j08b41_ucm_content.8','{}')
,(94,18,128,129,2,'com_modules.module.102','About Sensei','{}')
,(95,18,130,131,2,'com_modules.module.103','Why Choose Us','{}')
,(96,18,132,133,2,'com_modules.module.104','Featured Instructor','{}')
,(97,18,134,135,2,'com_modules.module.105','Testimonials','{}')
,(98,18,136,137,2,'com_modules.module.106','Trusted by companies of all sizes','{}')
,(99,18,138,139,2,'com_modules.module.107','Call to Action','{}')
,(100,18,140,141,2,'com_modules.module.108','Logo Footer','{}')
,(101,16,72,73,2,'com_menus.menu.3','Useful Links','{}')
,(102,16,74,75,2,'com_menus.menu.4','Classes','{}')
,(103,16,76,77,2,'com_menus.menu.5','Supports','{}')
,(104,16,78,79,2,'com_menus.menu.6','Resources','{}')
,(105,18,142,143,2,'com_modules.module.109','Useful Links','{}')
,(106,18,144,145,2,'com_modules.module.110','Classes','{}')
,(107,18,146,147,2,'com_modules.module.111','Supports','{}')
,(108,18,148,149,2,'com_modules.module.112','Resources','{}')
,(109,18,150,151,2,'com_modules.module.113','Footer','{}')
,(111,18,152,153,2,'com_modules.module.114','mod_guru_menus','{}')
,(112,18,154,155,2,'com_modules.module.115','Guru Search Courses','{}')
,(113,18,156,157,2,'com_modules.module.116','Popular Courses','{}')
,(114,16,80,81,2,'com_menus.menu.8','Offcanvas','{}')
,(115,18,158,159,2,'com_modules.module.117','Bonus Pages','{}')
,(116,18,160,161,2,'com_modules.module.118','Member Actions','{}')
,(117,18,162,163,2,'com_modules.module.119','Social','{}')
,(118,18,164,165,2,'com_modules.module.120','Smart Search','{}')
,(119,27,21,22,3,'com_content.article.11','About Us','{}')
,(120,1,229,230,1,'com_jaextmanager','com_jaextmanager','{}')
,(121,27,23,24,3,'com_content.article.12','Typography','{}')
,(122,27,25,26,3,'com_content.article.13','Error Page','{}')
,(123,27,27,28,3,'com_content.article.14','Offline Page','{}')
,(124,18,166,167,2,'com_modules.module.121','JA Login','{}')
,(125,18,168,169,2,'com_modules.module.122','Search','{}')
,(126,18,170,171,2,'com_modules.module.123','Main Menu','{}')
,(127,24,188,189,2,'com_users.field.1','Test Field Media','{}');
/*!40000 ALTER TABLE `#__assets` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__associations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__associations` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__associations` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT 0,
  `impmade` int(11) NOT NULL DEFAULT 0,
  `clicks` int(11) NOT NULL DEFAULT 0,
  `clickurl` varchar(2048) NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `description` mediumtext NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` text DEFAULT NULL,
  `params` mediumtext NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(400) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `reset` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__banners` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__banners` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__banner_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text DEFAULT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(400) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__banner_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__banner_clients` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__banner_tracks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__banner_tracks` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__banner_tracks` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the j08b41_assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` longtext DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` mediumtext DEFAULT NULL,
  `metadesc` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__categories` DISABLE KEYS */;
INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES 
(1,0,0,0,19,0,'','system','ROOT','root','','',1,NULL,NULL,1,'{}','','','{}',42,'2021-08-03 08:48:32',42,'2021-08-03 08:48:32',0,'*',1)
,(2,27,1,1,2,1,'others','com_content','Others','others','','',1,NULL,NULL,1,'{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}','','','{\"author\":\"\",\"robots\":\"\"}',42,'2021-08-03 08:48:32',42,'2021-08-03 08:48:32',0,'*',1)
,(3,28,1,3,4,1,'uncategorised','com_banners','Uncategorised','uncategorised','','',1,NULL,NULL,1,'{\"category_layout\":\"\",\"image\":\"\"}','','','{\"author\":\"\",\"robots\":\"\"}',42,'2021-08-03 08:48:32',42,'2021-08-03 08:48:32',0,'*',1)
,(4,29,1,5,6,1,'uncategorised','com_contact','Uncategorised','uncategorised','','',1,NULL,NULL,1,'{\"category_layout\":\"\",\"image\":\"\"}','','','{\"author\":\"\",\"robots\":\"\"}',42,'2021-08-03 08:48:32',42,'2021-08-03 08:48:32',0,'*',1)
,(5,30,1,7,8,1,'uncategorised','com_newsfeeds','Uncategorised','uncategorised','','',1,NULL,NULL,1,'{\"category_layout\":\"\",\"image\":\"\"}','','','{\"author\":\"\",\"robots\":\"\"}',42,'2021-08-03 08:48:32',42,'2021-08-03 08:48:32',0,'*',1)
,(7,32,1,9,10,1,'uncategorised','com_users','Uncategorised','uncategorised','','',1,NULL,NULL,1,'{\"category_layout\":\"\",\"image\":\"\"}','','','{\"author\":\"\",\"robots\":\"\"}',42,'2021-08-03 08:48:32',42,'2021-08-03 08:48:32',0,'*',1)
,(8,70,1,11,18,1,'our-blog','com_content','Our Blog','our-blog','','',1,NULL,NULL,1,'{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}','','','{\"author\":\"\",\"robots\":\"\"}',42,'2021-08-03 08:48:32',0,'2021-08-03 08:48:32',0,'*',1)
,(9,71,8,12,13,2,'our-blog/learner-news','com_content','Learner News','learner-news','','Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.',1,NULL,NULL,1,'{\"category_layout\":\"\",\"image\":\"images\\/joomlart\\/blog\\/item-5.jpg\",\"image_alt\":\"\"}','','','{\"author\":\"\",\"robots\":\"\"}',42,'2021-08-03 08:48:32',42,'2021-08-03 08:48:32',0,'*',1)
,(10,72,8,14,15,2,'our-blog/learner-stories','com_content','Learner Stories','learner-stories','','Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.',1,NULL,NULL,1,'{\"category_layout\":\"\",\"image\":\"images\\/joomlart\\/blog\\/item-6.jpg\",\"image_alt\":\"\"}','','','{\"author\":\"\",\"robots\":\"\"}',42,'2021-08-03 08:48:32',42,'2021-08-03 08:48:32',0,'*',1)
,(11,73,8,16,17,2,'our-blog/business','com_content','Business','business','','Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life ',1,NULL,NULL,1,'{\"category_layout\":\"\",\"image\":\"images\\/joomlart\\/blog\\/item-9.jpg\",\"image_alt\":\"\"}','','','{\"author\":\"\",\"robots\":\"\"}',42,'2021-08-03 08:48:32',42,'2021-08-03 08:48:32',0,'*',1);
/*!40000 ALTER TABLE `#__categories` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__contact_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` mediumtext DEFAULT NULL,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` longtext DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` mediumtext NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `catid` int(11) NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL DEFAULT '',
  `sortname2` varchar(255) NOT NULL DEFAULT '',
  `sortname3` varchar(255) NOT NULL DEFAULT '',
  `language` varchar(7) NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `metakey` text DEFAULT NULL,
  `metadesc` mediumtext NOT NULL,
  `metadata` mediumtext NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if contact is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__contact_details` DISABLE KEYS */;
INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `publish_up`, `publish_down`, `version`, `hits`) VALUES 
(1,'JA Sensei','ja-sensei','','621 Bungalow Road\r\nClatonia, NE 68328','','','','','402-989-6685','','The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.','images/joomlart/others/contact.jpg','no-reply@gmail.com',0,1,NULL,NULL,1,'{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"facebook\",\"linka\":\"https:\\/\\/joomlart.com\",\"linkb_name\":\"twitter\",\"linkb\":\"https:\\/\\/joomlart.com\",\"linkc_name\":\"instagram\",\"linkc\":\"https:\\/\\/joomlart.com\",\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}',42,4,1,'','https://joomlart.com','','','','*','2021-08-03 08:48:32',42,'','2021-08-03 08:48:32',42,'','','{\"robots\":\"\",\"rights\":\"\"}',0,NULL,NULL,20,374);
/*!40000 ALTER TABLE `#__contact_details` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the j08b41_assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `introtext` longtext NOT NULL,
  `fulltext` longtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` mediumtext NOT NULL,
  `urls` mediumtext NOT NULL,
  `attribs` mediumtext NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` text DEFAULT NULL,
  `metadesc` mediumtext NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `metadata` mediumtext NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__content` DISABLE KEYS */;
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `note`) VALUES 
(1,61,'Getting Started','getting-started','<p>It\'s easy to get started creating your website. Knowing some of the basics will help.</p><h3>What is a Content Management System?</h3><p>A content management system is software that allows you to create and manage webpages easily by separating the creation of your content from the mechanics required to present it on the web.</p><p>In this site, the content is stored in a <em>database</em>. The look and feel are created by a <em>template</em>. Joomla! brings together the template and your content to create web pages.</p><h3>Logging in</h3><p>To login to your site use the user name and password that were created as part of the installation process. Once logged-in you will be able to create and edit articles and modify some settings.</p><h3>Creating an article</h3><p>Once you are logged-in, a new menu will be visible. To create a new article, click on the \"Submit Article\" link on that menu.</p><p>The new article interface gives you a lot of options, but all you need to do is add a title and put something in the content area. To make it easy to find, set the state to published.</p><div>You can edit an existing article by clicking on the edit icon (this only displays to users who have the right to edit).</div><h3>Template, site settings, and modules</h3><p>The look and feel of your site is controlled by a template. You can change the site name, background colour, highlights colour and more by editing the template settings. Click the \"Template Settings\" in the user menu.</p><p>The boxes around the main content of the site are called modules. You can modify modules on the current page by moving your cursor to the module and clicking the edit link. Always be sure to save and close any module you edit.</p><p>You can change some site settings such as the site name and description by clicking on the \"Site Settings\" link.</p><p>More advanced options for templates, site settings, modules, and more are available in the site administrator.</p><h3>Site and Administrator</h3><p>Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see. The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the \"Site Administrator\" link on the \"User Menu\" menu (visible once you login) or by adding /administrator to the end of your domain name. The same user name and password are used for both sites.</p><h3>Learn more</h3><p>There is much more to learn about how to use Joomla! to create the website you envision. You can learn much more at the <a href=\"https://docs.joomla.org/\" target=\"_blank\">Joomla! documentation site</a> and on the<a href=\"https://forum.joomla.org/\" target=\"_blank\"> Joomla! forums</a>.</p>','',1,2,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',2,4,'','',1,1358,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',0,'*','')
,(2,74,'World Access to Higher Education Day: Behind the Mission and Purpose','ja-sensei','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n','\r\n<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>\r\n<p><img src=\"images/joomlart/blog/item-4.jpg\" alt=\"\"/></p>\r\n<h3>Question Marks and devious Semikoli</h3>\r\n\r\n<p>It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\r\n<h4>\r\n  World of Grammar:\r\n</h4>\r\n<ul class=\"list-check\">\r\n  <li>Over 1500 Courses in 18 Subjects.</li>\r\n  <li>Practice Smarter.</li>\r\n  <li>Support from over 500.000 fellow students.</li>\r\n  <li>One Day. One new Skill. Started from $9.00.</li>\r\n</ul>\r\n\r\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n<h3>Alphabet Village and the subline of her</h3>\r\n<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then she continued her way. On her way she met a copy.</p>\r\n\r\n<div class=\"videoWrapper\">\r\n  <iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/yyOpUI0a09o\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>\r\n</div>\r\n<p>But nothing the copy said could convince her and so it didn’t take long until a few insidious Copy Writers ambushed her, made her drunk with Longe and Parole and dragged her into their agency, where they abused her for their projects again and again. And if she hasn’t been rewritten, then they are still using her.</p>\r\n\r\n<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\r\n<blockquote>\r\n  <p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.</p>\r\n  <small>Quote\'s author in <cite title=\"Source Title\">Source Title</cite></small>\r\n</blockquote>\r\n<p>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline</p>',1,9,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-1.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-1.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',8,1,'','',1,119,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',1,'*','')
,(3,75,'How To Become A Little More Organised','how-to-become-a-little-more-organised','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n','\r\n<p>Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\r\n\r\n<p>A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>\r\n\r\n<p>It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\r\n\r\n<p>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\r\n\r\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p>\r\n\r\n<p>She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n\r\n<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then</p>',1,9,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-2.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-2.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',4,0,'','',1,9,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',1,'*','')
,(4,76,'How To Start Learning A Music Instrument This Month','how-to-start-learning-a-music-instrument-this-month','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n','\r\n<p>Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\r\n\r\n<p>A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>\r\n\r\n<p>It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\r\n\r\n<p>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\r\n\r\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p>\r\n\r\n<p>She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n\r\n<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then</p>',1,9,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-3.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-3.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',3,0,'','',1,11,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',1,'*','')
,(5,83,'Don\'t Be Afraid to Ask Questions','don-t-be-afraid-to-ask-questions','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n','\r\n<p>Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\r\n\r\n<p>A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>\r\n\r\n<p>It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\r\n\r\n<p>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\r\n\r\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p>\r\n\r\n<p>She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n\r\n<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then</p>',1,10,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-4.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-4.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',4,0,'','',1,3,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',1,'*','')
,(6,84,'Accent Modification for Career Success','accent-modification-for-career-success','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n','\r\n<p>Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\r\n\r\n<p>A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>\r\n\r\n<p>It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\r\n\r\n<p>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\r\n\r\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p>\r\n\r\n<p>She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n\r\n<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then</p>',1,10,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-5.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-5.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',5,0,'','',1,12,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',1,'*','')
,(7,86,'Learning English at 5 AM','learning-english-at-5-am','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n','\r\n<p>Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\r\n\r\n<p>A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>\r\n\r\n<p>It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\r\n\r\n<p>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\r\n\r\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p>\r\n\r\n<p>She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n\r\n<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then</p>',1,10,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-6.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-6.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',4,1,'','',1,0,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',1,'*','')
,(8,88,'Accessible and Relatable Grammar Instruction','accessible-and-relatable-grammar-instruction','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n','\r\n<p>Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\r\n\r\n<p>A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>\r\n\r\n<p>It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\r\n\r\n<p>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\r\n\r\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p>\r\n\r\n<p>She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n\r\n<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then</p>',1,11,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-7.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-7.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',5,1,'','',1,4,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',1,'*','')
,(9,90,'July\'s Featured Tutor Spotlight','july-s-featured-tutor-spotlight','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n','\r\n<p>Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\r\n\r\n<p>A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>\r\n\r\n<p>It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\r\n\r\n<p>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\r\n\r\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p>\r\n\r\n<p>She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n\r\n<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then</p>',1,11,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-8.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-8.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',6,0,'','',1,0,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',1,'*','')
,(10,92,'July\'s Featured Supplementary Material','july-s-featured-supplementary-material','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n','\r\n<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>\r\n<img src=\"images/joomlart/blog/item-4.jpg\" alt=\"\"/>\r\n<h4>Question Marks and devious Semikoli</h4>\r\n<p>It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\r\n<h5>\r\n  World of Grammar:\r\n</h5>\r\n<ul class=\"list-check\">\r\n  <li>Over 1500 Courses in 18 Subjects.</li>\r\n  <li>Practice Smarter.</li>\r\n  <li>Support from over 500.000 fellow students.</li>\r\n  <li>One Day. One new Skill. Started from $9.00.</li>\r\n</ul>\r\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n<h4>Alphabet Village and the subline of her</h4>\r\n<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then she continued her way. On her way she met a copy.</p>\r\n\r\n<div class=\"videoWrapper\">\r\n  <iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/yyOpUI0a09o\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>\r\n</div>\r\n<p>But nothing the copy said could convince her and so it didn’t take long until a few insidious Copy Writers ambushed her, made her drunk with Longe and Parole and dragged her into their agency, where they abused her for their projects again and again. And if she hasn’t been rewritten, then they are still using her.</p>\r\n\r\n<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\r\n<blockquote>\r\n  <p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.</p>\r\n  <small>Quote\'s author in <cite title=\"Source Title\">Source Title</cite></small>\r\n</blockquote>\r\n<p>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline</p>',1,11,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-9.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-9.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',13,0,'','',1,6,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',1,'*','')
,(11,119,'About Us','about-us','<div class=\"about-us\">\r\n	<img src=\"images/joomlart/others/about-us.jpg\" alt=\"\"/>\r\n\r\n	<div class=\"info\">\r\n		<div class=\"row\">\r\n			<div class=\"col-sm-5\">\r\n				<h2>Our diverse team of professionals shares a passion for online education.</h2>\r\n			</div>\r\n\r\n			<div class=\"col-sm-offset-1 col-sm-6\">\r\n				<p class=\"lead\">The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p>\r\n\r\n				<p class=\"lead\">She packed her seven versalia, put her initial into the belt and made herself on the way. Because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p>\r\n			</div>\r\n		</div>\r\n	</div>\r\n\r\n	<div class=\"statics\">\r\n		<div class=\"row\">\r\n			<div class=\"col-sm-6 col-md-3\">\r\n				<h2>15m+</h2>\r\n				<h4>Students learning</h4>\r\n				<p>She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n			</div>\r\n\r\n			<div class=\"col-sm-6 col-md-3\">\r\n				<h2>62k+</h2>\r\n				<h4>Active courses</h4>\r\n				<p>A small river named Duden flows by their place and supplies into regelialia saperet.</p>\r\n			</div>\r\n\r\n			<div class=\"col-sm-6 col-md-3\">\r\n				<h2>154k+</h2>\r\n				<h4>Instructors online</h4>\r\n				<p>It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\r\n			</div>\r\n\r\n			<div class=\"col-sm-6 col-md-3\">\r\n				<h2>$259m+</h2>\r\n				<h4>Earned by instructors</h4>\r\n				<p>She packed her seven versalia, put her initial into the belt and made herself on the way.</p>\r\n			</div>\r\n		</div>\r\n	</div>\r\n\r\n	<div class=\"info features\">\r\n		<div class=\"row\">\r\n			<div class=\"col-sm-6 intro-left\">\r\n				<img src=\"images/joomlart/others/detail-1.jpg\" alt=\"\"/>\r\n			</div>\r\n\r\n			<div class=\"col-sm-6 intro-right\">\r\n				<h2>Real-World Projects.</h2>\r\n				<h4>Our Mission</h4>\r\n				<p>Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Nam quam nunc blandit vel luctus pulvinar, hendrerit id lorem maecenas.</p>\r\n				<h4>Our Students</h4>\r\n				<p>Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>\r\n			</div>\r\n		</div>\r\n		\r\n		<div class=\"row\">\r\n			<div class=\"col-sm-6 intro-right pull-right\">\r\n				<img src=\"images/joomlart/others/detail-2.jpg\" alt=\"\"/>\r\n			</div>\r\n\r\n			<div class=\"col-sm-6 intro-left pull-left\">\r\n				<h2>Supported Journey.</h2>\r\n				<h4>Global Inspiration</h4>\r\n				<p>Nam quam nunc blandit vel libero venenatis faucibus. Nullam quis ante. Nam quam nunc blandit vel luctus pulvinar.</p>\r\n				<h4>Daily Creativity</h4>\r\n				<p> Donec sodales sagittis magna. Duis leo sed fringilla mauris sit amet nibh. Sed consequat, leo eget bibendum sodales.</p>\r\n			</div>\r\n		</div>\r\n	</div>\r\n\r\n	<div class=\"info our-team\">\r\n		<div class=\"intro\">\r\n			<h2>Your success is our success</h2>\r\n			<p class=\"lead\">Our diverse team duis leo sed fringilla mauris sit amet nibh. Sed consequat leo eget bibendum sodales bibendum sodales.</p>\r\n		</div>\r\n\r\n		<div class=\"row\">\r\n			<div class=\"col-sm-3\">\r\n				<div class=\"item\">\r\n					<img src=\"images/joomlart/others/teacher-1.jpg\" alt=\"\"/>\r\n					<h4>Scott L. Porter</h4>\r\n					<span>Founder</span>\r\n				</div>\r\n\r\n				<div class=\"item\">\r\n					<img src=\"images/joomlart/others/teacher-2.jpg\" alt=\"\"/>\r\n					<h4>Edith O. Johnson</h4>\r\n					<span>Chief Operating Officer</span>\r\n				</div>\r\n			</div>\r\n\r\n			<div class=\"col-sm-3\">\r\n				<div class=\"item\">\r\n					<img src=\"images/joomlart/others/teacher-3.jpg\" alt=\"\"/>\r\n					<h4>Scott L. Porter</h4>\r\n					<span>VP, Engineering</span>\r\n				</div>\r\n\r\n				<div class=\"item\">\r\n					<img src=\"images/joomlart/others/teacher-4.jpg\" alt=\"\"/>\r\n					<h4>Edith O. Johnson</h4>\r\n					<span>VP, Business Development</span>\r\n				</div>\r\n			</div>\r\n\r\n			<div class=\"col-sm-3\">\r\n				<div class=\"item\">\r\n					<img src=\"images/joomlart/others/teacher-5.jpg\" alt=\"\"/>\r\n					<h4>Laurel H. Laufer</h4>\r\n					<span>VP, Growth</span>\r\n				</div>\r\n\r\n				<div class=\"item\">\r\n					<img src=\"images/joomlart/others/teacher-6.jpg\" alt=\"\"/>\r\n					<h4>Catherine G. Read</h4>\r\n					<span>Chief Operating Officer</span>\r\n				</div>\r\n			</div>\r\n\r\n			<div class=\"col-sm-3\">\r\n				<div class=\"item\">\r\n					<img src=\"images/joomlart/others/teacher-7.jpg\" alt=\"\"/>\r\n					<h4>Anthony Strang</h4>\r\n					<span>VP, Growth</span>\r\n				</div>\r\n\r\n				<div class=\"item\">\r\n					<img src=\"images/joomlart/others/teacher-8.jpg\" alt=\"\"/>\r\n					<h4>Dean P. Barbee</h4>\r\n					<span>VP, Engineering</span>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>','',1,2,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',65,3,'','',1,203,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',0,'*','')
,(12,121,'Typography','typography','<p> </p>\r\n<!-- CORE TYPOGRAPHY\r\n=======================================================-->\r\n<div class=\"core-typo\">\r\n<div class=\"docs-section\"><!-- Headings -->\r\n<div class=\"row example-row example-type\">\r\n<div class=\"col-lg-12\">\r\n<h3 class=\"sub-title\">Heading Text</h3>\r\n<h1>h1. Heading <small>Secondary text</small></h1>\r\n<h2>h2. Heading <small>Secondary text</small></h2>\r\n<h3>h3. Heading <small>Secondary text</small></h3>\r\n<h4>h4. Heading <small>Secondary text</small></h4>\r\n<h5>h5. Heading <small>Secondary text</small></h5>\r\n<h6>h6. Heading <small>Secondary text</small></h6>\r\n<div class=\"alert alert-warning\">\r\n<p><strong>TIPS:</strong> Create lighter, secondary text in any heading with a generic <code>&lt;small&gt;</code> tag or the <code>.small</code> class.</p>\r\n</div>\r\n</div>\r\n<div class=\"col-lg-12\">\r\n<h3 class=\"sub-title\">Example body text</h3>\r\n<p class=\"lead\">This is a <strong>lead paragraph</strong>. <br />Make a paragraph stand out by adding <code>.lead</code>.</p>\r\n<p>Maecenas sed diam eget risus varius blandit sit amet non magna. Donec id elit non mi porta gravida at eget metus.</p>\r\n<p>Nullam quis risus eget <a href=\"#\">urna mollis ornare</a> vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nullam id dolor id nibh ultricies vehicula.</p>\r\n<p>The following snippet of text is <strong>rendered as bold text</strong>.</p>\r\n<p>The following snippet of text is <em>rendered as italicized text</em>.</p>\r\n<p>An abbreviation of the word attribute is <abbr title=\"attribute\">attr</abbr>.</p>\r\n</div>\r\n</div>\r\n<!-- //Headings -->\r\n<p> </p>\r\n<!-- Address & Emphasis -->\r\n<div class=\"row example-row example-type\">\r\n<div class=\"col-lg-4\">\r\n<h3 class=\"sub-title\">Address</h3>\r\n<address><strong>Company Name</strong><br /> 795 Folsom Ave, Suite 600<br /> San Francisco, CA 94107<br /> <abbr title=\"Phone\">P:</abbr> (123) 456-7890</address><address><strong>Full Name</strong><br /> <abbr title=\"Phone\">P:</abbr> (123) 456-7890<br /> <span id=\"cloake4e2bbc0ee69e95e9a438ec93c97c721\"><a href=\"mailto:first.last@example.com\">first.last@example.com</a></span></address></div>\r\n<div class=\"col-lg-4\">\r\n<h3 class=\"sub-title\">Emphasis classes</h3>\r\n<p class=\"text-muted\">This is a <code>.mute</code> paragraph.</p>\r\n<p class=\"text-primary\">This is a <code>.text-primary</code> paragraph.</p>\r\n<p class=\"text-warning\">This is a <code>.text-warning</code> paragraph.</p>\r\n<p class=\"text-danger\">This is a <code>.text-danger</code> paragraph.</p>\r\n<p class=\"text-success\">This is a <code>.text-success</code> paragraph.</p>\r\n<p class=\"text-info\">This is a <code>.text-info</code> paragraph.</p>\r\n</div>\r\n<div class=\"col-lg-4\">\r\n<h3 class=\"sub-title\">Alignment classes</h3>\r\n<p class=\"text-left\">This is a left aligned text <code>.text-left</code></p>\r\n<p class=\"text-center\">This is a center aligned text <code>.text-center</code></p>\r\n<p class=\"text-right\">This is a right aligned text <code>.text-right</code></p>\r\n<p class=\"text-justify\">This is a justify aligned text which is often used in Book Design, Magazine or special Typo Pages. Create a justify aligned text with <code>.text-justify</code> class.</p>\r\n</div>\r\n</div>\r\n<!-- //Address & Emphasis --></div>\r\n<!-- //CORE TYPOGRAPHY -->\r\n<p> </p>\r\n<!-- Blockquotes -->\r\n<div class=\"docs-section\">\r\n<h2 id=\"example-colors\">Blockquotes</h2>\r\n<div class=\"row example-row example-type\">\r\n<div class=\"col-lg-6\">\r\n<blockquote>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n<small>Quote\'s author in <cite title=\"Source Title\">Source Title</cite></small></blockquote>\r\n</div>\r\n<div class=\"col-lg-6\">\r\n<blockquote class=\"pull-right\">\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n<small>Quote\'s author in <cite title=\"Source Title\">Source Title</cite></small></blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n<!-- //Blockquotes -->\r\n<p> </p>\r\n<!-- TAGS\r\n	=======================================================-->\r\n<div class=\"docs-section\">\r\n<h2 id=\"example-colors\">Tags</h2>\r\n<div class=\"tags\"><span class=\"tag\"><a class=\"label label-info\" href=\"#\">hotel</a></span> <span class=\"tag\"><a class=\"label label-info\" href=\"#\">booking</a></span> <span class=\"tag\"><a class=\"label label-info\" href=\"#\">discount</a></span> <span class=\"tag\"><a class=\"label label-info\" href=\"#\">location</a></span> <span class=\"tag\"><a class=\"label label-info\" href=\"#\">map</a></span> <span class=\"tag\"><a class=\"label label-info\" href=\"#\">travel</a></span></div>\r\n</div>\r\n<!-- //TAGS -->\r\n<p> </p>\r\n<!-- COLOR SWATCHES\r\n	=======================================================-->\r\n<div class=\"docs-section\">\r\n<h2 id=\"example-color\">Color Swatches</h2>\r\n<!-- Brand Colors -->\r\n<h3 class=\"sub-title\">Brand Colors</h3>\r\n<div class=\"row example-row example-colors\">\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-brand-primary\">\r\n<dl>\r\n<dt>#4bd173</dt>\r\n<dd>Brand Primary</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-brand-secondary\">\r\n<dl>\r\n<dt>#428bca</dt>\r\n<dd>Brand Secondary</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-brand-warning\">\r\n<dl>\r\n<dt>#f0ad4e</dt>\r\n<dd>Brand Warning</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-brand-danger\">\r\n<dl>\r\n<dt>#d9534f</dt>\r\n<dd>Brand Danger</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-brand-info\">\r\n<dl>\r\n<dt>#5bc0de</dt>\r\n<dd>Brand Info</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-brand-success\">\r\n<dl>\r\n<dt>#4bd173</dt>\r\n<dd>Brand Success</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n</div>\r\n<!-- Brand Colors -->\r\n<p> </p>\r\n<!-- Grayscale -->\r\n<h3 class=\"sub-title\">Grayscale Levels</h3>\r\n<div class=\"row example-row example-colors\">\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-gray-darker\">\r\n<dl>\r\n<dt>#0e0e0e</dt>\r\n<dd>Gray Darker</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-gray-dark\">\r\n<dl>\r\n<dt>#2a3642</dt>\r\n<dd>Gray Dark</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-gray\">\r\n<dl>\r\n<dt>#555</dt>\r\n<dd>Gray</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-gray-light\">\r\n<dl>\r\n<dt>#9fa7ac</dt>\r\n<dd>Gray Light</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-gray-lighter\">\r\n<dl>\r\n<dt>#eee</dt>\r\n<dd>Gray Lighter</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n<div class=\"col-xs-12 col-sm-4\">\r\n<div class=\"swatch-item color-gray-lightest\">\r\n<dl>\r\n<dt>#f1f5f7</dt>\r\n<dd>Gray Lightest</dd>\r\n</dl>\r\n</div>\r\n</div>\r\n</div>\r\n<!-- //Grayscale --></div>\r\n<!-- //COLOR SWATCHES -->\r\n<p> </p>\r\n<!-- BUTTON\r\n	=======================================================-->\r\n<div class=\"docs-section\">\r\n<h2 id=\"example-colors\">Buttons</h2>\r\n<div class=\"row example-row example-type\">\r\n<div class=\"col-md-12\"><!-- Button -->\r\n<div class=\"example-button clearfix\"><a class=\"btn btn-default\" href=\"#\">Normal Button</a> <a class=\"btn btn-primary\" href=\"#\">Primary Button</a> <a class=\"btn btn-success\" href=\"#\">Success Button</a> <a class=\"btn btn-warning\" href=\"#\">Warning Button</a> <a class=\"btn btn-danger\" href=\"#\">Danger Button</a> <a class=\"btn btn-info\" href=\"#\">Info Button</a></div>\r\n<!-- //Button --></div>\r\n</div>\r\n</div>\r\n<!-- //BUTTON -->\r\n<p> </p>\r\n<p> </p>\r\n<br /> <!-- NAVIGATIONS\r\n	================================================== -->\r\n<div class=\"docs-section\">\r\n<h2 id=\"example-navigation\">Navigations</h2>\r\n<!-- Tabs & Vertical Menus -->\r\n<div class=\"row example-row example-navigation\"><!-- Tabs -->\r\n<div class=\"col-lg-8\">\r\n<h3 class=\"sub-title\">Tabs</h3>\r\n<ul class=\"nav nav-tabs\">\r\n<li class=\"active\"><a href=\"#home\" data-toggle=\"tab\">Home</a></li>\r\n<li><a href=\"#profile\" data-toggle=\"tab\">Profile</a></li>\r\n<li class=\"disabled\"><a>Disabled</a></li>\r\n<li class=\"dropdown\"><a class=\"dropdown-toggle\" href=\"#\" data-toggle=\"dropdown\"> Dropdown </a>\r\n<ul class=\"dropdown-menu\">\r\n<li><a href=\"#dropdown1\" data-toggle=\"tab\">Action</a></li>\r\n<li><a href=\"#dropdown2\" data-toggle=\"tab\">Another action</a></li>\r\n<li><a href=\"#dropdown2\" data-toggle=\"tab\">Another action</a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<div id=\"myTabContent\" class=\"tab-content\">\r\n<div id=\"home\" class=\"tab-pane fade active in\">\r\n<p>In the area of graphical user interfaces (GUI), a <strong>tabbed document interface</strong> (TDI) or a Tab is one that allows multiple documents to be contained within a single window, using tabs as a navigational widget for switching between sets of documents. It is an interface style most commonly associated with web browsers, web applications, text editors, and preference panes.</p>\r\n<p>GUI tabs are modeled after traditional card tabs inserted in paper files or card indexes (in keeping with the desktop metaphor).</p>\r\n</div>\r\n<div id=\"profile\" class=\"tab-pane fade\">\r\n<p>In the area of graphical user interfaces (GUI), a <strong>tabbed document interface</strong> (TDI) or a Tab is one that allows multiple documents to be contained within a single window, using tabs as a navigational widget for switching between sets of documents. It is an interface style most commonly associated with web browsers, web applications, text editors, and preference panes.</p>\r\n<p>GUI tabs are modeled after traditional card tabs inserted in paper files or card indexes (in keeping with the desktop metaphor).</p>\r\n</div>\r\n<div id=\"dropdown1\" class=\"tab-pane fade\">\r\n<p>In the area of graphical user interfaces (GUI), a <strong>tabbed document interface</strong> (TDI) or a Tab is one that allows multiple documents to be contained within a single window, using tabs as a navigational widget for switching between sets of documents. It is an interface style most commonly associated with web browsers, web applications, text editors, and preference panes.</p>\r\n<p>GUI tabs are modeled after traditional card tabs inserted in paper files or card indexes (in keeping with the desktop metaphor).</p>\r\n</div>\r\n<div id=\"dropdown2\" class=\"tab-pane fade\">\r\n<p>In the area of graphical user interfaces (GUI), a <strong>tabbed document interface</strong> (TDI) or a Tab is one that allows multiple documents to be contained within a single window, using tabs as a navigational widget for switching between sets of documents. It is an interface style most commonly associated with web browsers, web applications, text editors, and preference panes.</p>\r\n<p>GUI tabs are modeled after traditional card tabs inserted in paper files or card indexes (in keeping with the desktop metaphor).</p>\r\n</div>\r\n</div>\r\n</div>\r\n<!-- //Tabs --> <!-- Vertical Menus -->\r\n<div class=\"col-lg-4\">\r\n<h3 class=\"sub-title\">Vertical Menus</h3>\r\n<ul class=\"nav nav-pills nav-stacked\">\r\n<li class=\"active\"><a href=\"#\">Active Menu Item</a></li>\r\n<li><a href=\"#\">Menu Item</a></li>\r\n<li><a href=\"#\">Menu Item</a></li>\r\n<li class=\"disabled\"><a href=\"#\">Disabled Menu Item</a></li>\r\n<li class=\"dropdown\"><a class=\"dropdown-toggle\" href=\"#\" data-toggle=\"dropdown\"> Dropdown </a>\r\n<ul class=\"dropdown-menu\">\r\n<li><a href=\"#\">Action</a></li>\r\n<li><a href=\"#\">Another action</a></li>\r\n<li><a href=\"#\">Something else here</a></li>\r\n<li><a href=\"#\">Separated link</a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</div>\r\n<!-- Vertical Menus --></div>\r\n<!-- Tabs & Vertical Menus --></div>\r\n<!-- //NAVIGATIONS -->\r\n<p> </p>\r\n<!-- FORMS\r\n	================================================== -->\r\n<div class=\"docs-section\">\r\n<div class=\"page-header\">\r\n<h3 id=\"example-typo\">Inputs</h3>\r\n</div>\r\n<!-- Inputs -->\r\n<div class=\"row example-row example-forms example-inputs\">\r\n<div class=\"col-md-3\">\r\n<div class=\"form-group has-success\"><label class=\"control-label\" for=\"inputSuccess\">Input success</label> <input id=\"inputSuccess\" class=\"form-control\" type=\"text\" /></div>\r\n</div>\r\n<div class=\"col-md-3\">\r\n<div class=\"form-group has-error\"><label class=\"control-label\" for=\"inputError\">Input error</label> <input id=\"inputError\" class=\"form-control\" type=\"text\" /></div>\r\n</div>\r\n<div class=\"col-md-3\">\r\n<div class=\"form-group has-warning\"><label class=\"control-label\" for=\"inputWarning\">Input warning</label> <input id=\"inputWarning\" class=\"form-control\" type=\"text\" /></div>\r\n</div>\r\n<div class=\"col-md-3\">\r\n<div class=\"form-group\"><label class=\"control-label\" for=\"disabledInput\">Disabled input</label> <input id=\"disabledInput\" class=\"form-control\" disabled=\"disabled\" type=\"text\" /></div>\r\n</div>\r\n</div>\r\n<!-- //Inputs --></div>\r\n<!-- //FORMS -->\r\n<p> </p>\r\n<!-- INDICATORS\r\n	================================================== -->\r\n<div class=\"docs-section\">\r\n<h2 id=\"example-indicators\">Indicators</h2>\r\n<!-- Alerts -->\r\n<h3 class=\"sub-title\">Alerts and Notifications</h3>\r\n<div class=\"row example-row example-indicators\">\r\n<div class=\"col-md-6\">\r\n<div class=\"alert  alert-danger\">\r\n<h4>Error message title</h4>\r\n<p>Cras ac dignissim mauris. Duis odio diam, rutrum ut est at, scelerisque malesuada risus.</p>\r\n</div>\r\n</div>\r\n<div class=\"col-md-6\">\r\n<div class=\"alert  alert-success\">\r\n<h4>Sussess message title</h4>\r\n<p>Cras ac dignissim mauris. Duis odio diam, rutrum ut est at, scelerisque malesuada risus.</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"row example-row example-indicators\">\r\n<div class=\"col-md-6\">\r\n<div class=\"alert  alert-info\">\r\n<h4>Info message title</h4>\r\n<p>Cras ac dignissim mauris. Duis odio diam, rutrum ut est at, scelerisque malesuada risus.</p>\r\n</div>\r\n</div>\r\n<div class=\"col-md-6\">\r\n<div class=\"alert  alert-warning\">\r\n<h4>Warning message title</h4>\r\n<p>Cras ac dignissim mauris. Duis odio diam, rutrum ut est at, scelerisque malesuada risus.</p>\r\n</div>\r\n</div>\r\n</div>\r\n<!-- Alerts -->\r\n<p> </p>\r\n<!-- Labels & Badges -->\r\n<div class=\"row example-row example-indicators\">\r\n<div class=\"col-lg-7\">\r\n<h3 class=\"sub-title\">Badges</h3>\r\n<div class=\"example\">\r\n<ul class=\"nav nav-pills nav-badges\">\r\n<li class=\"active\"><a href=\"#\">Home <span class=\"badge\">42</span></a></li>\r\n<li><a href=\"#\">Profile </a></li>\r\n<li><a href=\"#\">Messages <span class=\"badge\">25</span></a></li>\r\n<li><a href=\"#\">Notices <span class=\"badge\">2</span></a></li>\r\n</ul>\r\n</div>\r\n</div>\r\n<div class=\"col-lg-5\">\r\n<h3 class=\"sub-title\">Labels</h3>\r\n<div class=\"example\"><span class=\"label label-default\">Default</span> <span class=\"label label-primary\">Primary</span> <span class=\"label label-success\">Success</span> <span class=\"label label-info\">Info</span> <span class=\"label label-warning\">Warning</span> <span class=\"label label-danger\">Danger</span></div>\r\n</div>\r\n</div>\r\n<!-- Labels & Badges --></div>\r\n<!-- //INDICATORS -->\r\n<p> </p>\r\n<!-- MISC\r\n	================================================== -->\r\n<div class=\"docs-section\">\r\n<h2 id=\"example-misc\">Misc</h2>\r\n<!-- List Groups -->\r\n<h3 class=\"sub-title\">List groups</h3>\r\n<div class=\"row example-row example-misc\">\r\n<div class=\"col-lg-4\">\r\n<ul class=\"list-group\">\r\n<li class=\"list-group-item\"><span class=\"badge\">14</span> Cras justo odio</li>\r\n<li class=\"list-group-item\"><span class=\"badge\">2</span> Dapibus ac facilisis in</li>\r\n<li class=\"list-group-item\">Morbi leo risus</li>\r\n<li class=\"list-group-item\"><span class=\"badge\">1</span> Morbi leo risus</li>\r\n<li class=\"list-group-item\"><span class=\"badge\">2</span> Dapibus ac facilisis in</li>\r\n</ul>\r\n</div>\r\n<div class=\"col-lg-4\">\r\n<div class=\"list-group\"><a class=\"list-group-item active\" href=\"#\"><span class=\"badge\">9</span> Cras justo odio</a> <a class=\"list-group-item\" href=\"#\">Dapibus ac facilisis in</a> <a class=\"list-group-item\" href=\"#\">Morbi leo risus</a> <a class=\"list-group-item\" href=\"#\">Porta ac consectetur ac</a> <a class=\"list-group-item\" href=\"#\">Vestibulum at eros</a></div>\r\n</div>\r\n<div class=\"col-lg-4\">\r\n<div class=\"list-group\">\r\n<h4 class=\"list-group-item-heading\">List group item heading</h4>\r\n<p class=\"list-group-item-text\">Donec id elit non mi porta gravida at eget metus risus varius blandit.</p>\r\n</div>\r\n<div class=\"list-group\">\r\n<h4 class=\"list-group-item-heading\">List group item heading</h4>\r\n<p class=\"list-group-item-text\">Donec id elit non mi porta gravida at eget metus.</p>\r\n</div>\r\n<div class=\"list-group\">\r\n<h4 class=\"list-group-item-heading\">List group item heading</h4>\r\n<p class=\"list-group-item-text\">Donec id elit non mi porta gravida at eget metus.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<!-- //List Groups -->\r\n<p> </p>\r\n<!-- Panels -->\r\n<h3 class=\"sub-title\">Panels</h3>\r\n<div class=\"row example-row example-misc\">\r\n<div class=\"col-lg-4\">\r\n<div class=\"panel panel-default\">\r\n<div class=\"panel-heading\">\r\n<h3 class=\"panel-title\">Panel heading</h3>\r\n</div>\r\n<div class=\"panel-body\">Panel content</div>\r\n</div>\r\n<div class=\"panel panel-primary\">\r\n<div class=\"panel-heading\">\r\n<h3 class=\"panel-title\">Panel primary</h3>\r\n</div>\r\n<div class=\"panel-body\">Panel content</div>\r\n</div>\r\n</div>\r\n<div class=\"col-lg-4\">\r\n<div class=\"panel panel-success\">\r\n<div class=\"panel-heading\">\r\n<h3 class=\"panel-title\">Panel success</h3>\r\n</div>\r\n<div class=\"panel-body\">Panel content</div>\r\n</div>\r\n<div class=\"panel panel-warning\">\r\n<div class=\"panel-heading\">\r\n<h3 class=\"panel-title\">Panel warning</h3>\r\n</div>\r\n<div class=\"panel-body\">Panel content</div>\r\n</div>\r\n</div>\r\n<div class=\"col-lg-4\">\r\n<div class=\"panel panel-danger\">\r\n<div class=\"panel-heading\">\r\n<h3 class=\"panel-title\">Panel danger</h3>\r\n</div>\r\n<div class=\"panel-body\">Panel content</div>\r\n</div>\r\n<div class=\"panel panel-info\">\r\n<div class=\"panel-heading\">\r\n<h3 class=\"panel-title\">Panel info</h3>\r\n</div>\r\n<div class=\"panel-body\">Panel content</div>\r\n</div>\r\n</div>\r\n</div>\r\n<!-- //Panels -->\r\n<p> </p>\r\n<!-- Wells -->\r\n<h3 class=\"sub-title\">Wells</h3>\r\n<div class=\"row example-row example-misc\">\r\n<div class=\"col-lg-4\">\r\n<div class=\"well well-sm\">Look, I\'m in a small well!</div>\r\n</div>\r\n<div class=\"col-lg-4\">\r\n<div class=\"well\">Look, I\'m in a well!</div>\r\n</div>\r\n<div class=\"col-lg-4\">\r\n<div class=\"well well-lg\">Look, I\'m in a large well!</div>\r\n</div>\r\n</div>\r\n<!-- //Wells --></div>','',1,2,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',4,2,'','',1,70,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',0,'*','')
,(13,122,'Error Page','error-page','<div class=\"well\">\r\n  <center>Each <strong>JA Joomla Template</strong> has its own matching Offline page. Below is the screenshot of <strong>Offline page style</strong>.</center>\r\n</div>\r\n\r\n<div class=\"demo-image\">\r\n  <p>\r\n    <img src=\"images/joomlart/others/404-page.png\" alt=\"\"/>\r\n  </p>\r\n</div>\r\n','',1,2,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',3,1,'','',1,8,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',0,'*','')
,(14,123,'Offline Page','offline-page','<div class=\"well\">\r\n  <center>Each <strong>JA Joomla Template</strong> has its own matching 404 page. Below is the screenshot of <strong>404 page style</strong>.</center>\r\n</div>\r\n\r\n<div class=\"demo-image\">\r\n  <img src=\"images/joomlart/others/offline-page.png\" alt=\"\"/>\r\n</div>','',1,2,'2021-08-03 08:48:32',42,'','2021-08-25 00:00:00',42,NULL,NULL,'2021-08-25 00:00:00',NULL,'{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}','{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',4,0,'','',1,7,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',0,'*','');
/*!40000 ALTER TABLE `#__content` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maps items from content tables to tags';
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__contentitem_tag_map` DISABLE KEYS */;
INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES 
('com_content.article',2,2,2,'2021-08-03 01:48:32',1)
,('com_content.article',3,3,2,'2021-08-03 01:48:32',1)
,('com_content.article',4,6,2,'2021-08-03 01:48:32',1)
,('com_content.article',5,7,2,'2021-08-03 01:48:32',1)
,('com_content.article',6,8,2,'2021-08-03 01:48:32',1)
,('com_content.article',7,9,2,'2021-08-03 01:48:32',1);
/*!40000 ALTER TABLE `#__contentitem_tag_map` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__content_frontpage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `featured_up` datetime DEFAULT NULL,
  `featured_down` datetime DEFAULT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__content_frontpage` DISABLE KEYS */;
INSERT INTO `#__content_frontpage` (`content_id`, `ordering`, `featured_up`, `featured_down`) VALUES 
(2,7,NULL,NULL)
,(3,8,NULL,NULL)
,(4,9,NULL,NULL)
,(5,4,NULL,NULL)
,(6,5,NULL,NULL)
,(7,6,NULL,NULL)
,(8,1,NULL,NULL)
,(9,2,NULL,NULL)
,(10,3,NULL,NULL);
/*!40000 ALTER TABLE `#__content_frontpage` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__content_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__content_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `content_id` int(11) NOT NULL,
  `meta_key` varchar(255) NOT NULL,
  `meta_value` text NOT NULL,
  `encoded` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Value is stored in encoded format',
  PRIMARY KEY (`id`),
  UNIQUE KEY `content_id` (`content_id`,`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__content_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__content_meta` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__content_rating`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `rating_sum` int(10) unsigned NOT NULL DEFAULT 0,
  `rating_count` int(10) unsigned NOT NULL DEFAULT 0,
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__content_rating` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__content_rating` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__content_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__content_types` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(400) NOT NULL DEFAULT '',
  `table` varchar(2048) NOT NULL DEFAULT '',
  `rules` mediumtext NOT NULL,
  `field_mappings` mediumtext NOT NULL,
  `router` varchar(255) NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__content_types` DISABLE KEYS */;
INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES 
(1,'Article','com_content.article','{\"special\":{\"dbtable\":\"j08b41_content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}','ContentHelperRoute::getArticleRoute','{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"j08b41_categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"j08b41_viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}')
,(2,'Contact','com_contact.contact','{\"special\":{\"dbtable\":\"j08b41_contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}','ContactHelperRoute::getContactRoute','{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"j08b41_categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"j08b41_viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }')
,(3,'Newsfeed','com_newsfeeds.newsfeed','{\"special\":{\"dbtable\":\"j08b41_newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}','NewsfeedsHelperRoute::getNewsfeedRoute','{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"j08b41_categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"j08b41_viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}')
,(4,'User','com_users.user','{\"special\":{\"dbtable\":\"j08b41_users\",\"key\":\"id\",\"type\":\"UserTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"null\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}','','')
,(5,'Article Category','com_content.category','{\"special\":{\"dbtable\":\"j08b41_categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}','ContentHelperRoute::getCategoryRoute','{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"j08b41_viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"j08b41_categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}')
,(6,'Contact Category','com_contact.category','{\"special\":{\"dbtable\":\"j08b41_categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}','ContactHelperRoute::getCategoryRoute','{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"j08b41_viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"j08b41_categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}')
,(7,'Newsfeeds Category','com_newsfeeds.category','{\"special\":{\"dbtable\":\"j08b41_categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}','NewsfeedsHelperRoute::getCategoryRoute','{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"j08b41_viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"j08b41_categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}')
,(8,'Tag','com_tags.tag','{\"special\":{\"dbtable\":\"j08b41_tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}','TagsHelperRoute::getTagRoute','{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"j08b41_viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}')
,(9,'Banner','com_banners.banner','{\"special\":{\"dbtable\":\"j08b41_banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}','','{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"j08b41_categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"j08b41_banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}')
,(10,'Banners Category','com_banners.category','{\"special\":{\"dbtable\":\"j08b41_categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}','','{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"j08b41_viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"j08b41_categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}')
,(11,'Banner Client','com_banners.client','{\"special\":{\"dbtable\":\"j08b41_banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}','','','','{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}')
,(12,'User Notes','com_users.note','{\"special\":{\"dbtable\":\"j08b41_user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}','','','','{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"j08b41_categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}')
,(13,'User Notes Category','com_users.category','{\"special\":{\"dbtable\":\"j08b41_categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"j08b41_ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}','','{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}','','{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"j08b41_viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"j08b41_users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"j08b41_categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');
/*!40000 ALTER TABLE `#__content_types` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__core_log_searches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__core_log_searches` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__core_log_searches` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__extensions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `changelogurl` text DEFAULT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 1,
  `protected` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `manifest_cache` mediumtext NOT NULL,
  `params` mediumtext NOT NULL,
  `custom_data` mediumtext NOT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) DEFAULT 0,
  `state` int(11) DEFAULT 0,
  `note` varchar(255) DEFAULT NULL,
  `locked` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__extensions` DISABLE KEYS */;
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `changelogurl`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `checked_out`, `checked_out_time`, `ordering`, `state`, `note`, `locked`) VALUES 
(2,0,'com_wrapper','component','com_wrapper',NULL,'',1,1,1,0,'{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Wrapper\",\"filename\":\"wrapper\"}','','',NULL,NULL,0,0,NULL,1)
,(3,0,'com_admin','component','com_admin',NULL,'',1,1,1,1,'{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Admin\"}','','',NULL,NULL,0,0,NULL,1)
,(4,0,'com_banners','component','com_banners',NULL,'',1,1,1,0,'{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Banners\",\"filename\":\"banners\"}','{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}','',NULL,NULL,0,0,NULL,1)
,(5,0,'com_cache','component','com_cache',NULL,'',1,1,1,1,'{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cache\"}','','',NULL,NULL,0,0,NULL,1)
,(6,0,'com_categories','component','com_categories',NULL,'',1,1,1,1,'{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Categories\"}','','',NULL,NULL,0,0,NULL,1)
,(7,0,'com_checkin','component','com_checkin',NULL,'',1,1,1,1,'{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Checkin\"}','','',NULL,NULL,0,0,NULL,1)
,(8,0,'com_contact','component','com_contact',NULL,'',1,1,1,0,'{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contact\",\"filename\":\"contact\"}','{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"tabs\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"add_mailto_link\":\"1\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"show_misc\":\"1\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_user_custom_fields\":[\"-1\"],\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_advanced\":0,\"sef_ids\":0,\"custom_fields_enable\":\"1\"}','',NULL,NULL,0,0,NULL,1)
,(9,0,'com_cpanel','component','com_cpanel',NULL,'',1,1,1,1,'{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"2007-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cpanel\"}','','',NULL,NULL,0,0,NULL,1)
,(10,0,'com_installer','component','com_installer',NULL,'',1,1,1,1,'{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Installer\"}','{\"show_jed_info\":\"1\",\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}','',NULL,NULL,0,0,NULL,1)
,(11,0,'com_languages','component','com_languages',NULL,'',1,1,1,1,'{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Languages\"}','{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}','',NULL,NULL,0,0,NULL,1)
,(12,0,'com_login','component','com_login',NULL,'',1,1,1,1,'{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Login\"}','','',NULL,NULL,0,0,NULL,1)
,(13,0,'com_media','component','com_media',NULL,'',1,1,0,1,'{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Media\",\"filename\":\"media\"}','{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}','',NULL,NULL,0,0,NULL,1)
,(14,0,'com_menus','component','com_menus',NULL,'',1,1,1,1,'{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Menus\",\"filename\":\"menus\"}','{\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}','',NULL,NULL,0,0,NULL,1)
,(15,0,'com_messages','component','com_messages',NULL,'',1,1,1,1,'{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Messages\"}','','',NULL,NULL,0,0,NULL,1)
,(16,0,'com_modules','component','com_modules',NULL,'',1,1,1,1,'{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Modules\",\"filename\":\"modules\"}','','',NULL,NULL,0,0,NULL,1)
,(17,0,'com_newsfeeds','component','com_newsfeeds',NULL,'',1,1,1,0,'{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}','{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}','',NULL,NULL,0,0,NULL,1)
,(18,0,'com_plugins','component','com_plugins',NULL,'',1,1,1,1,'{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Plugins\"}','','',NULL,NULL,0,0,NULL,1)
,(20,0,'com_templates','component','com_templates',NULL,'',1,1,1,1,'{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Templates\"}','{\"template_positions_display\":\"0\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,sass\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\",\"difference\":\"SideBySide\"}','',NULL,NULL,0,0,NULL,1)
,(22,0,'com_content','component','com_content',NULL,'',1,1,0,1,'{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Content\",\"filename\":\"content\"}','{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"1\",\"info_block_show_title\":\"0\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_tags\":\"1\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"record_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"6\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_advanced\":0,\"sef_ids\":0,\"custom_fields_enable\":\"1\"}','',NULL,NULL,0,0,NULL,1)
,(23,0,'com_config','component','com_config',NULL,'',1,1,0,1,'{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Config\",\"filename\":\"config\"}','{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}','',NULL,NULL,0,0,NULL,1)
,(24,0,'com_redirect','component','com_redirect',NULL,'',1,1,0,0,'{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Redirect\"}','','',NULL,NULL,0,0,NULL,1)
,(25,0,'com_users','component','com_users',NULL,'',1,1,0,1,'{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Users\",\"filename\":\"users\"}','{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"0\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"domains\":\"\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"minimum_length\":\"4\",\"minimum_integers\":\"0\",\"minimum_symbols\":\"0\",\"minimum_uppercase\":\"0\",\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"debugUsers\":\"1\",\"debugGroups\":\"1\",\"sef_advanced\":0,\"custom_fields_enable\":\"1\"}','',NULL,NULL,0,0,NULL,1)
,(27,0,'com_finder','component','com_finder',NULL,'',1,1,0,0,'{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Finder\",\"filename\":\"finder\"}','{\"enabled\":\"0\",\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"1\",\"show_date_filters\":\"1\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}','',NULL,NULL,0,0,NULL,1)
,(28,0,'com_joomlaupdate','component','com_joomlaupdate',NULL,'',1,1,0,1,'{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Joomlaupdate\"}','{\"updatesource\":\"default\",\"customurl\":\"\"}','',NULL,NULL,0,0,NULL,1)
,(29,0,'com_tags','component','com_tags',NULL,'',1,1,1,0,'{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"2013-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Tags\",\"filename\":\"tags\"}','{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}','',NULL,NULL,0,0,NULL,1)
,(30,0,'com_contenthistory','component','com_contenthistory',NULL,'',1,1,1,0,'{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"2013-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contenthistory\",\"filename\":\"contenthistory\"}','','',NULL,NULL,0,0,NULL,1)
,(31,0,'com_ajax','component','com_ajax',NULL,'',1,1,1,1,'{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}','','',NULL,NULL,0,0,NULL,1)
,(32,0,'com_postinstall','component','com_postinstall',NULL,'',1,1,1,1,'{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Postinstall\"}','','',NULL,NULL,0,0,NULL,1)
,(33,0,'com_fields','component','com_fields',NULL,'',1,1,1,0,'{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Fields\",\"filename\":\"fields\"}','','',NULL,NULL,0,0,NULL,1)
,(34,0,'com_associations','component','com_associations',NULL,'',1,1,1,0,'{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Associations\"}','','',NULL,NULL,0,0,NULL,1)
,(35,0,'com_privacy','component','com_privacy',NULL,'',1,1,1,0,'{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Privacy\",\"filename\":\"privacy\"}','','',NULL,NULL,0,0,NULL,1)
,(36,0,'com_actionlogs','component','com_actionlogs',NULL,'',1,1,1,0,'{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Actionlogs\"}','{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}','',NULL,NULL,0,0,NULL,1)
,(103,0,'lib_joomla','library','joomla',NULL,'',0,1,1,1,'{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}','{\"mediaversion\":\"e8523842c0286f2aebbc3775f1a7971b\"}','',NULL,NULL,0,0,NULL,1)
,(106,0,'lib_phpass','library','phpass',NULL,'',0,1,1,1,'{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-01\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}','','',NULL,NULL,0,0,NULL,1)
,(200,0,'mod_articles_archive','module','mod_articles_archive',NULL,'',0,1,1,0,'{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesArchive\",\"filename\":\"mod_articles_archive\"}','','',NULL,NULL,0,0,NULL,1)
,(201,0,'mod_articles_latest','module','mod_articles_latest',NULL,'',0,1,1,0,'{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesLatest\",\"filename\":\"mod_articles_latest\"}','','',NULL,NULL,0,0,NULL,1)
,(202,0,'mod_articles_popular','module','mod_articles_popular',NULL,'',0,1,1,0,'{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesPopular\",\"filename\":\"mod_articles_popular\"}','','',NULL,NULL,0,0,NULL,1)
,(203,0,'mod_banners','module','mod_banners',NULL,'',0,1,1,0,'{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Banners\",\"filename\":\"mod_banners\"}','','',NULL,NULL,0,0,NULL,1)
,(204,0,'mod_breadcrumbs','module','mod_breadcrumbs',NULL,'',0,1,1,0,'{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Breadcrumbs\",\"filename\":\"mod_breadcrumbs\"}','','',NULL,NULL,0,0,NULL,1)
,(205,0,'mod_custom','module','mod_custom',NULL,'',0,1,1,0,'{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}','','',NULL,NULL,0,0,NULL,1)
,(206,0,'mod_feed','module','mod_feed',NULL,'',0,1,1,0,'{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}','','',NULL,NULL,0,0,NULL,1)
,(207,0,'mod_footer','module','mod_footer',NULL,'',0,1,1,0,'{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Footer\",\"filename\":\"mod_footer\"}','','',NULL,NULL,0,0,NULL,1)
,(208,0,'mod_login','module','mod_login',NULL,'',0,1,1,0,'{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}','','',NULL,NULL,0,0,NULL,1)
,(209,0,'mod_menu','module','mod_menu',NULL,'',0,1,1,0,'{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}','','',NULL,NULL,0,0,NULL,1)
,(210,0,'mod_articles_news','module','mod_articles_news',NULL,'',0,1,1,0,'{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesNews\",\"filename\":\"mod_articles_news\"}','','',NULL,NULL,0,0,NULL,1)
,(211,0,'mod_random_image','module','mod_random_image',NULL,'',0,1,1,0,'{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RandomImage\",\"filename\":\"mod_random_image\"}','','',NULL,NULL,0,0,NULL,1)
,(212,0,'mod_related_items','module','mod_related_items',NULL,'',0,1,1,0,'{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RelatedItems\",\"filename\":\"mod_related_items\"}','','',NULL,NULL,0,0,NULL,1)
,(214,0,'mod_stats','module','mod_stats',NULL,'',0,1,1,0,'{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Stats\",\"filename\":\"mod_stats\"}','','',NULL,NULL,0,0,NULL,1)
,(215,0,'mod_syndicate','module','mod_syndicate',NULL,'',0,1,1,0,'{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"2006-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Syndicate\",\"filename\":\"mod_syndicate\"}','','',NULL,NULL,0,0,NULL,1)
,(216,0,'mod_users_latest','module','mod_users_latest',NULL,'',0,1,1,0,'{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"2009-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\UsersLatest\",\"filename\":\"mod_users_latest\"}','','',NULL,NULL,0,0,NULL,1)
,(218,0,'mod_whosonline','module','mod_whosonline',NULL,'',0,1,1,0,'{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Whosonline\",\"filename\":\"mod_whosonline\"}','','',NULL,NULL,0,0,NULL,1)
,(219,0,'mod_wrapper','module','mod_wrapper',NULL,'',0,1,1,0,'{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"2004-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Wrapper\",\"filename\":\"mod_wrapper\"}','','',NULL,NULL,0,0,NULL,1)
,(220,0,'mod_articles_category','module','mod_articles_category',NULL,'',0,1,1,0,'{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategory\",\"filename\":\"mod_articles_category\"}','','',NULL,NULL,0,0,NULL,1)
,(221,0,'mod_articles_categories','module','mod_articles_categories',NULL,'',0,1,1,0,'{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategories\",\"filename\":\"mod_articles_categories\"}','','',NULL,NULL,0,0,NULL,1)
,(222,0,'mod_languages','module','mod_languages',NULL,'',0,1,1,0,'{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Languages\",\"filename\":\"mod_languages\"}','','',NULL,NULL,0,0,NULL,1)
,(223,0,'mod_finder','module','mod_finder',NULL,'',0,1,0,0,'{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Finder\",\"filename\":\"mod_finder\"}','','',NULL,NULL,0,0,NULL,1)
,(300,0,'mod_custom','module','mod_custom',NULL,'',1,1,1,0,'{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}','','',NULL,NULL,0,0,NULL,1)
,(301,0,'mod_feed','module','mod_feed',NULL,'',1,1,1,0,'{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}','','',NULL,NULL,0,0,NULL,1)
,(302,0,'mod_latest','module','mod_latest',NULL,'',1,1,1,0,'{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Latest\",\"filename\":\"mod_latest\"}','','',NULL,NULL,0,0,NULL,1)
,(303,0,'mod_logged','module','mod_logged',NULL,'',1,1,1,0,'{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"2005-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Logged\",\"filename\":\"mod_logged\"}','','',NULL,NULL,0,0,NULL,1)
,(304,0,'mod_login','module','mod_login',NULL,'',1,1,1,0,'{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2005-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}','','',NULL,NULL,0,0,NULL,1)
,(305,0,'mod_menu','module','mod_menu',NULL,'',1,1,1,0,'{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}','','',NULL,NULL,0,0,NULL,1)
,(307,0,'mod_popular','module','mod_popular',NULL,'',1,1,1,0,'{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Popular\",\"filename\":\"mod_popular\"}','','',NULL,NULL,0,0,NULL,1)
,(308,0,'mod_quickicon','module','mod_quickicon',NULL,'',1,1,1,0,'{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Quickicon\",\"filename\":\"mod_quickicon\"}','','',NULL,NULL,0,0,NULL,1)
,(311,0,'mod_title','module','mod_title',NULL,'',1,1,1,0,'{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}','','',NULL,NULL,0,0,NULL,1)
,(312,0,'mod_toolbar','module','mod_toolbar',NULL,'',1,1,1,0,'{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}','','',NULL,NULL,0,0,NULL,1)
,(313,0,'mod_multilangstatus','module','mod_multilangstatus',NULL,'',1,1,1,0,'{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"2011-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}','{\"cache\":\"0\"}','',NULL,NULL,0,0,NULL,1)
,(314,0,'mod_version','module','mod_version',NULL,'',1,1,1,0,'{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"2012-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Version\",\"filename\":\"mod_version\"}','{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}','',NULL,NULL,0,0,NULL,1)
,(315,0,'mod_stats_admin','module','mod_stats_admin',NULL,'',1,1,1,0,'{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\StatsAdmin\",\"filename\":\"mod_stats_admin\"}','{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}','',NULL,NULL,0,0,NULL,1)
,(316,0,'mod_tags_popular','module','mod_tags_popular',NULL,'',0,1,1,0,'{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsPopular\",\"filename\":\"mod_tags_popular\"}','{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}','',NULL,NULL,0,0,NULL,1)
,(317,0,'mod_tags_similar','module','mod_tags_similar',NULL,'',0,1,1,0,'{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsSimilar\",\"filename\":\"mod_tags_similar\"}','{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}','',NULL,NULL,0,0,NULL,1)
,(318,0,'mod_sampledata','module','mod_sampledata',NULL,'',1,1,1,0,'{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Sampledata\",\"filename\":\"mod_sampledata\"}','{}','',NULL,NULL,0,0,NULL,1)
,(319,0,'mod_latestactions','module','mod_latestactions',NULL,'',1,1,1,0,'{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\LatestActions\",\"filename\":\"mod_latestactions\"}','{}','',NULL,NULL,0,0,NULL,1)
,(320,0,'mod_privacy_dashboard','module','mod_privacy_dashboard',NULL,'',1,1,1,0,'{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyDashboard\",\"filename\":\"mod_privacy_dashboard\"}','{}','',NULL,NULL,0,0,NULL,1)
,(401,0,'plg_authentication_joomla','plugin','joomla',NULL,'authentication',0,1,1,1,'{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Joomla\",\"filename\":\"joomla\"}','','',NULL,NULL,0,0,NULL,1)
,(402,0,'plg_authentication_ldap','plugin','ldap',NULL,'authentication',0,0,1,0,'{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Ldap\",\"filename\":\"ldap\"}','{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}','',NULL,NULL,3,0,NULL,1)
,(403,0,'plg_content_contact','plugin','contact',NULL,'content',0,1,1,0,'{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"2014-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Contact\",\"filename\":\"contact\"}','','',NULL,NULL,1,0,NULL,1)
,(404,0,'plg_content_emailcloak','plugin','emailcloak',NULL,'content',0,1,1,0,'{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\EmailCloak\",\"filename\":\"emailcloak\"}','{\"mode\":\"1\"}','',NULL,NULL,1,0,NULL,1)
,(406,0,'plg_content_loadmodule','plugin','loadmodule',NULL,'content',0,1,1,0,'{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}','{\"style\":\"xhtml\"}','',NULL,'2011-09-18 15:22:50',0,0,NULL,1)
,(407,0,'plg_content_pagebreak','plugin','pagebreak',NULL,'content',0,1,1,0,'{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}','{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}','',NULL,NULL,4,0,NULL,1)
,(408,0,'plg_content_pagenavigation','plugin','pagenavigation',NULL,'content',0,1,1,0,'{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"2006-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}','{\"position\":\"1\"}','',NULL,NULL,5,0,NULL,1)
,(409,0,'plg_content_vote','plugin','vote',NULL,'content',0,0,1,0,'{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}','','',NULL,NULL,6,0,NULL,1)
,(410,0,'plg_editors_codemirror','plugin','codemirror',NULL,'editors',0,1,1,0,'{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"5.65.12\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\CodeMirror\",\"filename\":\"codemirror\"}','{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}','',NULL,NULL,1,0,NULL,1)
,(411,0,'plg_editors_none','plugin','none',NULL,'editors',0,1,1,1,'{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"2005-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\None\",\"filename\":\"none\"}','','',NULL,NULL,2,0,NULL,1)
,(412,0,'plg_editors_tinymce','plugin','tinymce',NULL,'editors',0,1,1,0,'{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-08\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"5.10.7\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\TinyMCE\",\"filename\":\"tinymce\"}','{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"formatselect\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styleselect\",\"|\",\"formatselect\",\"fontselect\",\"fontsizeselect\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"template\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}','',NULL,NULL,3,0,NULL,1)
,(413,0,'plg_editors-xtd_article','plugin','article',NULL,'editors-xtd',0,1,1,0,'{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"2009-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Article\",\"filename\":\"article\"}','','',NULL,NULL,1,0,NULL,1)
,(414,0,'plg_editors-xtd_image','plugin','image',NULL,'editors-xtd',0,1,1,0,'{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Image\",\"filename\":\"image\"}','','',NULL,NULL,2,0,NULL,1)
,(415,0,'plg_editors-xtd_pagebreak','plugin','pagebreak',NULL,'editors-xtd',0,1,1,0,'{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}','','',NULL,NULL,3,0,NULL,1)
,(416,0,'plg_editors-xtd_readmore','plugin','readmore',NULL,'editors-xtd',0,1,1,0,'{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\ReadMore\",\"filename\":\"readmore\"}','','',NULL,NULL,4,0,NULL,1)
,(422,0,'plg_system_languagefilter','plugin','languagefilter',NULL,'system',0,0,1,0,'{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"2010-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}','','',NULL,NULL,1,0,NULL,1)
,(424,0,'plg_system_cache','plugin','cache',NULL,'system',0,0,1,0,'{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"2007-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Cache\",\"filename\":\"cache\"}','{\"browsercache\":\"0\",\"cachetime\":\"15\"}','',NULL,NULL,9,0,NULL,1)
,(425,0,'plg_system_debug','plugin','debug',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Debug\",\"filename\":\"debug\"}','{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}','',NULL,NULL,4,0,NULL,1)
,(426,0,'plg_system_log','plugin','log',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}','','',NULL,NULL,5,0,NULL,1)
,(427,0,'plg_system_redirect','plugin','redirect',NULL,'system',0,0,1,0,'{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}','','',NULL,NULL,3,0,NULL,1)
,(428,0,'plg_system_remember','plugin','remember',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}','','',NULL,NULL,7,0,NULL,1)
,(429,0,'plg_system_sef','plugin','sef',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}','','',NULL,NULL,8,0,NULL,1)
,(430,0,'plg_system_logout','plugin','logout',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}','','',NULL,NULL,6,0,NULL,1)
,(431,0,'plg_user_contactcreator','plugin','contactcreator',NULL,'user',0,0,1,0,'{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"2009-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}','{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}','',NULL,NULL,1,0,NULL,1)
,(432,0,'plg_user_joomla','plugin','joomla',NULL,'user',0,1,1,0,'{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}','{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}','',NULL,NULL,2,0,NULL,1)
,(433,0,'plg_user_profile','plugin','profile',NULL,'user',0,0,1,0,'{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Profile\",\"filename\":\"profile\"}','{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}','',NULL,NULL,0,0,NULL,1)
,(434,0,'plg_extension_joomla','plugin','joomla',NULL,'extension',0,1,1,0,'{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomla\",\"filename\":\"joomla\"}','','',NULL,NULL,1,0,NULL,1)
,(435,0,'plg_content_joomla','plugin','joomla',NULL,'content',0,1,1,0,'{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}','','',NULL,NULL,0,0,NULL,1)
,(436,0,'plg_system_languagecode','plugin','languagecode',NULL,'system',0,0,1,0,'{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"2011-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}','','',NULL,NULL,10,0,NULL,1)
,(437,0,'plg_quickicon_joomlaupdate','plugin','joomlaupdate',NULL,'quickicon',0,1,1,0,'{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}','','',NULL,NULL,0,0,NULL,1)
,(438,0,'plg_quickicon_extensionupdate','plugin','extensionupdate',NULL,'quickicon',0,1,1,0,'{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Extensionupdate\",\"filename\":\"extensionupdate\"}','','',NULL,NULL,0,0,NULL,1)
,(439,0,'plg_captcha_recaptcha','plugin','recaptcha',NULL,'captcha',0,1,1,0,'{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Captcha\\\\ReCaptcha\",\"filename\":\"recaptcha\"}','{\"version\":\"2.0\",\"public_key\":\"6LeWuHYUAAAAAC-B4cfZSuyicWdJhBTp4Tf8f904\",\"private_key\":\"6LeWuHYUAAAAAHiAsGRCwPy5ZbPD1WdWTp-mQZlb\",\"theme\":\"clean\",\"theme2\":\"light\",\"size\":\"normal\",\"tabindex\":\"0\",\"callback\":\"\",\"expired_callback\":\"\",\"error_callback\":\"\"}','',NULL,NULL,0,0,NULL,1)
,(440,0,'plg_system_highlight','plugin','highlight',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}','','',NULL,NULL,7,0,NULL,1)
,(441,0,'plg_content_finder','plugin','finder',NULL,'content',0,0,1,0,'{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}','','',NULL,NULL,0,0,NULL,1)
,(442,0,'plg_finder_categories','plugin','categories',NULL,'finder',0,1,1,0,'{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Categories\",\"filename\":\"categories\"}','','',NULL,NULL,1,0,NULL,1)
,(443,0,'plg_finder_contacts','plugin','contacts',NULL,'finder',0,1,1,0,'{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Contacts\",\"filename\":\"contacts\"}','','',NULL,NULL,2,0,NULL,1)
,(444,0,'plg_finder_content','plugin','content',NULL,'finder',0,1,1,0,'{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Content\",\"filename\":\"content\"}','','',NULL,NULL,3,0,NULL,1)
,(445,0,'plg_finder_newsfeeds','plugin','newsfeeds',NULL,'finder',0,1,1,0,'{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}','','',NULL,NULL,4,0,NULL,1)
,(447,0,'plg_finder_tags','plugin','tags',NULL,'finder',0,1,1,0,'{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"2013-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Tags\",\"filename\":\"tags\"}','','',NULL,NULL,0,0,NULL,1)
,(449,0,'plg_authentication_cookie','plugin','cookie',NULL,'authentication',0,1,1,0,'{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"2013-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Cookie\",\"filename\":\"cookie\"}','','',NULL,NULL,0,0,NULL,1)
,(452,0,'plg_system_updatenotification','plugin','updatenotification',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"2015-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}','{\"lastrun\":1681959283}','',NULL,NULL,0,0,NULL,1)
,(453,0,'plg_editors-xtd_module','plugin','module',NULL,'editors-xtd',0,1,1,0,'{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"2015-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Module\",\"filename\":\"module\"}','','',NULL,NULL,0,0,NULL,1)
,(454,0,'plg_system_stats','plugin','stats',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"2013-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Stats\",\"filename\":\"stats\"}','{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"c3e493a022310865ddac6b7a1a3fa1fe8f423ac1\",\"interval\":12}','',NULL,NULL,0,0,NULL,1)
,(455,0,'plg_installer_packageinstaller','plugin','packageinstaller',NULL,'installer',0,1,1,0,'{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}','','',NULL,NULL,1,0,NULL,1)
,(456,0,'plg_installer_folderinstaller','plugin','folderinstaller',NULL,'installer',0,1,1,0,'{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}','','',NULL,NULL,2,0,NULL,1)
,(457,0,'plg_installer_urlinstaller','plugin','urlinstaller',NULL,'installer',0,1,1,0,'{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}','','',NULL,NULL,3,0,NULL,1)
,(458,0,'plg_quickicon_phpversioncheck','plugin','phpversioncheck',NULL,'quickicon',0,1,1,0,'{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PhpVersionCheck\",\"filename\":\"phpversioncheck\"}','','',NULL,NULL,0,0,NULL,1)
,(459,0,'plg_editors-xtd_menu','plugin','menu',NULL,'editors-xtd',0,1,1,0,'{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Menu\",\"filename\":\"menu\"}','','',NULL,NULL,0,0,NULL,1)
,(460,0,'plg_editors-xtd_contact','plugin','contact',NULL,'editors-xtd',0,1,1,0,'{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"2016-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Contact\",\"filename\":\"contact\"}','','',NULL,NULL,0,0,NULL,1)
,(461,0,'plg_system_fields','plugin','fields',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}','','',NULL,NULL,0,0,NULL,1)
,(462,0,'plg_fields_calendar','plugin','calendar',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Calendar\",\"filename\":\"calendar\"}','','',NULL,NULL,0,0,NULL,1)
,(463,0,'plg_fields_checkboxes','plugin','checkboxes',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Checkboxes\",\"filename\":\"checkboxes\"}','','',NULL,NULL,0,0,NULL,1)
,(464,0,'plg_fields_color','plugin','color',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Color\",\"filename\":\"color\"}','','',NULL,NULL,0,0,NULL,1)
,(465,0,'plg_fields_editor','plugin','editor',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Editor\",\"filename\":\"editor\"}','','',NULL,NULL,0,0,NULL,1)
,(466,0,'plg_fields_imagelist','plugin','imagelist',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Imagelist\",\"filename\":\"imagelist\"}','','',NULL,NULL,0,0,NULL,1)
,(467,0,'plg_fields_integer','plugin','integer',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Integer\",\"filename\":\"integer\"}','{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}','',NULL,NULL,0,0,NULL,1)
,(468,0,'plg_fields_list','plugin','list',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\ListField\",\"filename\":\"list\"}','','',NULL,NULL,0,0,NULL,1)
,(469,0,'plg_fields_media','plugin','media',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Media\",\"filename\":\"media\"}','','',NULL,NULL,0,0,NULL,1)
,(470,0,'plg_fields_radio','plugin','radio',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Radio\",\"filename\":\"radio\"}','','',NULL,NULL,0,0,NULL,1)
,(471,0,'plg_fields_sql','plugin','sql',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\SQL\",\"filename\":\"sql\"}','','',NULL,NULL,0,0,NULL,1)
,(472,0,'plg_fields_text','plugin','text',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Text\",\"filename\":\"text\"}','','',NULL,NULL,0,0,NULL,1)
,(473,0,'plg_fields_textarea','plugin','textarea',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Textarea\",\"filename\":\"textarea\"}','','',NULL,NULL,0,0,NULL,1)
,(474,0,'plg_fields_url','plugin','url',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Url\",\"filename\":\"url\"}','','',NULL,NULL,0,0,NULL,1)
,(475,0,'plg_fields_user','plugin','user',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\User\",\"filename\":\"user\"}','','',NULL,NULL,0,0,NULL,1)
,(476,0,'plg_fields_usergrouplist','plugin','usergrouplist',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\UsergroupList\",\"filename\":\"usergrouplist\"}','','',NULL,NULL,0,0,NULL,1)
,(477,0,'plg_content_fields','plugin','fields',NULL,'content',0,1,1,0,'{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Fields\",\"filename\":\"fields\"}','','',NULL,NULL,0,0,NULL,1)
,(478,0,'plg_editors-xtd_fields','plugin','fields',NULL,'editors-xtd',0,1,1,0,'{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Fields\",\"filename\":\"fields\"}','','',NULL,NULL,0,0,NULL,1)
,(479,0,'plg_sampledata_blog','plugin','blog',NULL,'sampledata',0,1,1,0,'{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}','','',NULL,NULL,0,0,NULL,1)
,(480,0,'plg_system_sessiongc','plugin','sessiongc',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"2018-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sessiongc\"}','','',NULL,NULL,0,0,NULL,1)
,(482,0,'plg_content_confirmconsent','plugin','confirmconsent',NULL,'content',0,0,1,0,'{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\ConfirmConsent\",\"filename\":\"confirmconsent\"}','{\"consentbox_text\":\"\",\"privacy_article\":\"\"}','',NULL,NULL,0,0,NULL,1)
,(485,0,'plg_system_privacyconsent','plugin','privacyconsent',NULL,'system',0,0,1,0,'{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}','{\"privacy_note\":\"\",\"privacy_article\":5,\"messageOnRedirect\":\"\",\"enabled\":0,\"cachetimeout\":30,\"consentexpiration\":360,\"remind\":30,\"lastrun\":0}','',NULL,NULL,0,0,NULL,1)
,(486,0,'plg_system_logrotation','plugin','logrotation',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logrotation\"}','{\"lastrun\":1681959284}','',NULL,NULL,0,0,NULL,1)
,(487,0,'plg_privacy_user','plugin','user',NULL,'privacy',0,1,1,0,'{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}','{}','',NULL,NULL,0,0,NULL,1)
,(488,0,'plg_quickicon_privacycheck','plugin','privacycheck',NULL,'quickicon',0,1,1,0,'{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PrivacyCheck\",\"filename\":\"privacycheck\"}','{}','',NULL,NULL,0,0,NULL,1)
,(489,0,'plg_user_terms','plugin','terms',NULL,'user',0,0,1,0,'{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Terms\",\"filename\":\"terms\"}','{\"terms_note\":\"\",\"terms_article\":8}','',NULL,NULL,0,0,NULL,1)
,(490,0,'plg_privacy_contact','plugin','contact',NULL,'privacy',0,1,1,0,'{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}','{}','',NULL,NULL,0,0,NULL,1)
,(491,0,'plg_privacy_content','plugin','content',NULL,'privacy',0,1,1,0,'{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}','{}','',NULL,NULL,0,0,NULL,1)
,(492,0,'plg_privacy_message','plugin','message',NULL,'privacy',0,1,1,0,'{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"message\"}','{}','',NULL,NULL,0,0,NULL,1)
,(493,0,'plg_privacy_actionlogs','plugin','actionlogs',NULL,'privacy',0,1,1,0,'{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}','{}','',NULL,NULL,0,0,NULL,1)
,(494,0,'plg_captcha_recaptcha_invisible','plugin','recaptcha_invisible',NULL,'captcha',0,0,1,0,'{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"2017-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Captcha\\\\InvisibleReCaptcha\",\"filename\":\"recaptcha_invisible\"}','{\"public_key\":\"6LeWuHYUAAAAAC-B4cfZSuyicWdJhBTp4Tf8f904\",\"private_key\":\"6LeWuHYUAAAAAHiAsGRCwPy5ZbPD1WdWTp-mQZlb\",\"badge\":\"bottomright\",\"tabindex\":0,\"callback\":\"\",\"expired_callback\":\"\",\"error_callback\":\"\"}','',NULL,NULL,0,0,NULL,1)
,(495,0,'plg_privacy_consents','plugin','consents',NULL,'privacy',0,1,1,0,'{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"consents\"}','{}','',NULL,NULL,0,0,NULL,1)
,(600,802,'English (en-GB)','language','en-GB',NULL,'',0,1,1,1,'{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2023-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"en-GB site language\",\"group\":\"\"}','','',NULL,NULL,0,0,NULL,1)
,(601,802,'English (en-GB)','language','en-GB',NULL,'',1,1,1,1,'{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2023-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"en-GB administrator language\",\"group\":\"\"}','','',NULL,NULL,0,0,NULL,1)
,(700,0,'files_joomla','file','joomla',NULL,'',0,1,1,1,'{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"2023-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}','','',NULL,NULL,0,0,NULL,1)
,(802,0,'English (en-GB) Language Pack','package','pkg_en-GB',NULL,'',0,1,1,1,'{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"2023-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}','','',NULL,NULL,0,0,NULL,1)
,(10000,0,'MOD_JA_ACM','module','mod_ja_acm','','',0,1,1,0,'{\"name\":\"MOD_JA_ACM\",\"type\":\"module\",\"creationDate\":\"February 07th, 2023\",\"author\":\"JoomlArt\",\"copyright\":\"Copyright \\u00a9 2005 - 2021 JoomlArt.com. All Rights Reserved.\",\"authorEmail\":\"info@joomlart.com\",\"authorUrl\":\"www.joomlart.com\",\"version\":\"2.3.4\",\"description\":\"\\n\\t\\t\\n\\t\\t<div align=\\\"left\\\">\\t\\t\\n\\t\\t\\t<div>\\n\\t\\t\\t\\t<h1>JA ACM Module for Joomla 3.x and Joomla 4<\\/h1>\\n\\t\\t\\t\\t<div style=\'font-weight: normal\'>\\n\\t\\t\\t\\t\\t<p>JA ACM module (JoomlArt Advanced Custom module) is to help you build content blocks for your Joomla site easily based on pre-made layouts and styles. The content blocks together will build a landing page or a complete site for you. <\\/p>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t<\\/div>\\n\\t\\t\\t<br \\/>\\n\\t\\t\\t<p>Highlighted features:<\\/p>\\n\\t\\t\\t<div style=\'font-weight: normal\'>\\n\\t\\t\\t\\t<ul>\\n\\t\\t\\t\\t\\t<li style=\\\"padding:10px 0px 10px 20px;\\\">12+ block types: At this phase, we round up typical blocks that Uber has to offer. Each block type comes with multiple styles.<\\/li>\\n\\t\\t\\t\\t\\t<li style=\\\"padding:10px 0px 10px 20px;\\\">Easy editing & defining your page-specific field sets within each block. Each block has its own LESS file, so you have full control to define your own class and style.<\\/li>\\n\\t\\t\\t\\t\\t<li style=\\\"padding:10px 0px 10px 20px;\\\">Content-creator-friendly: completely separate content & design. No longer mixing HTML syntax embedded inside article.<\\/li>\\n\\t\\t\\t\\t\\t<li style=\\\"padding:10px 0px 10px 20px;\\\">Allow us to dig deeper into the modular block approach which eases our page management effort.<\\/li>\\n\\t\\t\\t\\t<\\/ul>\\n\\t\\t\\t<\\/div>\\n\\t\\t\\t<br \\/>\\n\\t\\t\\t\\n\\t\\t<\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_ja_acm\"}','{\"jatools-config\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}','',NULL,NULL,0,0,NULL,0)
,(10001,0,'JA Masthead','module','mod_jamasthead','','',0,1,1,0,'{\"name\":\"JA Masthead\",\"type\":\"module\",\"creationDate\":\"November 24th, 2022\",\"author\":\"JoomlArt.com\",\"copyright\":\"J.O.O.M Solutions Co., Ltd.\",\"authorEmail\":\"admin@joomlart.com\",\"authorUrl\":\"www.joomlart.com\",\"version\":\"1.1.4\",\"description\":\"\\n\\t\\t\\n\\t\\t<div align=\\\"left\\\">\\t\\t\\n\\t\\t\\t<h2>JA Masthead Module for Joomla 3.x and Joomla 4<\\/h2>\\n\\t\\t\\t<p>JA Masthead Module is used to Masthead title like the JoomlArt Masthead. With this module, the Masshead can be configured to be in any pages with different titles, descriptions as well as background images and background video. For video background, it supports local video with types: .mp4, ogg, webm.<\\/p>\\n\\n\\t\\t\\t<p><span style=\'color: #008000;\'><strong>Links:<\\/strong><\\/span><\\/p>\\n\\t\\t\\t  <ul>\\n\\t\\t\\t  \\t<li><a target=\'_blank\' href=\'https:\\/\\/www.joomlart.com\\/documentation\\/joomla-module\\/ja-masthead\'>Userguide<\\/a><\\/li>\\n\\t\\t\\t  \\t<li><a target=\'_blank\' href=\'https:\\/\\/www.joomlart.com\\/forums\\/t\\/ja-masthead\'>Support Forum<\\/a><\\/li>\\n\\t\\t\\t  <\\/ul>\\n\\t\\t<\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_jamasthead\"}','{\"default-title\":\"\",\"default-description\":\"\"}','',NULL,NULL,0,0,NULL,0)
,(10002,0,'T3 Framework','plugin','t3','','system',0,1,1,0,'{\"name\":\"T3 Framework\",\"type\":\"plugin\",\"creationDate\":\"April 11th, 2023\",\"author\":\"JoomlArt.com\",\"copyright\":\"Copyright (C) 2005 - 2022 Open Source Matters. All rights reserved.\",\"authorEmail\":\"info@joomlart.com\",\"authorUrl\":\"http:\\/\\/www.t3-framework.org\",\"version\":\"3.1.3\",\"description\":\"\\n\\t\\n\\t<div align=\\\"center\\\">\\n\\t\\t<div class=\\\"alert alert-success\\\" style=\\\"background-color:#DFF0D8;border-color:#D6E9C6;color: #468847;padding: 1px 0;\\\">\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/t3-framework.org\\/\\\"><img src=\\\"http:\\/\\/static.joomlart.com\\/images\\/jat3v3-documents\\/message-installation\\/logo.png\\\" alt=\\\"some_text\\\" width=\\\"300\\\" height=\\\"99\\\"><\\/a>\\n\\t\\t\\t\\t<h4><a href=\\\"http:\\/\\/t3-framework.org\\/\\\" title=\\\"\\\">Home<\\/a> | <a href=\\\"http:\\/\\/demo.t3-framework.org\\/\\\" title=\\\"\\\">Demo<\\/a> | <a href=\\\"http:\\/\\/t3-framework.org\\/documentation\\\" title=\\\"\\\">Document<\\/a> | <a href=\\\"https:\\/\\/github.com\\/t3framework\\/t3\\/blob\\/master\\/CHANGELOG.md\\\" title=\\\"\\\">Changelog<\\/a><\\/h4>\\n\\t\\t<p> <\\/p>\\n\\t\\t<p>Copyright 2004 - 2021 <a href=\'http:\\/\\/www.joomlart.com\\/\' title=\'Visit Joomlart.com!\'>JoomlArt.com<\\/a>.<\\/p>\\n\\t\\t<\\/div>\\n     <style>table.adminform{width: 100%;}<\\/style>\\n\\t <\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"t3\"}','{}','',NULL,NULL,0,0,NULL,0)
,(10003,0,'ja_sensei','template','ja_sensei',NULL,'',0,1,1,0,'{\"name\":\"ja_sensei\",\"type\":\"template\",\"creationDate\":\"October 7th, 2022\",\"author\":\"JoomlArt.com\",\"copyright\":\"Copyright (C), J.O.O.M Solutions Co., Ltd. All Rights Reserved.\",\"authorEmail\":\"webmaster@joomlart.com\",\"authorUrl\":\"http:\\/\\/www.t3-framework.org\",\"version\":\"2.0.3\",\"description\":\"\\n\\t\\t\\n\\t\\t<div align=\\\"center\\\">\\n\\t\\t\\t<div class=\\\"alert alert-success\\\" style=\\\"background-color:#DFF0D8;border-color:#D6E9C6;color: #468847;padding: 1px 0;\\\">\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/t3-framework.org\\/\\\"><img src=\\\"http:\\/\\/static.joomlart.com\\/images\\/jat3v3-documents\\/message-installation\\/logo.png\\\" alt=\\\"some_text\\\" width=\\\"300\\\" height=\\\"99\\\"><\\/a>\\n\\t\\t\\t\\t<h4><a href=\\\"http:\\/\\/t3-framework.org\\/\\\" title=\\\"\\\">Home<\\/a> | <a href=\\\"http:\\/\\/demo.t3-framework.org\\/\\\" title=\\\"\\\">Demo<\\/a> | <a href=\\\"http:\\/\\/t3-framework.org\\/documentation\\\" title=\\\"\\\">Document<\\/a> | <a href=\\\"https:\\/\\/github.com\\/t3framework\\/t3\\/blob\\/master\\/CHANGELOG.md\\\" title=\\\"\\\">Changelog<\\/a><\\/h4>\\n\\t\\t\\t\\t<p> <\\/p>\\n\\t\\t\\t\\t<span style=\\\"color:#FF0000\\\">Note: T3 blank requires T3 plugin to be installed and enabled.<\\/span><p><\\/p>\\n\\t\\t\\t\\t<p>Copyright 2004 - 2019 <a href=\'http:\\/\\/www.joomlart.com\\/\' title=\'Visit Joomlart.com!\'>JoomlArt.com<\\/a>.<\\/p>\\n\\t\\t\\t<\\/div>\\n\\t\\t\\t<style>table.adminform{width: 100%;}<\\/style>\\n\\t\\t<\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"templateDetails\"}','{}','',NULL,NULL,0,0,NULL,0)
,(10015,0,'com_jaextmanager','component','com_jaextmanager',NULL,'',1,1,0,0,'{\"name\":\"com_jaextmanager\",\"type\":\"component\",\"creationDate\":\"November 24th, 2022\",\"author\":\"JoomlArt\",\"copyright\":\"Copyright (C), J.O.O.M Solutions Co., Ltd. All Rights Reserved.\",\"authorEmail\":\"webmaster@joomlart.com\",\"authorUrl\":\"http:\\/\\/www.joomlart.com\",\"version\":\"2.7.5\",\"description\":\"JA Extension Manager Component\",\"group\":\"\"}','{}','',NULL,NULL,0,0,NULL,0)
,(10016,0,'JA Login','module','mod_jalogin','','',0,1,0,0,'{\"name\":\"JA Login\",\"type\":\"module\",\"creationDate\":\"June 9th, 2022\",\"author\":\"JoomlArt.com\",\"copyright\":\"J.O.O.M Solutions Co., Ltd.\",\"authorEmail\":\"admin@joomlart.com\",\"authorUrl\":\"www.joomlart.com\",\"version\":\"2.8.2\",\"description\":\"\\n\\t \\n\\t \\t<div align=\\\"left\\\">\\t\\t\\n\\t\\t\\t<h2>JA Login Module for Joomla! 3 & Joomla 4<\\/h2>\\n\\t\\t\\t<p><img alt=\\\"JA Login Module\\\" src=\\\"https:\\/\\/static.joomlart.com\\/images\\/ecosys\\/icons\\/joomlart\\/ja-login-module.png\\\" \\/><\\/p>\\n\\t\\t\\t<p>JA login module is alternate login module for Joomla!, so that CSS overrides can be made for the same, without affecting the default Joomla login module.<\\/p>\\n\\t \\t\\n\\t\\t\\t<p><span style=\'color: #008000;\'><strong>Links:<\\/strong><\\/span><\\/p>\\n\\t\\t\\t  <ul>\\n\\t\\t\\t  \\t<li><a target=\'_blank\' href=\'https:\\/\\/www.joomlart.com\\/documentation\\/joomla-module\\/ja-login-module\'>Userguide<\\/a><\\/li>\\n\\t\\t\\t  \\t<li><a target=\'_blank\' href=\'https:\\/\\/www.joomlart.com\\/forums\\/t\\/ja-login\'>Support Forum<\\/a><\\/li>\\n\\t\\t\\t  <\\/ul>\\n\\t\\t<\\/div>\\n\\t \\t\\n\\t \\n\\t\",\"group\":\"\",\"filename\":\"mod_jalogin\"}','{\"pretext\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"show_register_form\":\"1\"}','',NULL,NULL,0,0,NULL,0)
,(10017,0,'Ajax - JA Content Type','plugin','jacontenttype','','ajax',0,0,1,0,'{\"name\":\"Ajax - JA Content Type\",\"type\":\"plugin\",\"creationDate\":\"August 31, 2021\",\"author\":\"JoomlArt\",\"copyright\":\"(C) 2014 Joomlart. All rights reserved.\",\"authorEmail\":\"webmaster@joomlart.com\",\"authorUrl\":\"www.joomlart.com\",\"version\":\"1.2.0\",\"description\":\"JA Content Type Plugin\",\"group\":\"\",\"filename\":\"jacontenttype\"}','{}','',NULL,NULL,0,0,NULL,0)
,(10023,0,'System - JA Content Type','plugin','jacontenttype',NULL,'system',0,0,1,0,'{\"name\":\"System - JA Content Type\",\"type\":\"plugin\",\"creationDate\":\"March 07,2023\",\"author\":\"JoomlArt\",\"copyright\":\"(C) 2015 - 2021 Joomlart. All rights reserved.\",\"authorEmail\":\"webmaster@joomlart.com\",\"authorUrl\":\"www.joomlart.com\",\"version\":\"1.2.2\",\"description\":\"JA System Type Plugin\",\"group\":\"\",\"filename\":\"jacontenttype\"}','{\"status\":\"\"}','',NULL,NULL,0,0,NULL,0)
,(10033,0,'plg_behaviour_taggable','plugin','taggable',NULL,'behaviour',0,1,1,0,'{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Taggable\",\"filename\":\"taggable\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10034,0,'plg_behaviour_versionable','plugin','versionable',NULL,'behaviour',0,1,1,0,'{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Versionable\",\"filename\":\"versionable\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10035,0,'atum','template','atum',NULL,'',1,1,1,0,'{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"2016-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10036,0,'cassiopeia','template','cassiopeia',NULL,'',0,1,1,0,'{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10037,0,'plg_filesystem_local','plugin','local',NULL,'filesystem',0,1,1,0,'{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Filesystem\\\\Local\",\"filename\":\"local\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10038,0,'plg_media-action_crop','plugin','crop',NULL,'media-action',0,1,1,0,'{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"crop\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10039,0,'plg_media-action_resize','plugin','resize',NULL,'media-action',0,1,1,0,'{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"resize\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10040,0,'plg_media-action_rotate','plugin','rotate',NULL,'media-action',0,1,1,0,'{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"rotate\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10041,0,'plg_system_httpheaders','plugin','httpheaders',NULL,'system',0,0,1,0,'{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"2017-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"httpheaders\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10042,0,'com_workflow','component','com_workflow',NULL,'',1,1,0,1,'{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Workflow\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10043,0,'plg_workflow_publishing','plugin','publishing',NULL,'workflow',0,1,1,0,'{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"publishing\"}','{}','',NULL,NULL,0,0,NULL,0)
,(10044,0,'plg_workflow_featuring','plugin','featuring',NULL,'workflow',0,1,1,0,'{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"featuring\"}','{}','',NULL,NULL,0,0,NULL,0)
,(10045,0,'plg_workflow_notification','plugin','notification',NULL,'workflow',0,1,1,0,'{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"2020-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"notification\"}','{}','',NULL,NULL,0,0,NULL,0)
,(10046,0,'plg_extension_namespacemap','plugin','namespacemap',NULL,'extension',0,1,1,1,'{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"2017-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\NamespaceMap\",\"filename\":\"namespacemap\"}','','',NULL,NULL,0,0,NULL,1)
,(10047,0,'plg_installer_override','plugin','override',NULL,'installer',0,1,1,0,'{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"override\"}','','',NULL,NULL,4,0,NULL,1)
,(10048,0,'plg_quickicon_overridecheck','plugin','overridecheck',NULL,'quickicon',0,1,1,0,'{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\OverrideCheck\",\"filename\":\"overridecheck\"}','','',NULL,NULL,0,0,NULL,1)
,(10049,0,'plg_extension_finder','plugin','finder',NULL,'extension',0,1,1,0,'{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Finder\",\"filename\":\"finder\"}','','',NULL,NULL,0,0,NULL,1)
,(10050,0,'plg_api-authentication_basic','plugin','basic',NULL,'api-authentication',0,0,1,0,'{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Basic\",\"filename\":\"basic\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10051,0,'plg_webservices_content','plugin','content',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10052,0,'com_mails','component','com_mails',NULL,'',1,1,1,1,'{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"2019-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Mails\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10053,0,'plg_system_skipto','plugin','skipto',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"2020-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"skipto\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10054,0,'plg_sampledata_multilang','plugin','multilang',NULL,'sampledata',0,1,1,0,'{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"multilang\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10055,0,'plg_installer_webinstaller','plugin','webinstaller',NULL,'installer',0,1,1,0,'{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"webinstaller\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10056,0,'plg_fields_subform','plugin','subform',NULL,'fields',0,1,1,0,'{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Subform\",\"filename\":\"subform\"}','','',NULL,NULL,0,0,NULL,1)
,(10057,0,'plg_system_webauthn','plugin','webauthn',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Webauthn\",\"filename\":\"webauthn\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10058,0,'mod_loginsupport','module','mod_loginsupport',NULL,'',1,1,1,0,'{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"2019-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Loginsupport\",\"filename\":\"mod_loginsupport\"}','','',NULL,NULL,0,0,NULL,1)
,(10059,0,'mod_frontend','module','mod_frontend',NULL,'',1,1,1,0,'{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_frontend\"}','','',NULL,NULL,0,0,NULL,1)
,(10060,0,'mod_messages','module','mod_messages',NULL,'',1,1,1,0,'{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_messages\"}','','',NULL,NULL,0,0,NULL,1)
,(10061,0,'mod_post_installation_messages','module','mod_post_installation_messages',NULL,'',1,1,1,0,'{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_post_installation_messages\"}','','',NULL,NULL,0,0,NULL,1)
,(10062,0,'mod_user','module','mod_user',NULL,'',1,1,1,0,'{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_user\"}','','',NULL,NULL,0,0,NULL,1)
,(10063,0,'mod_submenu','module','mod_submenu',NULL,'',1,1,1,0,'{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"2006-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Submenu\",\"filename\":\"mod_submenu\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10064,0,'mod_privacy_status','module','mod_privacy_status',NULL,'',1,1,1,0,'{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyStatus\",\"filename\":\"mod_privacy_status\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10065,0,'plg_webservices_banners','plugin','banners',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10066,0,'plg_webservices_config','plugin','config',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"config\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10067,0,'plg_webservices_contact','plugin','contact',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10068,0,'plg_webservices_languages','plugin','languages',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languages\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10069,0,'plg_webservices_menus','plugin','menus',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menus\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10070,0,'plg_webservices_messages','plugin','messages',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"messages\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10071,0,'plg_webservices_modules','plugin','modules',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"modules\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10072,0,'plg_webservices_newsfeeds','plugin','newsfeeds',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10073,0,'plg_webservices_plugins','plugin','plugins',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"plugins\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10074,0,'plg_webservices_privacy','plugin','privacy',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10075,0,'plg_webservices_redirect','plugin','redirect',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10076,0,'plg_webservices_tags','plugin','tags',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10077,0,'plg_webservices_templates','plugin','templates',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templates\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10078,0,'plg_webservices_users','plugin','users',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10079,0,'plg_webservices_installer','plugin','installer',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"2020-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"installer\"}','{}','',NULL,NULL,0,0,NULL,0)
,(10080,0,'plg_user_token','plugin','token',NULL,'user',0,1,1,0,'{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Token\",\"filename\":\"token\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10081,0,'plg_api-authentication_token','plugin','token',NULL,'api-authentication',0,1,1,0,'{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Token\",\"filename\":\"token\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10082,0,'plg_system_accessibility','plugin','accessibility',NULL,'system',0,0,1,0,'{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"accessibility\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10083,802,'English (en-GB)','language','en-GB',NULL,'',3,1,1,1,'{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2023-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"en-GB api language\",\"group\":\"\"}','','',NULL,NULL,0,0,NULL,1)
,(10084,0,'plg_quickicon_downloadkey','plugin','downloadkey',NULL,'quickicon',0,1,1,0,'{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"2019-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Downloadkey\",\"filename\":\"downloadkey\"}','','',NULL,NULL,0,0,NULL,1)
,(10085,0,'com_scheduler','component','com_scheduler',NULL,'',1,1,1,0,'{\"name\":\"com_scheduler\",\"type\":\"component\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"COM_SCHEDULER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Scheduler\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10086,0,'plg_system_schedulerunner','plugin','schedulerunner',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_schedulerunner\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_SCHEDULERUNNER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"schedulerunner\"}','{}','',NULL,NULL,15,0,NULL,0)
,(10087,0,'plg_system_task_notification','plugin','tasknotification',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_task_notification\",\"type\":\"plugin\",\"creationDate\":\"2021-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_TASK_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tasknotification\"}','','',NULL,NULL,22,0,NULL,1)
,(10088,0,'plg_task_check_files','plugin','checkfiles',NULL,'task',0,1,1,0,'{\"name\":\"plg_task_check_files\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_CHECK_FILES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Checkfiles\",\"filename\":\"checkfiles\"}','{}','',NULL,NULL,15,0,NULL,0)
,(10089,0,'plg_task_demo_tasks','plugin','demotasks',NULL,'task',0,1,1,0,'{\"name\":\"plg_task_demo_tasks\",\"type\":\"plugin\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_DEMO_TASKS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\DemoTasks\",\"filename\":\"demotasks\"}','{}','',NULL,NULL,15,0,NULL,0)
,(10090,0,'plg_task_requests','plugin','requests',NULL,'task',0,1,1,0,'{\"name\":\"plg_task_requests\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_REQUESTS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Requests\",\"filename\":\"requests\"}','{}','',NULL,NULL,15,0,NULL,0)
,(10091,0,'plg_task_site_status','plugin','sitestatus',NULL,'task',0,1,1,0,'{\"name\":\"plg_task_site_status\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_SITE_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SiteStatus\",\"filename\":\"sitestatus\"}','{}','',NULL,NULL,15,0,NULL,0)
,(10092,0,'plg_system_jooa11y','plugin','jooa11y',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_jooa11y\",\"type\":\"plugin\",\"creationDate\":\"2022-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_JOOA11Y_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"jooa11y\"}','','',NULL,NULL,0,0,NULL,1)
,(10093,0,'plg_webservices_media','plugin','media',NULL,'webservices',0,1,1,0,'{\"name\":\"plg_webservices_media\",\"type\":\"plugin\",\"creationDate\":\"2021-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"PLG_WEBSERVICES_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10094,0,'com_guidedtours','component','com_guidedtours',NULL,'',1,1,0,0,'{\"name\":\"com_guidedtours\",\"type\":\"component\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"COM_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Guidedtours\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10095,0,'mod_guidedtours','module','mod_guidedtours',NULL,'',1,1,1,0,'{\"name\":\"mod_guidedtours\",\"type\":\"module\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"MOD_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\GuidedTours\",\"filename\":\"mod_guidedtours\"}','{}','',NULL,NULL,0,0,NULL,1)
,(10096,0,'plg_system_guidedtours','plugin','guidedtours',NULL,'system',0,1,1,0,'{\"name\":\"plg_system_guidedtours\",\"type\":\"plugin\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"PLG_SYSTEM_GUIDEDTOURS_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\GuidedTours\",\"filename\":\"guidedtours\"}','{}','',NULL,NULL,0,0,NULL,1);
/*!40000 ALTER TABLE `#__extensions` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `context` varchar(255) NOT NULL DEFAULT '',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `default_value` mediumtext DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'text',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `required` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` mediumtext NOT NULL,
  `fieldparams` mediumtext NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 1,
  `only_use_in_subform` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_language` (`language`),
  KEY `idx_context` (`context`(191))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__fields` DISABLE KEYS */;
INSERT INTO `#__fields` (`id`, `asset_id`, `context`, `group_id`, `title`, `name`, `label`, `default_value`, `type`, `note`, `description`, `state`, `required`, `checked_out`, `checked_out_time`, `ordering`, `params`, `fieldparams`, `language`, `created_time`, `created_user_id`, `modified_time`, `modified_by`, `access`, `only_use_in_subform`) VALUES 
(1,127,'com_users.user',0,'Test Field Media','test-field-media','Test Field Media','','text','','',-2,0,NULL,NULL,0,'{\"hint\":\"\",\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"2\",\"layout\":\"\",\"display_readonly\":\"2\"}','{\"filter\":\"\",\"maxlength\":\"\"}','*','2021-08-03 08:48:32',42,'2021-08-03 08:48:32',42,1,0);
/*!40000 ALTER TABLE `#__fields` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__fields_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT 0,
  `category_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__fields_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__fields_categories` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__fields_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__fields_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `context` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` mediumtext NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_language` (`language`),
  KEY `idx_context` (`context`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__fields_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__fields_groups` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__fields_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__fields_values` (
  `field_id` int(10) unsigned NOT NULL,
  `item_id` varchar(255) NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` mediumtext DEFAULT NULL,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__fields_values` DISABLE KEYS */;
INSERT INTO `#__fields_values` (`field_id`, `item_id`, `value`) VALUES 
(1,'42','eatsdtdst');
/*!40000 ALTER TABLE `#__fields_values` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__finder_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_filters` (
  `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `map_count` int(10) unsigned NOT NULL DEFAULT 0,
  `data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__finder_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__finder_filters` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__finder_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `route` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `indexdate` datetime NOT NULL,
  `md5sum` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `state` int(11) NOT NULL DEFAULT 1,
  `access` int(11) NOT NULL DEFAULT 0,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_start_date` datetime DEFAULT NULL,
  `publish_end_date` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `list_price` double unsigned NOT NULL DEFAULT 0,
  `sale_price` double unsigned NOT NULL DEFAULT 0,
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`),
  KEY `idx_title` (`title`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

DROP TABLE IF EXISTS `#__finder_links_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

DROP TABLE IF EXISTS `#__finder_logging`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_logging` (
  `searchterm` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `md5sum` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `query` blob NOT NULL,
  `hits` int(11) NOT NULL DEFAULT 1,
  `results` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`md5sum`),
  KEY `searchterm` (`searchterm`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

DROP TABLE IF EXISTS `#__finder_taxonomy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `access` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_access` (`access`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`),
  KEY `idx_parent_published` (`parent_id`,`state`,`access`),
  KEY `idx_level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__finder_taxonomy` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__finder_taxonomy` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__finder_taxonomy_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy_map` (
  `link_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`node_id`),
  KEY `link_id` (`link_id`),
  KEY `node_id` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

DROP TABLE IF EXISTS `#__finder_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_terms` (
  `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `weight` float unsigned NOT NULL DEFAULT 0,
  `soundex` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `links` int(10) NOT NULL DEFAULT 0,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term_language` (`term`,`language`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`),
  KEY `idx_stem` (`stem`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

DROP TABLE IF EXISTS `#__finder_terms_common`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_terms_common` (
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `custom` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_term_language` (`term`,`language`),
  KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

DROP TABLE IF EXISTS `#__finder_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_tokens` (
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `weight` float unsigned NOT NULL DEFAULT 1,
  `context` tinyint(1) unsigned NOT NULL DEFAULT 2,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  KEY `idx_word` (`term`),
  KEY `idx_context` (`context`),
  KEY `idx_stem` (`stem`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

DROP TABLE IF EXISTS `#__finder_tokens_aggregate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_tokens_aggregate` (
  `term_id` int(10) unsigned NOT NULL,
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `term_weight` float unsigned NOT NULL DEFAULT 0,
  `context` tinyint(1) unsigned NOT NULL DEFAULT 2,
  `context_weight` float unsigned NOT NULL DEFAULT 0,
  `total_weight` float unsigned NOT NULL DEFAULT 0,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  KEY `token` (`term`),
  KEY `keyword_id` (`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

DROP TABLE IF EXISTS `#__finder_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__finder_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__finder_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__finder_types` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__guidedtours`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__guidedtours` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_state` (`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__guidedtours` DISABLE KEYS */;
INSERT INTO `#__guidedtours` (`id`, `title`, `description`, `ordering`, `extensions`, `url`, `created`, `created_by`, `modified`, `modified_by`, `checked_out_time`, `checked_out`, `published`, `language`, `note`, `access`) VALUES 
(1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_TITLE','COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_DESCRIPTION',1,'[\"com_guidedtours\"]','administrator/index.php?option=com_guidedtours&view=tours','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1)
,(2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_TITLE','COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_DESCRIPTION',2,'[\"com_guidedtours\"]','administrator/index.php?option=com_guidedtours&view=tours','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1)
,(3,'COM_GUIDEDTOURS_TOUR_ARTICLES_TITLE','COM_GUIDEDTOURS_TOUR_ARTICLES_DESCRIPTION',3,'[\"*\"]','administrator/index.php?option=com_content&view=articles','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1)
,(4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_TITLE','COM_GUIDEDTOURS_TOUR_CATEGORIES_DESCRIPTION',4,'[\"*\"]','administrator/index.php?option=com_categories&view=categories&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1)
,(5,'COM_GUIDEDTOURS_TOUR_MENUS_TITLE','COM_GUIDEDTOURS_TOUR_MENUS_DESCRIPTION',5,'[\"*\"]','administrator/index.php?option=com_menus&view=menus','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1)
,(6,'COM_GUIDEDTOURS_TOUR_TAGS_TITLE','COM_GUIDEDTOURS_TOUR_TAGS_DESCRIPTION',6,'[\"*\"]','administrator/index.php?option=com_tags&view=tags','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1)
,(7,'COM_GUIDEDTOURS_TOUR_BANNERS_TITLE','COM_GUIDEDTOURS_TOUR_BANNERS_DESCRIPTION',7,'[\"*\"]','administrator/index.php?option=com_banners&view=banners','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1)
,(8,'COM_GUIDEDTOURS_TOUR_CONTACTS_TITLE','COM_GUIDEDTOURS_TOUR_CONTACTS_DESCRIPTION',8,'[\"*\"]','administrator/index.php?option=com_contact&view=contacts','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1)
,(9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_TITLE','COM_GUIDEDTOURS_TOUR_NEWSFEEDS_DESCRIPTION',9,'[\"*\"]','administrator/index.php?option=com_newsfeeds&view=newsfeeds','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1)
,(10,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_TITLE','COM_GUIDEDTOURS_TOUR_SMARTSEARCH_DESCRIPTION',10,'[\"*\"]','administrator/index.php?option=com_finder&view=filters','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1)
,(11,'COM_GUIDEDTOURS_TOUR_USERS_TITLE','COM_GUIDEDTOURS_TOUR_USERS_DESCRIPTION',11,'[\"*\"]','administrator/index.php?option=com_users&view=users','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,1,'*','',1);
/*!40000 ALTER TABLE `#__guidedtours` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__guidedtour_steps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__guidedtour_steps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tour_id` int(11) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `position` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` int(11) NOT NULL,
  `interactive_type` int(11) NOT NULL DEFAULT 1,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_tour` (`tour_id`),
  KEY `idx_state` (`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__guidedtour_steps` DISABLE KEYS */;
INSERT INTO `#__guidedtour_steps` (`id`, `tour_id`, `title`, `published`, `description`, `ordering`, `position`, `target`, `type`, `interactive_type`, `url`, `created`, `created_by`, `modified`, `modified_by`, `checked_out_time`, `checked_out`, `language`, `note`) VALUES 
(1,1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_NEW_DESCRIPTION',1,'bottom','.button-new',2,1,'administrator/index.php?option=com_guidedtours&view=tours','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(2,1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_TITLE_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_TITLE_DESCRIPTION',2,'bottom','#jform_title',2,2,'administrator/index.php?option=com_guidedtours&view=tour&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(3,1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_URL_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_URL_DESCRIPTION',3,'top','#jform_url',2,2,'administrator/index.php?option=com_guidedtours&view=tour&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(4,1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONTENT_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONTENT_DESCRIPTION',4,'bottom','#jform_description,#jform_description_ifr',2,3,'administrator/index.php?option=com_guidedtours&view=tour&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(5,1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_COMPONENT_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_COMPONENT_DESCRIPTION',5,'top','joomla-field-fancy-select .choices',2,3,'administrator/index.php?option=com_guidedtours&view=tour&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(6,1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_SAVECLOSE_DESCRIPTION',6,'top','#save-group-children-save .button-save',2,1,'administrator/index.php?option=com_guidedtours&view=tour&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(7,1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONGRATULATIONS_DESCRIPTION',7,'bottom','',0,1,'administrator/index.php?option=com_guidedtours&view=tour&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(8,2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_COUNTER_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_COUNTER_DESCRIPTION',8,'top','#toursList tbody tr:nth-last-of-type(1) td:nth-of-type(5) .btn',2,1,'','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(9,2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_NEW_DESCRIPTION',9,'bottom','.button-new',2,1,'','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(10,2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TITLE_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TITLE_DESCRIPTION',10,'bottom','#jform_title',2,2,'','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(11,2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_DESCRIPTION_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_DESCRIPTION_DESCRIPTION',11,'bottom','#jform_description,#jform_description_ifr',2,3,'','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(12,2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_STATUS_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_STATUS_DESCRIPTION',12,'bottom','#jform_published',2,3,'','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(13,2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_POSITION_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_POSITION_DESCRIPTION',13,'top','#jform_position',2,3,'','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(14,2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TARGET_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TARGET_DESCRIPTION',14,'top','#jform_target',2,3,'','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(15,2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TYPE_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TYPE_DESCRIPTION',15,'top','#jform_type',2,3,'','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(16,2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_SAVECLOSE_DESCRIPTION',16,'bottom','#save-group-children-save .button-save',2,1,'','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(17,2,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_CONGRATULATIONS_DESCRIPTION',17,'bottom','',0,1,'','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(18,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NEW_DESCRIPTION',18,'bottom','.button-new',2,1,'administrator/index.php?option=com_content&view=articles','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(19,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TITLE_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TITLE_DESCRIPTION',19,'bottom','#jform_title',2,2,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(20,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ALIAS_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ALIAS_DESCRIPTION',20,'bottom','#jform_alias',2,2,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(21,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONTENT_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONTENT_DESCRIPTION',21,'bottom','#jform_articletext,#jform_articletext_ifr',2,3,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(22,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_STATUS_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_STATUS_DESCRIPTION',22,'bottom','#jform_state',2,3,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(23,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CATEGORY_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CATEGORY_DESCRIPTION',23,'top','joomla-field-fancy-select .choices[data-type=select-one]',2,3,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(24,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_FEATURED_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_FEATURED_DESCRIPTION',24,'bottom','#jform_featured0',2,3,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(25,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ACCESS_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ACCESS_DESCRIPTION',25,'bottom','#jform_access',2,3,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(26,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TAGS_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TAGS_DESCRIPTION',26,'top','joomla-field-fancy-select .choices[data-type=select-multiple]',2,3,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(27,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NOTE_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NOTE_DESCRIPTION',27,'top','#jform_note',2,2,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(28,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_VERSIONNOTE_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_VERSIONNOTE_DESCRIPTION',28,'top','#jform_version_note',2,2,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(29,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_SAVECLOSE_DESCRIPTION',29,'bottom','#save-group-children-save .button-save',2,1,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(30,3,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONGRATULATIONS_DESCRIPTION',30,'bottom','',0,1,'administrator/index.php?option=com_content&view=article&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(31,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NEW_DESCRIPTION',31,'bottom','.button-new',2,1,'administrator/index.php?option=com_categories&view=categories&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(32,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TITLE_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TITLE_DESCRIPTION',32,'bottom','#jform_title',2,2,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(33,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ALIAS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ALIAS_DESCRIPTION',33,'bottom','#jform_alias',2,2,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(34,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONTENT_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONTENT_DESCRIPTION',34,'bottom','#jform_description,#jform_description_ifr',2,3,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(35,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_PARENT_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_PARENT_DESCRIPTION',35,'top','joomla-field-fancy-select .choices[data-type=select-one]',2,3,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(36,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_STATUS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_STATUS_DESCRIPTION',36,'bottom','#jform_published',2,3,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(37,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ACCESS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ACCESS_DESCRIPTION',37,'bottom','#jform_access',2,3,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(38,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TAGS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TAGS_DESCRIPTION',38,'top','joomla-field-fancy-select .choices[data-type=select-multiple]',2,3,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(39,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NOTE_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NOTE_DESCRIPTION',39,'top','#jform_note',2,2,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(40,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_VERSIONNOTE_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_VERSIONNOTE_DESCRIPTION',40,'top','#jform_version_note',2,2,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(41,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_SAVECLOSE_DESCRIPTION',41,'bottom','#save-group-children-save .button-save',2,1,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(42,4,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONGRATULATIONS_DESCRIPTION',42,'bottom','',0,1,'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(43,5,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_NEW_DESCRIPTION',43,'bottom','.button-new',2,1,'administrator/index.php?option=com_menus&view=menus','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(44,5,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_TITLE_TITLE',1,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_TITLE_DESCRIPTION',44,'bottom','#jform_title',2,2,'administrator/index.php?option=com_menus&view=menu&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(45,5,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_UNIQUENAME_TITLE',1,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_UNIQUENAME_DESCRIPTION',45,'top','#jform_menutype',2,2,'administrator/index.php?option=com_menus&view=menu&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(46,5,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_DESCRIPTION_TITLE',1,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_DESCRIPTION_DESCRIPTION',46,'top','#jform_menudescription',2,2,'administrator/index.php?option=com_menus&view=menu&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(47,5,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_SAVECLOSE_DESCRIPTION',47,'bottom','#save-group-children-save .button-save',2,1,'administrator/index.php?option=com_menus&view=menu&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(48,5,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_MENUS_STEP_CONGRATULATIONS_DESCRIPTION',48,'bottom','',0,1,'administrator/index.php?option=com_menus&view=menu&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(49,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NEW_DESCRIPTION',49,'bottom','.button-new',2,1,'administrator/index.php?option=com_tags&view=tags','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(50,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_TITLE_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_TITLE_DESCRIPTION',50,'bottom','#jform_title',2,2,'administrator/index.php?option=com_tags&view=tag&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(51,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ALIAS_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ALIAS_DESCRIPTION',51,'bottom','#jform_alias',2,2,'administrator/index.php?option=com_tags&view=tag&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(52,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONTENT_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONTENT_DESCRIPTION',52,'bottom','#jform_description,#jform_description_ifr',2,3,'administrator/index.php?option=com_tags&view=tag&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(53,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_PARENT_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_PARENT_DESCRIPTION',53,'top','joomla-field-fancy-select .choices[data-type=select-one]',2,3,'administrator/index.php?option=com_tags&view=tag&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(54,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_STATUS_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_STATUS_DESCRIPTION',54,'bottom','#jform_published',2,3,'administrator/index.php?option=com_tags&view=tag&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(55,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ACCESS_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ACCESS_DESCRIPTION',55,'bottom','#jform_access',2,3,'administrator/index.php?option=com_tags&view=tag&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(56,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NOTE_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NOTE_DESCRIPTION',56,'top','#jform_note',2,2,'administrator/index.php?option=com_tags&view=tag&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(57,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_VERSIONNOTE_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_VERSIONNOTE_DESCRIPTION',57,'top','#jform_version_note',2,2,'administrator/index.php?option=com_tags&view=tag&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(58,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_SAVECLOSE_DESCRIPTION',58,'bottom','#save-group-children-save .button-save',2,1,'administrator/index.php?option=com_tags&view=tag&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(59,6,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONGRATULATIONS_DESCRIPTION',59,'bottom','',0,1,'administrator/index.php?option=com_tags&view=tag&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(60,7,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_NEW_DESCRIPTION',60,'bottom','.button-new',2,1,'administrator/index.php?option=com_banners&view=banners','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(61,7,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_TITLE_TITLE',1,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_TITLE_DESCRIPTION',61,'bottom','#jform_name',2,2,'administrator/index.php?option=com_banners&view=banner&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(62,7,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_ALIAS_TITLE',1,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_ALIAS_DESCRIPTION',62,'bottom','#jform_alias',2,2,'administrator/index.php?option=com_banners&view=banner&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(63,7,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_DESCRIPTION_TITLE',1,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_DESCRIPTION_DESCRIPTION',63,'bottom','#jform_description,#jform_description_ifr',2,3,'administrator/index.php?option=com_banners&view=banner&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(64,7,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_STATUS_TITLE',1,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_STATUS_DESCRIPTION',64,'bottom','#jform_state',2,3,'administrator/index.php?option=com_banners&view=banner&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(65,7,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CATEGORY_TITLE',1,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CATEGORY_DESCRIPTION',65,'top','joomla-field-fancy-select .choices[data-type=select-one]',2,3,'administrator/index.php?option=com_banners&view=banner&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(66,7,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_PINNED_TITLE',1,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_PINNED_DESCRIPTION',66,'bottom','#jform_sticky1',2,3,'administrator/index.php?option=com_banners&view=banner&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(67,7,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_VERSIONNOTE_TITLE',1,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_VERSIONNOTE_DESCRIPTION',67,'top','#jform_version_note',2,2,'administrator/index.php?option=com_banners&view=banner&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(68,7,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_SAVECLOSE_DESCRIPTION',68,'bottom','#save-group-children-save .button-save',2,1,'administrator/index.php?option=com_banners&view=banner&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(69,7,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CONGRATULATIONS_DESCRIPTION',69,'bottom','',0,1,'administrator/index.php?option=com_banners&view=banner&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(70,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_NEW_DESCRIPTION',70,'bottom','.button-new',2,1,'administrator/index.php?option=com_contact&view=contacts','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(71,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TITLE_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TITLE_DESCRIPTION',71,'bottom','#jform_name',2,2,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(72,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ALIAS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ALIAS_DESCRIPTION',72,'bottom','#jform_alias',2,2,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(73,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_DETAILS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_DETAILS_DESCRIPTION',73,'bottom','.col-lg-9',0,1,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(74,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_STATUS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_STATUS_DESCRIPTION',74,'bottom','#jform_published',2,3,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(75,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CATEGORY_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CATEGORY_DESCRIPTION',75,'top','joomla-field-fancy-select .choices[data-type=select-one]',2,3,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(76,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_FEATURED_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_FEATURED_DESCRIPTION',76,'bottom','#jform_featured0',2,3,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(77,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ACCESS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ACCESS_DESCRIPTION',77,'bottom','#jform_access',2,3,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(78,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TAGS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TAGS_DESCRIPTION',78,'top','joomla-field-fancy-select .choices[data-type=select-multiple]',2,3,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(79,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_VERSIONNOTE_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_VERSIONNOTE_DESCRIPTION',79,'top','#jform_version_note',2,2,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(80,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_SAVECLOSE_DESCRIPTION',80,'bottom','#save-group-children-save .button-save',2,1,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(81,8,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CONGRATULATIONS_DESCRIPTION',81,'bottom','',0,1,'administrator/index.php?option=com_contact&view=contact&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(82,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_NEW_DESCRIPTION',82,'bottom','.button-new',2,1,'administrator/index.php?option=com_newsfeeds&view=newsfeeds','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(83,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TITLE_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TITLE_DESCRIPTION',83,'bottom','#jform_name',2,2,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(84,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ALIAS_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ALIAS_DESCRIPTION',84,'bottom','#jform_alias',2,2,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(85,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_LINK_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_LINK_DESCRIPTION',85,'bottom','#jform_link',2,2,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(86,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_DESCRIPTION_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_DESCRIPTION_DESCRIPTION',86,'bottom','#jform_description,#jform_description_ifr',2,3,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(87,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_STATUS_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_STATUS_DESCRIPTION',87,'bottom','#jform_published',2,3,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(88,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CATEGORY_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CATEGORY_DESCRIPTION',88,'top','joomla-field-fancy-select .choices[data-type=select-one]',2,3,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(89,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ACCESS_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ACCESS_DESCRIPTION',89,'bottom','#jform_access',2,3,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(90,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TAGS_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TAGS_DESCRIPTION',90,'top','joomla-field-fancy-select .choices[data-type=select-multiple]',2,3,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(91,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_VERSIONNOTE_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_VERSIONNOTE_DESCRIPTION',91,'top','#jform_version_note',2,2,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(92,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_SAVECLOSE_DESCRIPTION',92,'bottom','#save-group-children-save .button-save',2,1,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(93,9,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CONGRATULATIONS_DESCRIPTION',93,'bottom','',0,1,'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(94,10,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_NEW_DESCRIPTION',94,'bottom','.button-new',2,1,'administrator/index.php?option=com_finder&view=filters','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(95,10,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_TITLE_TITLE',1,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_TITLE_DESCRIPTION',95,'bottom','#jform_title',2,2,'administrator/index.php?option=com_finder&view=filter&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(96,10,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_ALIAS_TITLE',1,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_ALIAS_DESCRIPTION',96,'bottom','#jform_alias',2,2,'administrator/index.php?option=com_finder&view=filter&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(97,10,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONTENT_TITLE',1,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONTENT_DESCRIPTION',97,'bottom','.col-lg-9',0,1,'administrator/index.php?option=com_finder&view=filter&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(98,10,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_STATUS_TITLE',1,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_STATUS_DESCRIPTION',98,'bottom','#jform_state',2,3,'administrator/index.php?option=com_finder&view=filter&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(99,10,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_SAVECLOSE_DESCRIPTION',99,'bottom','#save-group-children-save .button-save',2,1,'administrator/index.php?option=com_finder&view=filter&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(100,10,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONGRATULATIONS_DESCRIPTION',100,'bottom','',0,1,'administrator/index.php?option=com_finder&view=filter&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(101,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_NEW_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_NEW_DESCRIPTION',101,'bottom','.button-new',2,1,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(102,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_NAME_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_NAME_DESCRIPTION',102,'bottom','#jform_name',2,2,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(103,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_LOGINNAME_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_LOGINNAME_DESCRIPTION',103,'bottom','#jform_username',2,2,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(104,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD_DESCRIPTION',104,'bottom','#jform_password',2,2,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(105,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD2_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD2_DESCRIPTION',105,'bottom','#jform_password2',2,2,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(106,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_EMAIL_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_EMAIL_DESCRIPTION',106,'bottom','#jform_email',2,2,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(107,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_SYSTEMEMAIL_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_SYSTEMEMAIL_DESCRIPTION',107,'top','#jform_sendEmail0',2,3,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(108,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_STATUS_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_STATUS_DESCRIPTION',108,'top','#jform_block0',2,3,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(109,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORDRESET_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORDRESET_DESCRIPTION',109,'top','#jform_requireReset0',2,3,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(110,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_SAVECLOSE_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_SAVECLOSE_DESCRIPTION',110,'bottom','#save-group-children-save .button-save',2,1,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','')
,(111,11,'COM_GUIDEDTOURS_TOUR_USERS_STEP_CONGRATULATIONS_TITLE',1,'COM_GUIDEDTOURS_TOUR_USERS_STEP_CONGRATULATIONS_DESCRIPTION',111,'bottom','',0,1,'administrator/index.php?option=com_users&view=user&layout=edit','2023-04-20 09:56:23',0,'2023-04-20 09:56:23',0,NULL,NULL,'*','');
/*!40000 ALTER TABLE `#__guidedtour_steps` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__history` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` varchar(50) NOT NULL,
  `version_note` varchar(255) NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL,
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `character_count` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` longtext NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

DROP TABLE IF EXISTS `#__jaem_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__jaem_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ext_id` varchar(50) DEFAULT NULL,
  `service_id` int(11) DEFAULT NULL,
  `check_date` datetime DEFAULT NULL,
  `check_info` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ext_id` (`ext_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__jaem_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__jaem_log` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__jaem_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__jaem_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ws_name` varchar(255) NOT NULL,
  `ws_mode` varchar(50) NOT NULL DEFAULT 'local',
  `ws_uri` varchar(255) NOT NULL,
  `ws_user` varchar(100) NOT NULL,
  `ws_pass` varchar(100) NOT NULL,
  `ws_default` tinyint(1) NOT NULL DEFAULT 0,
  `ws_core` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__jaem_services` DISABLE KEYS */;
INSERT INTO `#__jaem_services` (`id`, `ws_name`, `ws_mode`, `ws_uri`, `ws_user`, `ws_pass`, `ws_default`, `ws_core`) VALUES 
(1,'Local Service','local','','','',1,1)
,(2,'JoomlArt Updates','remote','http://update.joomlart.com/service/','','',0,1);
/*!40000 ALTER TABLE `#__jaem_services` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lang_code` char(7) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `title` varchar(50) NOT NULL,
  `title_native` varchar(50) NOT NULL,
  `sef` varchar(50) NOT NULL,
  `image` varchar(50) NOT NULL,
  `description` varchar(512) NOT NULL,
  `metakey` text DEFAULT NULL,
  `metadesc` mediumtext NOT NULL,
  `sitename` varchar(1024) NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__languages` DISABLE KEYS */;
INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES 
(1,0,'en-GB','English (en-GB)','English (United Kingdom)','en','en_gb','','','','',1,1,1);
/*!40000 ALTER TABLE `#__languages` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__mail_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__mail_templates` (
  `template_id` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `htmlbody` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachments` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__mail_templates` DISABLE KEYS */;
INSERT INTO `#__mail_templates` (`template_id`, `extension`, `language`, `subject`, `body`, `htmlbody`, `attachments`, `params`) VALUES 
('com_actionlogs.notification','com_actionlogs','','COM_ACTIONLOGS_EMAIL_SUBJECT','COM_ACTIONLOGS_EMAIL_BODY','COM_ACTIONLOGS_EMAIL_HTMLBODY','','{\"tags\":[\"message\",\"date\",\"extension\"]}')
,('com_config.test_mail','com_config','','COM_CONFIG_SENDMAIL_SUBJECT','COM_CONFIG_SENDMAIL_BODY','','','{\"tags\":[\"sitename\",\"method\"]}')
,('com_contact.mail','com_contact','','COM_CONTACT_ENQUIRY_SUBJECT','COM_CONTACT_ENQUIRY_TEXT','','','{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\"]}')
,('com_contact.mail.copy','com_contact','','COM_CONTACT_COPYSUBJECT_OF','COM_CONTACT_COPYTEXT_OF','','','{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\"]}')
,('com_messages.new_message','com_messages','','COM_MESSAGES_NEW_MESSAGE','COM_MESSAGES_NEW_MESSAGE_BODY','','','{\"tags\":[\"subject\",\"message\",\"fromname\",\"sitename\",\"siteurl\",\"fromemail\",\"toname\",\"toemail\"]}')
,('com_privacy.notification.admin.export','com_privacy','','COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_EXPORT_REQUEST','COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_EXPORT_REQUEST','','','{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}')
,('com_privacy.notification.admin.remove','com_privacy','','COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_REMOVE_REQUEST','COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_REMOVE_REQUEST','','','{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}')
,('com_privacy.notification.export','com_privacy','','COM_PRIVACY_EMAIL_REQUEST_SUBJECT_EXPORT_REQUEST','COM_PRIVACY_EMAIL_REQUEST_BODY_EXPORT_REQUEST','','','{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}')
,('com_privacy.notification.remove','com_privacy','','COM_PRIVACY_EMAIL_REQUEST_SUBJECT_REMOVE_REQUEST','COM_PRIVACY_EMAIL_REQUEST_BODY_REMOVE_REQUEST','','','{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}')
,('com_privacy.userdataexport','com_privacy','','COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_SUBJECT','COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_BODY','','','{\"tags\":[\"sitename\",\"url\"]}')
,('com_users.massmail.mail','com_users','','COM_USERS_MASSMAIL_MAIL_SUBJECT','COM_USERS_MASSMAIL_MAIL_BODY','','','{\"tags\":[\"subject\",\"body\",\"subjectprefix\",\"bodysuffix\"]}')
,('com_users.password_reset','com_users','','COM_USERS_EMAIL_PASSWORD_RESET_SUBJECT','COM_USERS_EMAIL_PASSWORD_RESET_BODY','','','{\"tags\":[\"name\",\"email\",\"sitename\",\"link_text\",\"link_html\",\"token\"]}')
,('com_users.registration.admin.new_notification','com_users','','COM_USERS_EMAIL_ACCOUNT_DETAILS','COM_USERS_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY','','','{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}')
,('com_users.registration.admin.verification_request','com_users','','COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_SUBJECT','COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_BODY','','','{\"tags\":[\"name\",\"sitename\",\"email\",\"username\",\"activate\"]}')
,('com_users.registration.user.admin_activated','com_users','','COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_SUBJECT','COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_BODY','','','{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}')
,('com_users.registration.user.admin_activation','com_users','','COM_USERS_EMAIL_ACCOUNT_DETAILS','COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY_NOPW','','','{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}')
,('com_users.registration.user.admin_activation_w_pw','com_users','','COM_USERS_EMAIL_ACCOUNT_DETAILS','COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY','','','{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}')
,('com_users.registration.user.registration_mail','com_users','','COM_USERS_EMAIL_ACCOUNT_DETAILS','COM_USERS_EMAIL_REGISTERED_BODY_NOPW','','','{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}')
,('com_users.registration.user.registration_mail_w_pw','com_users','','COM_USERS_EMAIL_ACCOUNT_DETAILS','COM_USERS_EMAIL_REGISTERED_BODY','','','{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\",\"password_clear\"]}')
,('com_users.registration.user.self_activation','com_users','','COM_USERS_EMAIL_ACCOUNT_DETAILS','COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY_NOPW','','','{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}')
,('com_users.registration.user.self_activation_w_pw','com_users','','COM_USERS_EMAIL_ACCOUNT_DETAILS','COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY','','','{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}')
,('com_users.reminder','com_users','','COM_USERS_EMAIL_USERNAME_REMINDER_SUBJECT','COM_USERS_EMAIL_USERNAME_REMINDER_BODY','','','{\"tags\":[\"name\",\"username\",\"sitename\",\"email\",\"link_text\",\"link_html\"]}')
,('plg_system_privacyconsent.request.reminder','plg_system_privacyconsent','','PLG_SYSTEM_PRIVACYCONSENT_EMAIL_REMIND_SUBJECT','PLG_SYSTEM_PRIVACYCONSENT_EMAIL_REMIND_BODY','','','{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}')
,('plg_system_tasknotification.failure_mail','plg_system_tasknotification','','PLG_SYSTEM_TASK_NOTIFICATION_FAILURE_MAIL_SUBJECT','PLG_SYSTEM_TASK_NOTIFICATION_FAILURE_MAIL_BODY','','','{\"tags\": [\"task_id\", \"task_title\", \"exit_code\", \"exec_data_time\", \"task_output\"]}')
,('plg_system_tasknotification.fatal_recovery_mail','plg_system_tasknotification','','PLG_SYSTEM_TASK_NOTIFICATION_FATAL_MAIL_SUBJECT','PLG_SYSTEM_TASK_NOTIFICATION_FATAL_MAIL_BODY','','','{\"tags\": [\"task_id\", \"task_title\"]}')
,('plg_system_tasknotification.orphan_mail','plg_system_tasknotification','','PLG_SYSTEM_TASK_NOTIFICATION_ORPHAN_MAIL_SUBJECT','PLG_SYSTEM_TASK_NOTIFICATION_ORPHAN_MAIL_BODY','','','{\"tags\": [\"task_id\", \"task_title\"]}')
,('plg_system_tasknotification.success_mail','plg_system_tasknotification','','PLG_SYSTEM_TASK_NOTIFICATION_SUCCESS_MAIL_SUBJECT','PLG_SYSTEM_TASK_NOTIFICATION_SUCCESS_MAIL_BODY','','','{\"tags\":[\"task_id\", \"task_title\", \"exec_data_time\", \"task_output\"]}')
,('plg_system_updatenotification.mail','plg_system_updatenotification','','PLG_SYSTEM_UPDATENOTIFICATION_EMAIL_SUBJECT','PLG_SYSTEM_UPDATENOTIFICATION_EMAIL_BODY','','','{\"tags\":[\"newversion\",\"curversion\",\"sitename\",\"url\",\"link\",\"releasenews\"]}')
,('plg_user_joomla.mail','plg_user_joomla','','PLG_USER_JOOMLA_NEW_USER_EMAIL_SUBJECT','PLG_USER_JOOMLA_NEW_USER_EMAIL_BODY','','','{\"tags\":[\"name\",\"sitename\",\"url\",\"username\",\"password\",\"email\"]}');
/*!40000 ALTER TABLE `#__mail_templates` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL COMMENT 'The type of menu this item belongs to. FK to j08b41_menu_types.menutype',
  `title` varchar(255) NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(1024) NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 1 COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to j08b41_extensions.id',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `browserNav` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT 0,
  `params` mediumtext NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT 0,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__menu` DISABLE KEYS */;
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`, `publish_up`, `publish_down`) VALUES 
(1,'','Menu_Item_Root','root','','','','',1,0,0,0,NULL,NULL,0,0,'',0,'',0,141,0,'*',0,NULL,NULL)
,(2,'main','com_banners','Banners','','Banners','index.php?option=com_banners','component',1,1,1,4,NULL,NULL,0,0,'class:bookmark',0,'',35,44,0,'*',1,NULL,NULL)
,(3,'main','com_banners','Banners','','Banners/Banners','index.php?option=com_banners&view=banners','component',1,2,2,4,NULL,NULL,0,0,'class:banners',0,'',36,37,0,'*',1,NULL,NULL)
,(4,'main','com_banners_categories','Categories','','Banners/Categories','index.php?option=com_categories&view=categories&extension=com_banners','component',1,2,2,6,NULL,NULL,0,0,'class:banners-cat',0,'',38,39,0,'*',1,NULL,NULL)
,(5,'main','com_banners_clients','Clients','','Banners/Clients','index.php?option=com_banners&view=clients','component',1,2,2,4,NULL,NULL,0,0,'class:banners-clients',0,'',40,41,0,'*',1,NULL,NULL)
,(6,'main','com_banners_tracks','Tracks','','Banners/Tracks','index.php?option=com_banners&view=tracks','component',1,2,2,4,NULL,NULL,0,0,'class:banners-tracks',0,'',42,43,0,'*',1,NULL,NULL)
,(7,'main','com_contact','Contacts','','Contacts','index.php?option=com_contact','component',1,1,1,8,NULL,NULL,0,0,'class:address-book',0,'',45,56,0,'*',1,NULL,NULL)
,(8,'main','com_contact_contacts','Contacts','','Contacts/Contacts','index.php?option=com_contact&view=contacts','component',1,7,2,8,NULL,NULL,0,0,'class:contact',0,'',46,47,0,'*',1,NULL,NULL)
,(9,'main','com_contact_categories','Categories','','Contacts/Categories','index.php?option=com_categories&view=categories&extension=com_contact','component',1,7,2,6,NULL,NULL,0,0,'class:contact-cat',0,'',48,49,0,'*',1,NULL,NULL)
,(13,'main','com_newsfeeds','News Feeds','','News Feeds','index.php?option=com_newsfeeds','component',1,1,1,17,NULL,NULL,0,0,'class:rss',0,'',67,72,0,'*',1,NULL,NULL)
,(14,'main','com_newsfeeds_feeds','Feeds','','News Feeds/Feeds','index.php?option=com_newsfeeds&view=newsfeeds','component',1,13,2,17,NULL,NULL,0,0,'class:newsfeeds',0,'',68,69,0,'*',1,NULL,NULL)
,(15,'main','com_newsfeeds_categories','Categories','','News Feeds/Categories','index.php?option=com_categories&view=categories&extension=com_newsfeeds','component',1,13,2,6,NULL,NULL,0,0,'class:newsfeeds-cat',0,'',70,71,0,'*',1,NULL,NULL)
,(18,'main','com_finder','Smart Search','','Smart Search','index.php?option=com_finder','component',1,1,1,27,NULL,NULL,0,0,'class:search-plus',0,'',73,84,0,'*',1,NULL,NULL)
,(20,'main','com_tags','Tags','','Tags','index.php?option=com_tags&view=tags','component',1,1,1,29,NULL,NULL,0,1,'class:tags',0,'',85,86,0,'',1,NULL,NULL)
,(22,'main','com_associations','Multilingual Associations','','Multilingual Associations','index.php?option=com_associations&view=associations','component',1,1,1,34,NULL,NULL,0,0,'class:language',0,'',87,88,0,'*',1,NULL,NULL)
,(101,'mainmenu','Home','homepage','','homepage','index.php?option=com_content&view=article&id=1','component',1,1,1,22,NULL,NULL,0,1,' ',0,'{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"info_block_show_title\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Education Joomla template with LMS - JA Sensei\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"Education Joomla template with LMS - JA Sensei\",\"menu-meta_keywords\":\"education joomla template, online courses joomla template, joomla template for learning management system, LMS joomla template, creative joomla template\",\"robots\":\"\",\"secure\":0}',1,2,1,'*',0,NULL,NULL)
,(102,'usermenu','Your Profile','your-profile','','your-profile','index.php?option=com_users&view=profile&layout=edit','component',1,1,1,25,NULL,NULL,0,2,'',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',57,58,0,'*',0,NULL,NULL)
,(103,'usermenu','Site Administrator','2013-11-16-23-26-41','','2013-11-16-23-26-41','administrator','url',1,1,1,0,NULL,NULL,0,6,'',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}',61,62,0,'*',0,NULL,NULL)
,(104,'usermenu','Submit an Article','submit-an-article','','submit-an-article','index.php?option=com_content&view=form&layout=edit','component',1,1,1,22,NULL,NULL,0,3,'',0,'{\"enable_category\":\"0\",\"catid\":\"2\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',59,60,0,'*',0,NULL,NULL)
,(106,'usermenu','Template Settings','template-settings','','template-settings','index.php?option=com_config&view=templates','component',1,1,1,23,NULL,NULL,0,6,'',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',63,64,0,'*',0,NULL,NULL)
,(107,'usermenu','Site Settings','site-settings','','site-settings','index.php?option=com_config&view=config','component',1,1,1,23,NULL,NULL,0,6,'',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',65,66,0,'*',0,NULL,NULL)
,(108,'offcanvas','Pages','pages','','pages','','heading',-2,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',133,134,0,'*',0,NULL,NULL)
,(109,'offcanvas','J! Pages','j-pages','','j-pages','','heading',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',3,10,0,'*',0,NULL,NULL)
,(110,'offcanvas','Login','login','','j-pages/login','index.php?option=com_users&view=login','component',1,109,2,25,NULL,NULL,0,1,' ',0,'{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',4,5,0,'*',0,NULL,NULL)
,(111,'offcanvas','Registration','registration','','j-pages/registration','index.php?option=com_users&view=registration','component',1,109,2,25,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',6,7,0,'*',0,NULL,NULL)
,(112,'offcanvas','User Profile','user-profile','','j-pages/user-profile','index.php?option=com_users&view=profile','component',1,109,2,25,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',8,9,0,'*',0,NULL,NULL)
,(113,'mainmenu','Contact Us','contact-us','','contact-us','index.php?option=com_contact&view=contact&id=1','component',1,1,1,8,NULL,NULL,0,1,' ',0,'{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_tags\":\"0\",\"show_info\":\"0\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_misc\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"1\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}',33,34,0,'*',0,NULL,NULL)
,(114,'mainmenu','Our Blog','our-blog','','our-blog','index.php?option=com_content&view=category&layout=blog&id=8','component',1,1,1,22,NULL,NULL,0,1,' ',0,'{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"-1\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',31,32,0,'*',0,NULL,NULL)
,(117,'offcanvas','Smart Search','smart-search','','other-pages/smart-search','index.php?option=com_finder&view=search','component',1,196,2,27,NULL,NULL,0,1,' ',0,'{\"show_date_filters\":\"\",\"show_advanced\":\"\",\"expand_advanced\":\"\",\"show_taxonomy\":\"\",\"show_description\":\"\",\"description_length\":\"\",\"show_date\":\"\",\"show_url\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"list_limit\":\"20\",\"allow_empty_query\":\"\",\"show_suggested_query\":\"\",\"show_explained_query\":\"\",\"sort_order\":\"\",\"sort_direction\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}',12,13,0,'*',0,NULL,NULL)
,(118,'offcanvas','Joomla Content','joomla-content','','joomla-content','','heading',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',19,28,0,'*',0,NULL,NULL)
,(119,'offcanvas','Featured Articles','featured-articles','','joomla-content/featured-articles','index.php?option=com_content&view=featured','component',1,118,2,22,NULL,NULL,0,1,' ',0,'{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"\",\"blog_class_leading\":\"\",\"num_intro_articles\":\"\",\"blog_class\":\"\",\"num_columns\":2,\"multi_column_order\":\"\",\"num_links\":\"\",\"link_intro_image\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}',20,21,0,'*',0,NULL,NULL)
,(120,'offcanvas','All Categories','all-categories','','joomla-content/all-categories','index.php?option=com_content&view=categories&id=8','component',1,118,2,22,NULL,NULL,0,1,' ',0,'{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_num_articles_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"display_num\":\"10\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',22,23,0,'*',0,NULL,NULL)
,(121,'offcanvas','Tagged Items','tagged-items','','joomla-content/tagged-items','index.php?option=com_tags&view=tag&id[0]=2','component',1,118,2,29,NULL,NULL,0,1,' ',0,'{\"show_tag_title\":\"\",\"tag_list_show_tag_image\":\"\",\"tag_list_show_tag_description\":\"\",\"tag_list_image\":\"\",\"tag_list_description\":\"\",\"tag_list_orderby\":\"\",\"tag_list_orderby_direction\":\"\",\"tag_list_show_item_image\":\"1\",\"tag_list_show_item_description\":\"1\",\"tag_list_item_maximum_characters\":150,\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"return_any_or_all\":\"\",\"include_children\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',24,25,0,'*',0,NULL,NULL)
,(122,'useful-links','Home','home-ft','','home-ft','index.php?Itemid=','alias',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"aliasoptions\":\"101\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',89,90,0,'*',0,NULL,NULL)
,(123,'useful-links','Services','services','','services','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',91,92,0,'*',0,NULL,NULL)
,(124,'useful-links','Courses','courses','','courses','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',93,94,0,'*',0,NULL,NULL)
,(125,'useful-links','Pages','pages-ft','','pages-ft','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',95,96,0,'*',0,NULL,NULL)
,(126,'useful-links','News & Events.','news-events','','news-events','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',97,98,0,'*',0,NULL,NULL)
,(127,'useful-links','Contact Us','contact-us-ft','','contact-us-ft','index.php?Itemid=','alias',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"aliasoptions\":\"113\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',99,100,0,'*',0,NULL,NULL)
,(128,'classes','Development','development','','development','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',101,102,0,'*',0,NULL,NULL)
,(129,'classes','Business','business','','business','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',103,104,0,'*',0,NULL,NULL)
,(130,'classes','IT & Software','it-software','','it-software','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',105,106,0,'*',0,NULL,NULL)
,(131,'classes','Design','design','','design','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',107,108,0,'*',0,NULL,NULL)
,(132,'classes','Photography','photography','','photography','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',109,110,0,'*',0,NULL,NULL)
,(133,'support','Documentation','documentation','','documentation','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',111,112,0,'*',0,NULL,NULL)
,(134,'support','F.A.Q','f-a-q','','f-a-q','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',113,114,0,'*',0,NULL,NULL)
,(135,'support','Media','media-ft','','media-ft','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',115,116,0,'*',0,NULL,NULL)
,(136,'support','Support Policy','support-policy','','support-policy','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',117,118,0,'*',0,NULL,NULL)
,(137,'support','Privacy / Terms of use','privacy-terms-of-use','','privacy-terms-of-use','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',119,120,0,'*',0,NULL,NULL)
,(138,'support','Advertise','advertise','','advertise','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',121,122,0,'*',0,NULL,NULL)
,(139,'resources','Get the Theme','get-the-theme','','get-the-theme','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',123,124,0,'*',0,NULL,NULL)
,(140,'resources','Deals & Coupons','deals-coupons','','deals-coupons','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',125,126,0,'*',0,NULL,NULL)
,(141,'resources','How It Works','how-it-works','','how-it-works','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',127,128,0,'*',0,NULL,NULL)
,(142,'resources','Tips & Tricks','tips-tricks','','tips-tricks','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',129,130,0,'*',0,NULL,NULL)
,(143,'resources','Terms of Service','terms-of-service','','terms-of-service','#','url',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',131,132,0,'*',0,NULL,NULL)
,(177,'mainmenu','About Us','about-us','','about-us','index.php?option=com_content&view=article&id=11','component',1,1,1,22,NULL,NULL,0,1,' ',0,'{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\" about-us-detail\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',29,30,0,'*',0,NULL,NULL)
,(180,'offcanvas','Typography','typography','','joomla-content/typography','index.php?option=com_content&view=article&id=12','component',1,118,2,22,NULL,NULL,0,1,' ',0,'{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',26,27,0,'*',0,NULL,NULL)
,(181,'offcanvas','Offline Page','offline-page','','other-pages/offline-page','index.php?option=com_content&view=article&id=14','component',1,196,2,22,NULL,NULL,0,1,' ',0,'{\"show_title\":\"\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_hits\":\"\",\"show_tags\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}',14,15,0,'*',0,NULL,NULL)
,(182,'offcanvas','Error Page','error-page','','other-pages/error-page','index.php?option=com_content&view=article&id=13','component',1,196,2,22,NULL,NULL,0,1,' ',0,'{\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_hits\":\"\",\"show_tags\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}',16,17,0,'*',0,NULL,NULL)
,(185,'main','COM_JAEXTMANAGER','com-jaextmanager','','com-jaextmanager','index.php?option=com_jaextmanager','component',1,1,1,10015,NULL,NULL,0,1,'components/com_jaextmanager/assets/images/jauc.png',0,'{}',135,136,0,'',1,NULL,NULL)
,(188,'main','-','1627980880-2395','','Contacts/1627980880-2395','#','separator',1,7,2,33,NULL,NULL,0,0,' ',0,'{}',50,51,0,'*',1,NULL,NULL)
,(189,'main','mod_menu_fields','contact-custom-fields','','Contacts/contact-custom-fields','index.php?option=com_fields&context=com_contact.contact','component',1,7,2,33,NULL,NULL,0,0,' ',0,'{}',52,53,0,'*',1,NULL,NULL)
,(190,'main','mod_menu_fields_group','contact-custom-fields-group','','Contacts/contact-custom-fields-group','index.php?option=com_fields&view=groups&context=com_contact.contact','component',1,7,2,33,NULL,NULL,0,0,' ',0,'{}',54,55,0,'*',1,NULL,NULL)
,(191,'main','-','1627980880-2406','','Smart Search/1627980880-2406','#','separator',1,18,2,27,NULL,NULL,0,0,' ',0,'{}',74,75,0,'*',1,NULL,NULL)
,(192,'main','com_finder_index','smart-search-index','','Smart Search/smart-search-index','index.php?option=com_finder&view=index','component',1,18,2,27,NULL,NULL,0,0,' ',0,'{}',76,77,0,'*',1,NULL,NULL)
,(193,'main','com_finder_maps','smart-search-maps','','Smart Search/smart-search-maps','index.php?option=com_finder&view=maps','component',1,18,2,27,NULL,NULL,0,0,' ',0,'{}',78,79,0,'*',1,NULL,NULL)
,(194,'main','com_finder_filters','smart-search-filters','','Smart Search/smart-search-filters','index.php?option=com_finder&view=filters','component',1,18,2,27,NULL,NULL,0,0,' ',0,'{}',80,81,0,'*',1,NULL,NULL)
,(195,'main','com_finder_searches','smart-search-searches','','Smart Search/smart-search-searches','index.php?option=com_finder&view=searches','component',1,18,2,27,NULL,NULL,0,0,' ',0,'{}',82,83,0,'*',1,NULL,NULL)
,(196,'offcanvas','Other pages','other-pages','','other-pages','','heading',1,1,1,0,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}',11,18,0,'*',0,NULL,NULL)
,(197,'usermenu','Password Reset','password-reset','','password-reset','index.php?option=com_users&view=reset','component',1,1,1,25,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":0,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}',137,138,0,'*',0,NULL,NULL)
,(198,'usermenu','Username Reminder Request','username-reminder-request','','username-reminder-request','index.php?option=com_users&view=remind','component',1,1,1,25,NULL,NULL,0,1,' ',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":0,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}',139,140,0,'*',0,NULL,NULL);
/*!40000 ALTER TABLE `#__menu` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__menu_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `menutype` varchar(24) NOT NULL,
  `title` varchar(48) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__menu_types` DISABLE KEYS */;
INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES 
(1,0,'mainmenu','Main Menu','The main menu for the site',0)
,(2,0,'usermenu','User Menu','A Menu for logged-in Users',0)
,(3,101,'useful-links','Useful Links','',0)
,(4,102,'classes','Classes','',0)
,(5,103,'support','Supports','',0)
,(6,104,'resources','Resources','',0)
,(7,0,'guru-categories','Guru Categories','Guru Categories',0)
,(8,114,'offcanvas','Offcanvas','',0);
/*!40000 ALTER TABLE `#__menu_types` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT 0,
  `user_id_to` int(10) unsigned NOT NULL DEFAULT 0,
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `date_time` datetime NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `priority` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` mediumtext NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__messages` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__messages_cfg`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `cfg_name` varchar(100) NOT NULL DEFAULT '',
  `cfg_value` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__messages_cfg` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__messages_cfg` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the j08b41_assets table.',
  `title` varchar(100) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `position` varchar(50) NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `module` varchar(50) DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `params` mediumtext NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__modules` DISABLE KEYS */;
INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES 
(2,40,'Login','','',1,'login',NULL,NULL,NULL,NULL,1,'mod_login',1,1,'',1,'*')
,(3,41,'Popular Articles','','',3,'cpanel',NULL,NULL,NULL,NULL,1,'mod_popular',3,1,'{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}',1,'*')
,(4,42,'Recently Added Articles','','',4,'cpanel',NULL,NULL,NULL,NULL,1,'mod_latest',3,1,'{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}',1,'*')
,(8,43,'Toolbar','','',1,'toolbar',NULL,NULL,NULL,NULL,1,'mod_toolbar',3,1,'',1,'*')
,(9,44,'Notifications','','',3,'icon',NULL,NULL,NULL,NULL,1,'mod_quickicon',3,1,'{\"context\":\"update_quickicon\",\"header_icon\":\"fas fa-sync\",\"show_global\":\"0\",\"show_checkin\":\"0\",\"show_cache\":\"0\",\"show_users\":\"0\",\"show_articles\":\"0\",\"show_categories\":\"0\",\"show_media\":\"0\",\"show_menuItems\":\"0\",\"show_modules\":\"0\",\"show_plugins\":\"0\",\"show_templates\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}',1,'*')
,(10,45,'Logged-in Users','','',2,'cpanel',NULL,NULL,NULL,NULL,1,'mod_logged',3,1,'{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}',1,'*')
,(12,46,'Admin Menu','','',1,'menu',NULL,NULL,NULL,NULL,1,'mod_menu',3,1,'{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}',1,'*')
,(13,47,'Admin Submenu','','',1,'submenu',NULL,NULL,NULL,NULL,1,'mod_submenu',3,1,'',1,'*')
,(14,48,'User Status','','',2,'status',NULL,NULL,NULL,NULL,1,'mod_status',3,1,'',1,'*')
,(15,49,'Title','','',1,'title',NULL,NULL,NULL,NULL,1,'mod_title',3,1,'',1,'*')
,(79,52,'Multilanguage status','','',2,'status',NULL,NULL,NULL,NULL,0,'mod_multilangstatus',3,1,'{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}',1,'*')
,(86,53,'Joomla Version','','',1,'status',NULL,NULL,NULL,NULL,1,'mod_version',3,1,'{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}',1,'*')
,(88,55,'Site Information','','',3,'cpanel',NULL,NULL,NULL,NULL,1,'mod_stats_admin',3,1,'{\"serverinfo\":\"1\",\"siteinfo\":\"1\",\"counter\":\"0\",\"increase\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}',1,'*')
,(89,56,'Release News','','',0,'postinstall',NULL,NULL,NULL,NULL,1,'mod_feed',1,1,'{\"rssurl\":\"https:\\/\\/www.joomla.org\\/announcements\\/release-news.feed\",\"rssrtl\":\"0\",\"rsstitle\":\"1\",\"rssdesc\":\"1\",\"rssimage\":\"1\",\"rssitems\":\"3\",\"rssitemdesc\":\"1\",\"word_count\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}',1,'*')
,(94,61,'Latest Actions','','',0,'cpanel',NULL,NULL,NULL,NULL,1,'mod_latestactions',6,1,'{}',1,'*')
,(95,67,'Hero','','',1,'hero',NULL,NULL,NULL,NULL,1,'mod_ja_acm',1,1,'{\"jatools-config\":\"{\\\":type\\\":\\\"ja_sensei:features-intro\\\",\\\"features-intro\\\":{\\\"jatools-layout-features-intro\\\":\\\"style-1\\\",\\\"features-intro[ft-bg]\\\":[\\\"images\\/joomlart\\/hero\\/item-1.png\\\"],\\\"features-intro[title]\\\":[\\\"The Prodigious eLearning Courses for you.\\\"],\\\"features-intro[description]\\\":[\\\"One Day. One new Skill. Started from $9.00 with over 1500 courses in 18 subjects, you\'re guaranteed to find something that\'s right for you.\\\"],\\\"features-intro[btn-title]\\\":[\\\"Start your free trial\\\",\\\"Plans & Pricing\\\"],\\\"features-intro[btn-link]\\\":[\\\"index.php?Itemid=111\\\",\\\"index.php?Itemid=113\\\"],\\\"features-intro[btn-type]\\\":[\\\"primary\\\",\\\"default\\\"]}}\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-large\"}',0,'*')
,(96,68,'Top Left','','<p>\r\n  Say Hello to Experts eLearning Joomla Template!\r\n</p>',1,'topbar-left',NULL,NULL,NULL,NULL,1,'mod_custom',1,1,'{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(97,69,'JA Masthead','','',1,'masthead',NULL,NULL,'2021-08-03 08:48:32',NULL,1,'mod_jamasthead',1,1,'{\"default-title\":\"Ja Sensei\",\"default-description\":\"Praesent quis libero sed nisl dolor elementum magna suscipit ligula eget libero amenus turpis.\",\"menuitem_config\":{\"item_id\":[[\"113\"],[\"114\"],[\"177\"]],\"title\":[\"Get In Touch\",\"Our blog\",\"About us\"],\"description\":[\"Let\'s talk about our website or project. Send us an email at <a href=\\\"#\\\">no-reply@gmail.com<\\/a> or fill out the form below and a member of our team will be in touch within <b>one business day<\\/b>.\",\"Praesent quis libero sed nisl dolor elementum magna suscipit ligula eget libero amenus turpis.\",\"Praesent quis libero sed nisl dolor elementum magna suscipit ligula eget libero amenus turpis.\"],\"background\":[\"\",\"\",\"\"]},\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}',0,'*')
,(98,77,'Login','','',2,'sidebar-2',NULL,NULL,NULL,NULL,1,'mod_login',1,1,'{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":1,\"name\":0,\"profilelink\":0,\"usesecure\":0,\"usetext\":0,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":0,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(99,78,'Banner 1','','<a href=\"#\">\r\n<img src=\"images/joomlart/others/banner-1.jpg\" alt=\"\"/>\r\n</a>',1,'sidebar-2',NULL,NULL,NULL,NULL,1,'mod_custom',1,0,'{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(100,79,'Categories','','',1,'sidebar-2',NULL,NULL,NULL,NULL,1,'mod_articles_categories',1,1,'{\"parent\":8,\"show_description\":0,\"numitems\":0,\"show_children\":0,\"count\":0,\"maxlevel\":0,\"layout\":\"_:default\",\"item_heading\":4,\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(101,80,'News & Update','','',1,'sidebar-2',NULL,NULL,NULL,NULL,1,'mod_articles_latest',1,1,'{\"catid\":[8,9,10,11],\"count\":5,\"show_featured\":\"\",\"ordering\":\"p_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(102,94,'About Sensei','','',1,'section-top',NULL,NULL,NULL,NULL,1,'mod_ja_acm',1,1,'{\"jatools-config\":\"{\\\":type\\\":\\\"ja_sensei:features-intro\\\",\\\"features-intro\\\":{\\\"jatools-layout-features-intro\\\":\\\"style-2\\\",\\\"features-intro[columns]\\\":[\\\"3\\\"],\\\"features-intro[font-icon]\\\":[\\\"\\\",\\\"\\\",\\\"\\\"],\\\"features-intro[img-icon]\\\":[\\\"images\\/joomlart\\/others\\/icon-1.png\\\",\\\"images\\/joomlart\\/others\\/icon-2.png\\\",\\\"images\\/joomlart\\/others\\/icon-3.png\\\"],\\\"features-intro[title]\\\":[\\\"Learn Anywhere\\\",\\\"Expert Instruction\\\",\\\"Lifetime Access\\\"],\\\"features-intro[description]\\\":[\\\"Duis aliquet luctus ipsum, nec dignissim diam semper nec. Praesent quis libero sed nisl dolor elementum magna suscipit ligula eget libero amenus turpis.\\\",\\\"Suspendisse vehicula, orci vel accumsan eleifend, quam massa aliquet sem, at mattis orci elit eu risus. Fusce tristique elit vel erat efficitur mollis.\\\",\\\"Morbi quis arcu ut ipsum tincidunt tincidunt non at quam. Vivamus accumsan tristique enim quis malesuada. Etiam sollicitudin ut nulla ac lobortis.\\\"],\\\"features-intro[link]\\\":[\\\"#\\\",\\\"#\\\",\\\"#\\\"],\\\"features-intro[link-title]\\\":[\\\"View our Courses\\\",\\\"Meet the Team\\\",\\\"See Plans & Pricing\\\"]}}\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"Learning a new skill doesn\'t have to interrupt your busy schedule.\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-large\"}',0,'*')
,(103,95,'Why Choose Us','','',2,'section-top',NULL,NULL,NULL,NULL,1,'mod_ja_acm',1,1,'{\"jatools-config\":\"{\\\":type\\\":\\\"ja_sensei:features-intro\\\",\\\"features-intro\\\":{\\\"jatools-layout-features-intro\\\":\\\"style-3\\\",\\\"features-intro[img-features]\\\":[\\\"images\\/joomlart\\/others\\/feature-1.jpg\\\"],\\\"features-intro[description]\\\":[\\\"((p class=\'lead\'))\\\\n\\\\tEgestas nulla ac efficitur eleifend. Quisque fringilla semper, libero hendrerit convallis, magna augue putate nibh ucibus enim eros eget arcu scelerisque. Maecenas semper sapien.\\\\n((\\/p))\\\\n\\\\n((ul class=\'list-check\'))\\\\n\\\\t((li))Over 1500 Courses in 18 Subjects.((\\/li))\\\\n\\\\t((li))Practice Smarter.((\\/li))\\\\n\\\\t((li))Support from over 500.000 fellow students.((\\/li))\\\\n\\\\t((li))One Day. One new Skill. Started from $9.00.((\\/li))\\\\n((\\/ul))\\\"],\\\"features-intro[button]\\\":[\\\"Start your free trial\\\"],\\\"features-intro[title-link]\\\":[\\\"index.php?Itemid=111\\\"]}}\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"The leading global \\r\\nmarketplace for learning and instruction. \",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-large\"}',0,'*')
,(104,96,'Featured Instructor','','',3,'section-top',NULL,NULL,NULL,NULL,1,'mod_ja_acm',1,1,'{\"jatools-config\":\"{\\\":type\\\":\\\"ja_sensei:teams\\\",\\\"teams\\\":{\\\"jatools-layout-teams\\\":\\\"style-1\\\",\\\"teams-intro[description]\\\":[\\\"((p class=\'lead\'))Cras egestas tellus eu ex rutrum, dictum tincidunt\\\\nultricies. Integer feugiat aliquam risus in rhoncus. Proin eu nulla facilisis, condimentum odio eu, euismod sagittis\\\\nincidunt ipsum. Cras ut eleifend lacus, id suscipit libero dolor ligula.((\\/p))\\\"],\\\"teams-intro[button]\\\":[\\\"Meet our Team\\\"],\\\"teams-intro[title-link]\\\":[\\\"index.php?Itemid=177\\\"],\\\"teams-intro[button-2]\\\":[\\\"Become an Instructor\\\"],\\\"teams-intro[title-link-2]\\\":[\\\"index.php?Itemid=113\\\"],\\\"teams-intro[avatar]\\\":[\\\"images\\/joomlart\\/teams\\/item-1.jpg\\\",\\\"images\\/joomlart\\/teams\\/item-2.jpg\\\",\\\"images\\/joomlart\\/teams\\/item-3.jpg\\\",\\\"images\\/joomlart\\/teams\\/item-4.jpg\\\"],\\\"teams-intro[name]\\\":[\\\"Doris R. Naber\\\",\\\"Doris R. Naber\\\",\\\"Doris R. Naber\\\",\\\"Doris R. Naber\\\"],\\\"teams-intro[info-postion]\\\":[\\\"Operations director\\\",\\\"Operations director\\\",\\\"Operations director\\\",\\\"Operations director\\\"],\\\"teams-intro[info-social]\\\":[\\\"((ul class=\'social-list\'))\\\\n\\\\t((li))((a href=\'#\' title=\'facebook\'))((span class=\'fa fa-facebook\'))((\\/span))((\\/a))((\\/li))\\\\n\\\\t((li))((a href=\'#\' title=\'twitter\'))((span class=\'fa fa-twitter\'))((\\/span))((\\/a))((\\/li))\\\\n\\\\t((li))((a href=\'#\' title=\'instagram\'))((span class=\'fa fa-instagram\'))((\\/span))((\\/a))((\\/li))\\\\n((\\/ul))\\\",\\\"((ul class=\'social-list\'))\\\\n\\\\t((li))((a href=\'#\' title=\'facebook\'))((span class=\'fa fa-facebook\'))((\\/span))((\\/a))((\\/li))\\\\n\\\\t((li))((a href=\'#\' title=\'twitter\'))((span class=\'fa fa-twitter\'))((\\/span))((\\/a))((\\/li))\\\\n\\\\t((li))((a href=\'#\' title=\'instagram\'))((span class=\'fa fa-instagram\'))((\\/span))((\\/a))((\\/li))\\\\n((\\/ul))\\\",\\\"((ul class=\'social-list\'))\\\\n\\\\t((li))((a href=\'#\' title=\'facebook\'))((span class=\'fa fa-facebook\'))((\\/span))((\\/a))((\\/li))\\\\n\\\\t((li))((a href=\'#\' title=\'twitter\'))((span class=\'fa fa-twitter\'))((\\/span))((\\/a))((\\/li))\\\\n\\\\t((li))((a href=\'#\' title=\'instagram\'))((span class=\'fa fa-instagram\'))((\\/span))((\\/a))((\\/li))\\\\n((\\/ul))\\\",\\\"((ul class=\'social-list\'))\\\\n\\\\t((li))((a href=\'#\' title=\'facebook\'))((span class=\'fa fa-facebook\'))((\\/span))((\\/a))((\\/li))\\\\n\\\\t((li))((a href=\'#\' title=\'twitter\'))((span class=\'fa fa-twitter\'))((\\/span))((\\/a))((\\/li))\\\\n\\\\t((li))((a href=\'#\' title=\'instagram\'))((span class=\'fa fa-instagram\'))((\\/span))((\\/a))((\\/li))\\\\n((\\/ul))\\\"]}}\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"We take education to the next level the provides \\r\\nfreedom & creativity.\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-large\"}',0,'*')
,(105,97,'Testimonials','','',4,'section-top',NULL,NULL,NULL,NULL,1,'mod_ja_acm',1,1,'{\"jatools-config\":\"{\\\":type\\\":\\\"ja_sensei:testimonials\\\",\\\"testimonials\\\":{\\\"jatools-layout-testimonials\\\":\\\"style-1\\\",\\\"testimonial-intro[data]\\\":{\\\"testimonial-intro[data][img]\\\":[\\\"images\\/joomlart\\/testimonials\\/item-1.jpg\\\",\\\"images\\/joomlart\\/testimonials\\/item-2.jpg\\\",\\\"images\\/joomlart\\/testimonials\\/item-3.jpg\\\"],\\\"testimonial-intro[data][name]\\\":[\\\"Patrick M. O\'Connell\\\",\\\"Doris R. Naber\\\",\\\"Doris R. Naber\\\"],\\\"testimonial-intro[data][member-position]\\\":[\\\"Designer\\\",\\\"Operations director\\\",\\\"Director\\\"],\\\"testimonial-intro[data][member-description]\\\":[\\\"\\u201cVery explained even for a short course. It\'s not for full \\\\nunderstanding, but it works perfectly as an introduction for the subject. And you can really build a robot after taking this course.\\u201d\\\",\\\"\\u201cVery explained even for a short course. It\'s not for full \\\\nunderstanding, but it works perfectly as an introduction for the subject. And you can really build a robot after taking this course.\\u201d\\\",\\\"\\u201cVery explained even for a short course. It\'s not for full \\\\nunderstanding, but it works perfectly as an introduction for the subject. And you can really build a robot after taking this course.\\u201d\\\"],\\\"rows\\\":3,\\\"cols\\\":5,\\\"type\\\":\\\"list\\\"}}}\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"Sensei is your best eLearning Company in the World.\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-normal\"}',0,'*')
,(106,98,'Trusted by companies of all sizes','','',5,'section-top',NULL,NULL,NULL,NULL,1,'mod_ja_acm',1,1,'{\"jatools-config\":\"{\\\":type\\\":\\\"ja_sensei:clients\\\",\\\"clients\\\":{\\\"jatools-layout-clients\\\":\\\"style-1\\\",\\\"clients[columns]\\\":[\\\"5\\\"],\\\"clients[img-gray]\\\":[\\\"0\\\"],\\\"clients[img-opacity]\\\":[\\\"30\\\"],\\\"clients[client-item]\\\":{\\\"clients[client-item][client-logo]\\\":[\\\"images\\/joomlart\\/clients\\/item-1.png\\\",\\\"images\\/joomlart\\/clients\\/item-2.png\\\",\\\"images\\/joomlart\\/clients\\/item-3.png\\\",\\\"images\\/joomlart\\/clients\\/item-4.png\\\",\\\"images\\/joomlart\\/clients\\/item-5.png\\\"],\\\"clients[client-item][client-name]\\\":[\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\"],\\\"clients[client-item][client-link]\\\":[\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\"],\\\"rows\\\":5,\\\"cols\\\":4,\\\"type\\\":\\\"list\\\"}}}\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"sub-heading\":\"\",\"space-top\":\"spt-none\",\"space-bottom\":\"spb-none\"}',0,'*')
,(107,99,'Call to Action','','<div class=\"cta container\">\r\n  <a href=\"#\" class=\"btn btn-success btn-block\">Start mastering your courses! Subscribe and try now for free. <span class=\"icon ion-ios-arrow-round-forward\"></span></a>\r\n</div>\r\n            ',1,'section-bottom',NULL,NULL,NULL,NULL,1,'mod_custom',1,0,'{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-none\"}',0,'*')
,(108,100,'Logo Footer','','<a href=\"index.php\" title=\"JA Sensei\">\r\n	<img src=\"images/joomlart/others/logo.png\" alt=\"\"/>\r\n</a>',1,'footer-1',NULL,NULL,NULL,NULL,1,'mod_custom',1,0,'{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(109,105,'Useful Links','','',1,'footer-2',NULL,NULL,NULL,NULL,1,'mod_menu',1,1,'{\"menutype\":\"useful-links\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(110,106,'Classes','','',1,'footer-3',NULL,NULL,NULL,NULL,1,'mod_menu',1,1,'{\"menutype\":\"classes\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(111,107,'Supports','','',1,'footer-4',NULL,NULL,NULL,NULL,1,'mod_menu',1,1,'{\"menutype\":\"support\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(112,108,'Resources','','',1,'footer-5',NULL,NULL,NULL,NULL,1,'mod_menu',1,1,'{\"menutype\":\"resources\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(113,109,'Footer','','',1,'footer',NULL,NULL,NULL,NULL,1,'mod_footer',1,1,'{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\"}',0,'*')
,(117,115,'Bonus Pages','','',2,'off-canvas',NULL,NULL,NULL,NULL,1,'mod_menu',1,1,'{\"menutype\":\"offcanvas\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-large\"}',0,'*')
,(118,116,'Member Actions','','<a href=\"index.php?Itemid=110\" title=\"Sign in\">Sign In</a> or <a href=\"index.php?Itemid=111\" title=\"Create an Account\">Create an Account</a>',1,'topbar-right',NULL,NULL,NULL,NULL,0,'mod_custom',1,1,'{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" hidden-xs\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-large\"}',0,'*')
,(119,117,'Social','','<ul class=\"social-list\">\r\n	<li><a href=\"#\" title=\"facebook\"><span class=\"fa fa-facebook\" aria-hidden=\"true\"></span></a></li>\r\n	<li><a href=\"#\" title=\"twitter\"><span class=\"fa fa-twitter\" aria-hidden=\"true\"></span></a></li>\r\n	<li><a href=\"#\" title=\"vimeo\"><span class=\"fa fa-vimeo\" aria-hidden=\"true\"></span></a></li>\r\n	<li><a href=\"#\" title=\"rss\"><span class=\"fa fa-rss\" aria-hidden=\"true\"></span></a></li>\r\n</ul>',3,'topbar-right',NULL,NULL,NULL,NULL,1,'mod_custom',1,1,'{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-large\"}',0,'*')
,(120,118,'Smart Search','','',1,'head-search',NULL,NULL,'2021-08-03 08:48:32',NULL,1,'mod_finder',1,1,'{\"searchfilter\":\"\",\"show_autosuggest\":1,\"show_advanced\":0,\"field_size\":25,\"show_label\":1,\"label_pos\":\"left\",\"alt_label\":\"\",\"show_button\":0,\"button_pos\":\"left\",\"opensearch\":1,\"opensearch_title\":\"\",\"set_itemid\":0,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-large\"}',0,'*')
,(121,124,'JA Login','','',2,'topbar-right',NULL,NULL,NULL,NULL,1,'mod_jalogin',1,1,'{\"pretext\":\"\",\"posttext\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"show_register_form\":\"1\",\"login\":\"\",\"logout\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-large\"}',0,'*')
,(123,126,'Main Menu','','',1,'off-canvas',NULL,NULL,NULL,NULL,1,'mod_menu',1,1,'{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" visible-xs visible-sm\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"sub-heading\":\"\",\"space-top\":\"spt-large\",\"space-bottom\":\"spb-large\"}',0,'*')
,(124,0,'Login Support','','',1,'sidebar',NULL,NULL,NULL,NULL,1,'mod_loginsupport',1,1,'{\"forum_url\":\"https://forum.joomla.org/\",\"documentation_url\":\"https://docs.joomla.org/\",\"news_url\":\"https://www.joomla.org/announcements.html\",\"automatic_title\":1,\"prepare_content\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}',1,'*')
,(125,0,'System Dashboard','','',1,'cpanel-system',NULL,NULL,NULL,NULL,1,'mod_submenu',1,0,'{\"menutype\":\"*\",\"preset\":\"system\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}',1,'*')
,(126,0,'Content Dashboard','','',1,'cpanel-content',NULL,NULL,NULL,NULL,1,'mod_submenu',1,0,'{\"menutype\":\"*\",\"preset\":\"content\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"3\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}',1,'*')
,(127,0,'Menus Dashboard','','',1,'cpanel-menus',NULL,NULL,NULL,NULL,1,'mod_submenu',1,0,'{\"menutype\":\"*\",\"preset\":\"menus\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}',1,'*')
,(128,0,'Components Dashboard','','',1,'cpanel-components',NULL,NULL,NULL,NULL,1,'mod_submenu',1,0,'{\"menutype\":\"*\",\"preset\":\"components\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}',1,'*')
,(129,0,'Users Dashboard','','',1,'cpanel-users',NULL,NULL,NULL,NULL,1,'mod_submenu',1,0,'{\"menutype\":\"*\",\"preset\":\"users\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}',1,'*')
,(130,0,'Popular Articles','','',3,'cpanel-content',NULL,NULL,NULL,NULL,1,'mod_popular',3,1,'{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}',1,'*')
,(131,0,'Recently Added Articles','','',4,'cpanel-content',NULL,NULL,NULL,NULL,1,'mod_latest',3,1,'{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}',1,'*')
,(132,0,'Logged-in Users','','',2,'cpanel-users',NULL,NULL,NULL,NULL,1,'mod_logged',3,1,'{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}',1,'*')
,(133,0,'Frontend Link','','',5,'status',NULL,NULL,NULL,NULL,1,'mod_frontend',1,1,'',1,'*')
,(134,0,'Messages','','',4,'status',NULL,NULL,NULL,NULL,1,'mod_messages',3,1,'',1,'*')
,(135,0,'Post Install Messages','','',3,'status',NULL,NULL,NULL,NULL,1,'mod_post_installation_messages',3,1,'',1,'*')
,(136,0,'User Status','','',6,'status',NULL,NULL,NULL,NULL,1,'mod_user',3,1,'',1,'*')
,(137,0,'Site','','',1,'icon',NULL,NULL,NULL,NULL,1,'mod_quickicon',1,1,'{\"context\":\"site_quickicon\",\"header_icon\":\"fas fa-desktop\",\"show_users\":\"1\",\"show_articles\":\"1\",\"show_categories\":\"1\",\"show_media\":\"1\",\"show_menuItems\":\"1\",\"show_modules\":\"1\",\"show_plugins\":\"1\",\"show_templates\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}',1,'*')
,(138,0,'System','','',2,'icon',NULL,NULL,NULL,NULL,1,'mod_quickicon',1,1,'{\"context\":\"system_quickicon\",\"header_icon\":\"fas fa-wrench\",\"show_global\":\"1\",\"show_checkin\":\"1\",\"show_cache\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}',1,'*')
,(139,0,'3rd Party','','',4,'icon',NULL,NULL,NULL,NULL,1,'mod_quickicon',1,1,'{\"context\":\"mod_quickicon\",\"header_icon\":\"fas fa-boxes\",\"load_plugins\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}',1,'*')
,(140,0,'Help Dashboard','','',1,'cpanel-help',NULL,NULL,NULL,NULL,1,'mod_submenu',1,0,'{\"menutype\":\"*\",\"preset\":\"help\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"System-none\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}',1,'*')
,(141,0,'Privacy Requests','','',1,'cpanel-privacy',NULL,NULL,NULL,NULL,1,'mod_privacy_dashboard',1,1,'{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}',1,'*')
,(142,0,'Privacy Status','','',1,'cpanel-privacy',NULL,NULL,NULL,NULL,1,'mod_privacy_status',1,1,'{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}',1,'*')
,(143,0,'Guided Tours','','',1,'status',NULL,NULL,NULL,NULL,1,'mod_guidedtours',1,1,'',1,'*');
/*!40000 ALTER TABLE `#__modules` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__modules_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT 0,
  `menuid` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__modules_menu` DISABLE KEYS */;
INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES 
(2,0)
,(3,0)
,(4,0)
,(6,0)
,(7,0)
,(8,0)
,(9,0)
,(10,0)
,(12,0)
,(13,0)
,(14,0)
,(15,0)
,(79,0)
,(86,0)
,(88,0)
,(89,0)
,(94,0)
,(95,101)
,(96,0)
,(97,-101)
,(98,114)
,(98,119)
,(98,121)
,(99,114)
,(99,119)
,(99,121)
,(100,114)
,(100,119)
,(100,121)
,(101,114)
,(102,101)
,(103,101)
,(104,101)
,(105,101)
,(106,101)
,(107,0)
,(108,0)
,(109,0)
,(110,0)
,(111,0)
,(112,0)
,(113,0)
,(115,0)
,(116,101)
,(117,0)
,(118,0)
,(119,0)
,(120,0)
,(121,0)
,(123,0)
,(124,0)
,(125,0)
,(126,0)
,(127,0)
,(128,0)
,(129,0)
,(130,0)
,(131,0)
,(132,0)
,(133,0)
,(134,0)
,(135,0)
,(136,0)
,(137,0)
,(138,0)
,(139,0)
,(140,0)
,(141,0)
,(142,0)
,(143,0);
/*!40000 ALTER TABLE `#__modules_menu` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__newsfeeds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT 0,
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `link` varchar(2048) NOT NULL DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `numarticles` int(10) unsigned NOT NULL DEFAULT 1,
  `cache_time` int(10) unsigned NOT NULL DEFAULT 3600,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rtl` tinyint(4) NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `params` mediumtext NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `metakey` text DEFAULT NULL,
  `metadesc` mediumtext NOT NULL,
  `metadata` mediumtext NOT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `description` mediumtext NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `images` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__newsfeeds` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__newsfeeds` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__overrider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) NOT NULL,
  `string` mediumtext NOT NULL,
  `file` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__overrider` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__overrider` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__postinstall_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extension_id` bigint(20) NOT NULL DEFAULT 700 COMMENT 'FK to j08b41_extensions',
  `title_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) NOT NULL DEFAULT '',
  `language_extension` varchar(255) NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT 1,
  `type` varchar(10) NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT 1,
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__postinstall_messages` DISABLE KEYS */;
INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES 
(1,700,'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE','PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY','PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION','plg_twofactorauth_totp',1,'action','site://plugins/twofactorauth/totp/postinstall/actions.php','twofactorauth_postinstall_action','site://plugins/twofactorauth/totp/postinstall/actions.php','twofactorauth_postinstall_condition','3.2.0',1)
,(2,700,'COM_CPANEL_WELCOME_BEGINNERS_TITLE','COM_CPANEL_WELCOME_BEGINNERS_MESSAGE','','com_cpanel',1,'message','','','','','3.2.0',1)
,(3,700,'COM_CPANEL_MSG_STATS_COLLECTION_TITLE','COM_CPANEL_MSG_STATS_COLLECTION_BODY','','com_cpanel',1,'message','','','admin://components/com_admin/postinstall/statscollection.php','admin_postinstall_statscollection_condition','3.5.0',1)
,(4,700,'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME','PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY','PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION','plg_system_updatenotification',1,'action','site://plugins/system/updatenotification/postinstall/updatecachetime.php','updatecachetime_postinstall_action','site://plugins/system/updatenotification/postinstall/updatecachetime.php','updatecachetime_postinstall_condition','3.6.3',1)
,(8,700,'COM_ACTIONLOGS_POSTINSTALL_TITLE','COM_ACTIONLOGS_POSTINSTALL_BODY','','com_actionlogs',1,'message','','','','','3.9.0',1)
,(9,700,'COM_PRIVACY_POSTINSTALL_TITLE','COM_PRIVACY_POSTINSTALL_BODY','','com_privacy',1,'message','','','','','3.9.0',1)
,(10,700,'COM_CPANEL_MSG_ADDNOSNIFF_TITLE','COM_CPANEL_MSG_ADDNOSNIFF_BODY','','com_cpanel',1,'message','','','admin://components/com_admin/postinstall/addnosniff.php','admin_postinstall_addnosniff_condition','3.9.3',1)
,(11,700,'COM_CPANEL_MSG_TEXTFILTER3919_TITLE','COM_CPANEL_MSG_TEXTFILTER3919_BODY','','com_cpanel',1,'message','','','admin://components/com_admin/postinstall/textfilter3919.php','admin_postinstall_textfilter3919_condition','3.9.19',1)
,(12,700,'COM_CPANEL_MSG_HTACCESSSVG_TITLE','COM_CPANEL_MSG_HTACCESSSVG_BODY','','com_cpanel',1,'message','','','admin://components/com_admin/postinstall/htaccesssvg.php','admin_postinstall_htaccesssvg_condition','3.9.21',1)
,(13,700,'COM_ADMIN_POSTINSTALL_MSG_HTACCESS_AUTOINDEX_TITLE','COM_ADMIN_POSTINSTALL_MSG_HTACCESS_AUTOINDEX_DESCRIPTION','','com_admin',1,'message','','',NULL,NULL,'3.9.22',1)
,(14,700,'COM_ADMIN_POSTINSTALL_MSG_BEHIND_LOAD_BALANCER_TITLE','COM_ADMIN_POSTINSTALL_MSG_BEHIND_LOAD_BALANCER_DESCRIPTION','COM_ADMIN_POSTINSTALL_MSG_BEHIND_LOAD_BALANCER_ACTION','com_admin',1,'action','admin://components/com_admin/postinstall/behindproxy.php','behindproxy_postinstall_action','admin://components/com_admin/postinstall/behindproxy.php','admin_postinstall_behindproxy_condition','3.9.26',1)
,(16,700,'PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_TITLE','PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_BODY','PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_ACTION','plg_system_httpheaders',1,'action','site://plugins/system/httpheaders/postinstall/introduction.php','httpheaders_postinstall_action','site://plugins/system/httpheaders/postinstall/introduction.php','httpheaders_postinstall_condition','4.0.0',1)
,(17,700,'COM_ADMIN_POSTINSTALL_MSG_HTACCESS_SETCE_TITLE','COM_ADMIN_POSTINSTALL_MSG_HTACCESS_SETCE_DESCRIPTION','','com_admin',1,'message','','','admin://components/com_admin/postinstall/htaccesssetce.php','admin_postinstall_htaccesssetce_condition','4.2.9',1);
/*!40000 ALTER TABLE `#__postinstall_messages` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__privacy_consents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__privacy_consents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `state` int(10) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `body` mediumtext NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT 0,
  `token` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__privacy_consents` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__privacy_consents` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__privacy_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__privacy_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `request_type` varchar(25) NOT NULL DEFAULT '',
  `confirm_token` varchar(100) NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__privacy_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__privacy_requests` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__redirect_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__redirect_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) NOT NULL,
  `new_url` varchar(2048) DEFAULT NULL,
  `referer` varchar(2048) NOT NULL,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL,
  `modified_date` datetime NOT NULL,
  `header` smallint(3) NOT NULL DEFAULT 301,
  PRIMARY KEY (`id`),
  KEY `idx_old_url` (`old_url`(100)),
  KEY `idx_link_modified` (`modified_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__redirect_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__redirect_links` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__scheduler_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__scheduler_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'unique identifier for job defined by plugin',
  `execution_rules` text COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Execution Rules, Unprocessed',
  `cron_rules` text COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Processed execution rules, crontab-like JSON form',
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `last_exit_code` int(11) NOT NULL DEFAULT 0 COMMENT 'Exit code when job was last run',
  `last_execution` datetime DEFAULT NULL COMMENT 'Timestamp of last run',
  `next_execution` datetime DEFAULT NULL COMMENT 'Timestamp of next (planned) run, referred for execution on trigger',
  `times_executed` int(11) DEFAULT 0 COMMENT 'Count of successful triggers',
  `times_failed` int(11) DEFAULT 0 COMMENT 'Count of failures',
  `locked` datetime DEFAULT NULL,
  `priority` smallint(6) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0 COMMENT 'Configurable list ordering',
  `cli_exclusive` smallint(6) NOT NULL DEFAULT 0 COMMENT 'If 1, the task is only accessible via CLI',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_state` (`state`),
  KEY `idx_last_exit` (`last_exit_code`),
  KEY `idx_next_exec` (`next_execution`),
  KEY `idx_locked` (`locked`),
  KEY `idx_priority` (`priority`),
  KEY `idx_cli_exclusive` (`cli_exclusive`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__scheduler_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__scheduler_tasks` ENABLE KEYS */;


/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__schemas` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__schemas` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__session` (
  `session_id` varbinary(192) NOT NULL,
  `client_id` tinyint(3) unsigned DEFAULT NULL,
  `guest` tinyint(3) unsigned DEFAULT 1,
  `time` int(11) NOT NULL DEFAULT 0,
  `data` longtext DEFAULT NULL,
  `userid` int(11) DEFAULT 0,
  `username` varchar(150) DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `userid` (`userid`),
  KEY `time` (`time`),
  KEY `client_id_guest` (`client_id`,`guest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__session` DISABLE KEYS */;
INSERT INTO `#__session` (`session_id`, `client_id`, `guest`, `time`, `data`, `userid`, `username`) VALUES 
(0x3166366B75376B3439627469306B70613030726938767336706C,0,1,1665042580,'joomla|s:816:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6Nzoic2Vzc2lvbiI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo3OiJjb3VudGVyIjtpOjI7czo1OiJ0aW1lciI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo1OiJzdGFydCI7aToxNjY1MDQyNTMxO3M6NDoibGFzdCI7aToxNjY1MDQyNTMxO3M6Mzoibm93IjtpOjE2NjUwNDI1Nzk7fXM6NToidG9rZW4iO3M6MzI6IjJkNzJhZTZjMjg0ZjUwMzFkZTQ3MmJhNDQxMDk2MmU5Ijt9czo4OiJyZWdpc3RyeSI7TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6MTM6ImN1cnJlbnRfdGhlbWUiO047czoxNzoiY3VycmVudF9kaXJlY3Rpb24iO3M6MzoibHRyIjtzOjE3OiJjdXJyZW50X2tleV9zdWZpeCI7czo1OiJfX2x0ciI7fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fXM6NDoidXNlciI7TzoyMDoiSm9vbWxhXENNU1xVc2VyXFVzZXIiOjE6e3M6MjoiaWQiO2k6MDt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==\";',0,'')
,(0x316B6564333037376E6A74616E3065336C6D6F61377163613261,1,0,1681959387,'joomla|s:1108:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjY6e3M6Nzoic2Vzc2lvbiI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo3OiJjb3VudGVyIjtpOjE0O3M6NToidGltZXIiO086ODoic3RkQ2xhc3MiOjM6e3M6NToic3RhcnQiO2k6MTY4MTk1OTI5OTtzOjQ6Imxhc3QiO2k6MTY4MTk1OTM4NjtzOjM6Im5vdyI7aToxNjgxOTU5Mzg2O31zOjU6InRva2VuIjtzOjMyOiI3MmRkNDQwMTU0OTU2NmY4ZGI3Yjc5NDJkOTE0NDQ2MCI7fXM6ODoicmVnaXN0cnkiO086MjQ6Ikpvb21sYVxSZWdpc3RyeVxSZWdpc3RyeSI6Mzp7czo3OiIAKgBkYXRhIjtPOjg6InN0ZENsYXNzIjoxOntzOjE2OiJjb21fam9vbWxhdXBkYXRlIjtPOjg6InN0ZENsYXNzIjo0OntzOjQ6ImZpbGUiO047czoxMDoib2xkdmVyc2lvbiI7TjtzOjg6InBhc3N3b3JkIjtzOjMyOiJVcFd2NUNaM0g2YmJ4QkhWSjZMbWdJd09qVFBPUTZ3ZSI7czo4OiJmaWxlc2l6ZSI7aToyODcyMTI3Mjt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czoxMjoiACoAc2VwYXJhdG9yIjtzOjE6Ii4iO31zOjQ6InVzZXIiO086MjA6Ikpvb21sYVxDTVNcVXNlclxVc2VyIjoxOntzOjI6ImlkIjtpOjQyO31zOjk6ImNvbV91c2VycyI7Tzo4OiJzdGRDbGFzcyI6MTp7czoxMToibWZhX2NoZWNrZWQiO2k6MTt9czo4OiJvdmVycmlkZSI7Tzo4OiJzdGRDbGFzcyI6MDp7fXM6MTE6ImFwcGxpY2F0aW9uIjtPOjg6InN0ZENsYXNzIjoxOntzOjU6InF1ZXVlIjthOjA6e319fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czoxMjoiACoAc2VwYXJhdG9yIjtzOjE6Ii4iO30=\";',42,'admin')
,(0x336D61686464756462693936626D717065357063726E70717234,1,0,1675910645,'joomla|s:1096:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjY6e3M6Nzoic2Vzc2lvbiI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo3OiJjb3VudGVyIjtpOjEwO3M6NToidGltZXIiO086ODoic3RkQ2xhc3MiOjM6e3M6NToic3RhcnQiO2k6MTY3NTkxMDYwNjtzOjQ6Imxhc3QiO2k6MTY3NTkxMDY0NDtzOjM6Im5vdyI7aToxNjc1OTEwNjQ0O31zOjU6InRva2VuIjtzOjMyOiI3NWJlNzg0ZGMwOTAxOGY4NTU2NzFmZDgzYTkzNjRiNCI7fXM6ODoicmVnaXN0cnkiO086MjQ6Ikpvb21sYVxSZWdpc3RyeVxSZWdpc3RyeSI6Mzp7czo3OiIAKgBkYXRhIjtPOjg6InN0ZENsYXNzIjoxOntzOjE2OiJjb21fam9vbWxhdXBkYXRlIjtPOjg6InN0ZENsYXNzIjo0OntzOjQ6ImZpbGUiO047czoxMDoib2xkdmVyc2lvbiI7TjtzOjg6InBhc3N3b3JkIjtzOjMyOiJ5c3BnSnMza1NyaW5SdDJEdHJGSE5WSWk4MjA2b0RieiI7czo4OiJmaWxlc2l6ZSI7aToyODA2MDM2MDt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fXM6NDoidXNlciI7TzoyMDoiSm9vbWxhXENNU1xVc2VyXFVzZXIiOjE6e3M6MjoiaWQiO2k6NDI7fXM6OToiY29tX3VzZXJzIjtPOjg6InN0ZENsYXNzIjoxOntzOjExOiJtZmFfY2hlY2tlZCI7aToxO31zOjg6Im92ZXJyaWRlIjtPOjg6InN0ZENsYXNzIjowOnt9czoxMToiYXBwbGljYXRpb24iO086ODoic3RkQ2xhc3MiOjE6e3M6NToicXVldWUiO2E6MDp7fX19czoxNDoiACoAaW5pdGlhbGl6ZWQiO2I6MDtzOjk6InNlcGFyYXRvciI7czoxOiIuIjt9\";',42,'admin')
,(0x3437726E6D6A6365396E6F313836346E6E316D67353371753964,0,1,1661160310,'joomla|s:816:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6Nzoic2Vzc2lvbiI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo3OiJjb3VudGVyIjtpOjI7czo1OiJ0aW1lciI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo1OiJzdGFydCI7aToxNjYxMTYwMjQwO3M6NDoibGFzdCI7aToxNjYxMTYwMjQwO3M6Mzoibm93IjtpOjE2NjExNjAzMDg7fXM6NToidG9rZW4iO3M6MzI6ImYxM2JkODBmMDc5YmQwNmY3N2RkMjFiYTVkMTkwYzBmIjt9czo4OiJyZWdpc3RyeSI7TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6MTM6ImN1cnJlbnRfdGhlbWUiO047czoxNzoiY3VycmVudF9kaXJlY3Rpb24iO3M6MzoibHRyIjtzOjE3OiJjdXJyZW50X2tleV9zdWZpeCI7czo1OiJfX2x0ciI7fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fXM6NDoidXNlciI7TzoyMDoiSm9vbWxhXENNU1xVc2VyXFVzZXIiOjE6e3M6MjoiaWQiO2k6MDt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==\";',0,'')
,(0x3461713437716E6D327567313876636265367670736A7533326D,1,0,1667187013,'joomla|s:1024:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjU6e3M6Nzoic2Vzc2lvbiI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo3OiJjb3VudGVyIjtpOjEyO3M6NToidGltZXIiO086ODoic3RkQ2xhc3MiOjM6e3M6NToic3RhcnQiO2k6MTY2NzE4Njk0NjtzOjQ6Imxhc3QiO2k6MTY2NzE4NzAxMjtzOjM6Im5vdyI7aToxNjY3MTg3MDEzO31zOjU6InRva2VuIjtzOjMyOiI2MmEzMTQzZGQ0MmE0ZDEyYjAwOGFkODkxNjE0ODY0ZCI7fXM6ODoicmVnaXN0cnkiO086MjQ6Ikpvb21sYVxSZWdpc3RyeVxSZWdpc3RyeSI6Mzp7czo3OiIAKgBkYXRhIjtPOjg6InN0ZENsYXNzIjoxOntzOjE2OiJjb21fam9vbWxhdXBkYXRlIjtPOjg6InN0ZENsYXNzIjo0OntzOjQ6ImZpbGUiO047czoxMDoib2xkdmVyc2lvbiI7TjtzOjg6InBhc3N3b3JkIjtzOjMyOiJVbE1BaGcyWGE0dmhTMDJoekdQQkZ3ZDFLZFgyWVF5eSI7czo4OiJmaWxlc2l6ZSI7aToyNzY5ODQ2Mjt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fXM6NDoidXNlciI7TzoyMDoiSm9vbWxhXENNU1xVc2VyXFVzZXIiOjE6e3M6MjoiaWQiO2k6NDI7fXM6OToiY29tX3VzZXJzIjtPOjg6InN0ZENsYXNzIjoxOntzOjExOiJtZmFfY2hlY2tlZCI7aToxO31zOjg6Im92ZXJyaWRlIjtPOjg6InN0ZENsYXNzIjowOnt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==\";',42,'admin')
,(0x656D67326B3034347332743064616C75706173307473656C6472,1,0,1665042571,'joomla|s:18712:\"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\";',42,'admin')
,(0x67386B6E646A396337683761626D70626D6E357567626D6B6476,1,0,1662453459,'joomla|s:1352:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjU6e3M6Nzoic2Vzc2lvbiI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo3OiJjb3VudGVyIjtpOjE5O3M6NToidGltZXIiO086ODoic3RkQ2xhc3MiOjM6e3M6NToic3RhcnQiO2k6MTY2MjQ1MzI1MTtzOjQ6Imxhc3QiO2k6MTY2MjQ1MzQ1ODtzOjM6Im5vdyI7aToxNjYyNDUzNDU4O31zOjU6InRva2VuIjtzOjMyOiJkZTgyOGVhZWZmODI3YmUwN2JiYjNiNmVlMzljYTBjZCI7fXM6ODoicmVnaXN0cnkiO086MjQ6Ikpvb21sYVxSZWdpc3RyeVxSZWdpc3RyeSI6Mzp7czo3OiIAKgBkYXRhIjtPOjg6InN0ZENsYXNzIjoyOntzOjEzOiJjb21faW5zdGFsbGVyIjtPOjg6InN0ZENsYXNzIjoxOntzOjg6ImRhdGFiYXNlIjtPOjg6InN0ZENsYXNzIjoyOntzOjY6ImZpbHRlciI7YTo0OntzOjY6InNlYXJjaCI7czowOiIiO3M6OToiY2xpZW50X2lkIjtzOjA6IiI7czo0OiJ0eXBlIjtzOjA6IiI7czo2OiJmb2xkZXIiO3M6MDoiIjt9czo0OiJsaXN0IjthOjI6e3M6MTI6ImZ1bGxvcmRlcmluZyI7czo4OiJuYW1lIEFTQyI7czo1OiJsaW1pdCI7czoyOiIyMCI7fX19czoxNjoiY29tX2pvb21sYXVwZGF0ZSI7Tzo4OiJzdGRDbGFzcyI6NDp7czo0OiJmaWxlIjtOO3M6MTA6Im9sZHZlcnNpb24iO047czo4OiJwYXNzd29yZCI7czozMjoiUUFaN1lVYVJDU3l4bHVvaUVZUUM4VnVwenBITlZkVXMiO3M6ODoiZmlsZXNpemUiO2k6Mjc1MTU1ODU7fX1zOjE0OiIAKgBpbml0aWFsaXplZCI7YjowO3M6OToic2VwYXJhdG9yIjtzOjE6Ii4iO31zOjQ6InVzZXIiO086MjA6Ikpvb21sYVxDTVNcVXNlclxVc2VyIjoxOntzOjI6ImlkIjtpOjQyO31zOjk6ImNvbV91c2VycyI7Tzo4OiJzdGRDbGFzcyI6MTp7czoxMToibWZhX2NoZWNrZWQiO2k6MTt9czo4OiJvdmVycmlkZSI7Tzo4OiJzdGRDbGFzcyI6MDp7fX1zOjE0OiIAKgBpbml0aWFsaXplZCI7YjowO3M6OToic2VwYXJhdG9yIjtzOjE6Ii4iO30=\";',42,'admin')
,(0x686237616975617162367669306C6A657572313273656F6C7162,0,1,1681959284,'joomla|s:816:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6Nzoic2Vzc2lvbiI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo3OiJjb3VudGVyIjtpOjE7czo1OiJ0aW1lciI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo1OiJzdGFydCI7aToxNjgxOTU5MjgxO3M6NDoibGFzdCI7aToxNjgxOTU5MjgxO3M6Mzoibm93IjtpOjE2ODE5NTkyODE7fXM6NToidG9rZW4iO3M6MzI6IjEyMjYwNjhiNDc3ODk1ZWY4YzhmMDMxNWE1MzY3NDM1Ijt9czo4OiJyZWdpc3RyeSI7TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6MTM6ImN1cnJlbnRfdGhlbWUiO047czoxNzoiY3VycmVudF9kaXJlY3Rpb24iO3M6MzoibHRyIjtzOjE3OiJjdXJyZW50X2tleV9zdWZpeCI7czo1OiJfX2x0ciI7fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fXM6NDoidXNlciI7TzoyMDoiSm9vbWxhXENNU1xVc2VyXFVzZXIiOjE6e3M6MjoiaWQiO2k6MDt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==\";',0,'')
,(0x68756B6F3065767032346F386164636E39366330366E6E626236,0,1,1675910601,'joomla|s:816:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6Nzoic2Vzc2lvbiI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo3OiJjb3VudGVyIjtpOjE7czo1OiJ0aW1lciI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo1OiJzdGFydCI7aToxNjc1OTEwNTk4O3M6NDoibGFzdCI7aToxNjc1OTEwNTk4O3M6Mzoibm93IjtpOjE2NzU5MTA1OTg7fXM6NToidG9rZW4iO3M6MzI6ImFhZjg4OTQ1YjNjZmNmNzQ1Yjk3MDFkNWQxMTE2ZTdjIjt9czo4OiJyZWdpc3RyeSI7TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6MTM6ImN1cnJlbnRfdGhlbWUiO047czoxNzoiY3VycmVudF9kaXJlY3Rpb24iO3M6MzoibHRyIjtzOjE3OiJjdXJyZW50X2tleV9zdWZpeCI7czo1OiJfX2x0ciI7fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fXM6NDoidXNlciI7TzoyMDoiSm9vbWxhXENNU1xVc2VyXFVzZXIiOjE6e3M6MjoiaWQiO2k6MDt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==\";',0,'')
,(0x6E74646768647366616665743934713337667036733137343162,0,1,1667187019,'joomla|s:816:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6Nzoic2Vzc2lvbiI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo3OiJjb3VudGVyIjtpOjI7czo1OiJ0aW1lciI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo1OiJzdGFydCI7aToxNjY3MTg2OTMwO3M6NDoibGFzdCI7aToxNjY3MTg2OTMwO3M6Mzoibm93IjtpOjE2NjcxODcwMTk7fXM6NToidG9rZW4iO3M6MzI6IjcyZTM0NWU1YjY1OWY4OTkxODc2YmQ2MWU2MzdhMzViIjt9czo4OiJyZWdpc3RyeSI7TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6MTM6ImN1cnJlbnRfdGhlbWUiO047czoxNzoiY3VycmVudF9kaXJlY3Rpb24iO3M6MzoibHRyIjtzOjE3OiJjdXJyZW50X2tleV9zdWZpeCI7czo1OiJfX2x0ciI7fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fXM6NDoidXNlciI7TzoyMDoiSm9vbWxhXENNU1xVc2VyXFVzZXIiOjE6e3M6MjoiaWQiO2k6MDt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==\";',0,'')
,(0x70696D7461396A626F63337136356535743465716A7361687069,1,0,1661160319,'joomla|s:18712:\"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\";',42,'admin')
,(0x737430706A6C746332637674706F353274726F74766673387037,0,1,1662453215,'joomla|s:816:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6Nzoic2Vzc2lvbiI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo3OiJjb3VudGVyIjtpOjE7czo1OiJ0aW1lciI7Tzo4OiJzdGRDbGFzcyI6Mzp7czo1OiJzdGFydCI7aToxNjYyNDUzMjA4O3M6NDoibGFzdCI7aToxNjYyNDUzMjA4O3M6Mzoibm93IjtpOjE2NjI0NTMyMDg7fXM6NToidG9rZW4iO3M6MzI6ImQ2ZTJhZGE4OGFjMWY0NzU4NzI0NzIzMzU4YmZlZDgyIjt9czo4OiJyZWdpc3RyeSI7TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjM6e3M6MTM6ImN1cnJlbnRfdGhlbWUiO047czoxNzoiY3VycmVudF9kaXJlY3Rpb24iO3M6MzoibHRyIjtzOjE3OiJjdXJyZW50X2tleV9zdWZpeCI7czo1OiJfX2x0ciI7fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fXM6NDoidXNlciI7TzoyMDoiSm9vbWxhXENNU1xVc2VyXFVzZXIiOjE6e3M6MjoiaWQiO2k6MDt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==\";',0,'');
/*!40000 ALTER TABLE `#__session` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` mediumtext NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL DEFAULT '',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `images` mediumtext NOT NULL,
  `urls` mediumtext NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__tags` DISABLE KEYS */;
INSERT INTO `#__tags` (`id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `created_by_alias`, `modified_user_id`, `modified_time`, `images`, `urls`, `hits`, `language`, `version`, `publish_up`, `publish_down`) VALUES 
(1,0,0,3,0,'','ROOT','root','','',1,NULL,NULL,1,'{}','','','',0,'2021-08-03 08:48:32','',0,'2021-08-03 08:48:32','','',0,'*',1,NULL,NULL)
,(2,1,1,2,1,'joomla','Joomla','joomla','','',1,NULL,NULL,1,'{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\",\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','','','{\"author\":\"\",\"robots\":\"\"}',42,'2021-08-03 08:48:32','',42,'2021-08-03 08:48:32','','',37,'*',1,NULL,NULL);
/*!40000 ALTER TABLE `#__tags` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__template_overrides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__template_overrides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hash_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension_id` int(11) DEFAULT 0,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__template_overrides` DISABLE KEYS */;
INSERT INTO `#__template_overrides` (`id`, `template`, `hash_id`, `extension_id`, `state`, `action`, `client_id`, `created_date`, `modified_date`) VALUES 
(1,'ja_sensei','L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcmllcy9kZWZhdWx0LnBocA==',10003,0,'Joomla Update',0,'2021-08-25 02:13:33','2021-08-25 02:13:33')
,(2,'ja_sensei','L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcmllcy9kZWZhdWx0X2l0ZW1zLnBocA==',10003,0,'Joomla Update',0,'2021-08-25 02:13:33','2022-04-18 03:42:55')
,(3,'ja_sensei','L2h0bWwvbW9kX2phbWFzdGhlYWQvZGVmYXVsdC5waHA=',10003,0,'Extension Update',0,'2021-08-25 02:13:54','2021-08-25 02:13:54')
,(4,'ja_sensei','L2h0bWwvbW9kX2phbG9naW4vZGVmYXVsdC5waHA=',10003,0,'Extension Install',0,'2021-08-25 02:15:05','2021-08-25 02:15:05')
,(5,'ja_sensei','L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0X2FkZHJlc3MucGhw',10003,0,'Joomla Update',0,'2021-12-23 03:07:30','2022-04-18 03:42:55')
,(6,'ja_sensei','L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZ19jaGlsZHJlbi5waHA=',10003,0,'Joomla Update',0,'2021-12-23 03:07:30','2021-12-23 03:07:30')
,(7,'ja_sensei','L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZy5waHA=',10003,0,'Joomla Update',0,'2021-12-23 03:07:30','2023-02-09 02:44:04')
,(8,'ja_sensei','L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvZGVmYXVsdF9hcnRpY2xlcy5waHA=',10003,0,'Joomla Update',0,'2021-12-23 03:07:30','2023-02-09 02:44:04')
,(9,'ja_sensei','L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvZGVmYXVsdF9jaGlsZHJlbi5waHA=',10003,0,'Joomla Update',0,'2021-12-23 03:07:30','2021-12-23 03:07:30')
,(10,'ja_sensei','L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0LnBocA==',10003,0,'Joomla Update',0,'2022-02-07 07:13:42','2023-04-20 02:56:26')
,(11,'ja_sensei','L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZ19pdGVtLnBocA==',10003,0,'Joomla Update',0,'2022-04-18 03:42:55','2023-02-09 02:44:04')
,(12,'ja_sensei','L2h0bWwvY29tX2NvbnRlbnQvZmVhdHVyZWQvZGVmYXVsdF9pdGVtLnBocA==',10003,0,'Joomla Update',0,'2022-04-18 03:42:55','2023-02-09 02:44:04')
,(13,'ja_sensei','L2h0bWwvY29tX3RhZ3MvdGFnL2RlZmF1bHRfaXRlbXMucGhw',10003,0,'Joomla Update',0,'2022-04-18 03:42:55','2022-04-18 03:42:55')
,(14,'ja_sensei','L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHRfbG9naW4ucGhw',10003,0,'Joomla Update',0,'2022-04-18 03:42:55','2023-04-20 02:56:26')
,(15,'ja_sensei','L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHRfbG9nb3V0LnBocA==',10003,0,'Joomla Update',0,'2022-04-18 03:42:55','2023-02-09 02:44:04')
,(16,'ja_sensei','L2h0bWwvY29tX3VzZXJzL3Byb2ZpbGUvZWRpdC5waHA=',10003,0,'Joomla Update',0,'2022-04-18 03:42:55','2022-04-18 03:42:55')
,(17,'ja_sensei','L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0X3VzZXJfY3VzdG9tX2ZpZWxkcy5waHA=',10003,0,'Joomla Update',0,'2023-02-09 02:44:04','2023-02-09 02:44:04')
,(18,'ja_sensei','L2h0bWwvY29tX2NvbnRlbnQvYXJ0aWNsZS9kZWZhdWx0LnBocA==',10003,0,'Joomla Update',0,'2023-02-09 02:44:04','2023-02-09 02:44:04')
,(19,'ja_sensei','L2h0bWwvY29tX2NvbnRlbnQvYXJ0aWNsZS9kZWZhdWx0X2xpbmtzLnBocA==',10003,0,'Joomla Update',0,'2023-02-09 02:44:04','2023-02-09 02:44:04')
,(20,'ja_sensei','L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2F1dGhvci5waHA=',10003,0,'Joomla Update',0,'2023-02-09 02:44:04','2023-02-09 02:44:04')
,(21,'ja_sensei','L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0X2Zvcm0ucGhw',10003,0,'Joomla Update',0,'2023-04-20 02:56:26','2023-04-20 02:56:26')
,(22,'ja_sensei','L2h0bWwvY29tX3VzZXJzL3JlZ2lzdHJhdGlvbi9kZWZhdWx0LnBocA==',10003,0,'Joomla Update',0,'2023-04-20 02:56:26','2023-04-20 02:56:26')
,(23,'ja_sensei','L2h0bWwvY29tX3VzZXJzL3JlbWluZC9kZWZhdWx0LnBocA==',10003,0,'Joomla Update',0,'2023-04-20 02:56:26','2023-04-20 02:56:26')
,(24,'ja_sensei','L2h0bWwvY29tX3VzZXJzL3Jlc2V0L2NvbXBsZXRlLnBocA==',10003,0,'Joomla Update',0,'2023-04-20 02:56:26','2023-04-20 02:56:26')
,(25,'ja_sensei','L2h0bWwvY29tX3VzZXJzL3Jlc2V0L2NvbmZpcm0ucGhw',10003,0,'Joomla Update',0,'2023-04-20 02:56:26','2023-04-20 02:56:26')
,(26,'ja_sensei','L2h0bWwvY29tX3VzZXJzL3Jlc2V0L2RlZmF1bHQucGhw',10003,0,'Joomla Update',0,'2023-04-20 02:56:26','2023-04-20 02:56:26');
/*!40000 ALTER TABLE `#__template_overrides` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__template_styles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `home` char(7) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `params` mediumtext NOT NULL,
  `inheritable` tinyint(4) NOT NULL DEFAULT 0,
  `parent` varchar(50) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__template_styles` DISABLE KEYS */;
INSERT INTO `#__template_styles` (`id`, `template`, `client_id`, `home`, `title`, `params`, `inheritable`, `parent`) VALUES 
(9,'ja_sensei',0,'1','ja_sensei - Default','{\"t3_template\":\"1\",\"devmode\":\"1\",\"themermode\":\"1\",\"legacy_css\":\"1\",\"responsive\":\"1\",\"non_responsive_width\":\"970px\",\"build_rtl\":\"0\",\"t3-assets\":\"t3-assets\",\"t3-rmvlogo\":\"1\",\"minify\":\"1\",\"minify_js\":\"1\",\"minify_js_tool\":\"jsmin\",\"minify_exclude\":\"\",\"link_titles\":\"\",\"theme\":\"\",\"logotype\":\"image\",\"sitename\":\"\",\"slogan\":\"\",\"logoimage\":\"\",\"enable_logoimage_sm\":\"0\",\"logoimage_sm\":\"\",\"mainlayout\":\"default\",\"sublayout\":\"\",\"skip_component_content\":[\"101\"],\"mm_type\":\"mainmenu\",\"navigation_trigger\":\"click\",\"navigation_type\":\"megamenu\",\"navigation_animation\":\"elastic\",\"navigation_animation_duration\":\"500\",\"mm_config\":\"{\\\"mainmenu\\\":{\\\"item-146\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":149,\\\"width\\\":12}]]}}}}\",\"navigation_collapse_enable\":\"1\",\"addon_offcanvas_enable\":\"1\",\"addon_offcanvas_effect\":\"off-canvas-effect-4\",\"snippet_open_head\":\"\",\"snippet_close_head\":\"\",\"snippet_open_body\":\"\",\"snippet_close_body\":\"\",\"snippet_debug\":\"0\",\"theme_extras_com_guru\":[\"-1\"]}',0,'')
,(10,'atum',1,'1','Atum - Default','{\"hue\":\"hsl(214, 63%, 20%)\",\"bg-light\":\"#f0f4fb\",\"text-dark\":\"#495057\",\"text-light\":\"#ffffff\",\"link-color\":\"#2a69b8\",\"special-color\":\"#001b4c\",\"monochrome\":\"0\",\"loginLogo\":\"\",\"loginLogoAlt\":\"\",\"logoBrandLarge\":\"\",\"logoBrandLargeAlt\":\"\",\"logoBrandSmall\":\"\",\"logoBrandSmallAlt\":\"\"}',1,'')
,(11,'cassiopeia',0,'0','Cassiopeia - Default','{}',1,'');
/*!40000 ALTER TABLE `#__template_styles` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__ucm_base`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__ucm_base` DISABLE KEYS */;
INSERT INTO `#__ucm_base` (`ucm_id`, `ucm_item_id`, `ucm_type_id`, `ucm_language_id`) VALUES 
(2,2,1,0)
,(3,3,1,0)
,(4,6,1,0)
,(5,7,1,0)
,(6,8,1,0)
,(7,9,1,0)
,(8,10,1,0);
/*!40000 ALTER TABLE `#__ucm_base` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__ucm_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `core_body` longtext DEFAULT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT 0,
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int(10) unsigned DEFAULT NULL,
  `core_access` int(10) unsigned NOT NULL DEFAULT 0,
  `core_params` mediumtext DEFAULT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `core_metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `core_created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the j08b41_assets table.',
  `core_images` mediumtext DEFAULT NULL,
  `core_urls` mediumtext DEFAULT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT 0,
  `core_version` int(10) unsigned NOT NULL DEFAULT 1,
  `core_ordering` int(11) NOT NULL DEFAULT 0,
  `core_metakey` mediumtext DEFAULT NULL,
  `core_metadesc` mediumtext DEFAULT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT 0,
  `core_xreference` varchar(50) NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_language` (`core_language`),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_content_type` (`core_type_alias`(100))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains core content data in name spaced fields';
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__ucm_content` DISABLE KEYS */;
INSERT INTO `#__ucm_content` (`core_content_id`, `core_type_alias`, `core_title`, `core_alias`, `core_body`, `core_state`, `core_checked_out_time`, `core_checked_out_user_id`, `core_access`, `core_params`, `core_featured`, `core_metadata`, `core_created_user_id`, `core_created_by_alias`, `core_created_time`, `core_modified_user_id`, `core_modified_time`, `core_language`, `core_publish_up`, `core_publish_down`, `core_content_item_id`, `asset_id`, `core_images`, `core_urls`, `core_hits`, `core_version`, `core_ordering`, `core_metakey`, `core_metadesc`, `core_catid`, `core_xreference`, `core_type_id`) VALUES 
(2,'com_content.article','World Access to Higher Education Day: Behind the Mission and Purpose','ja-sensei','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n',1,NULL,NULL,1,'{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',1,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',42,'','2021-08-03 08:48:32',42,'2021-08-03 08:48:32','*','2021-08-03 08:48:32',NULL,2,81,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-1.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-1.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}',61,8,1,'','',9,'',1)
,(3,'com_content.article','How To Become A Little More Organised','how-to-become-a-little-more-organised','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n',1,NULL,NULL,1,'{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',1,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',42,'','2021-08-03 08:48:32',42,'2021-08-03 08:48:32','*','2021-08-03 08:48:32',NULL,3,82,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-2.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-2.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}',1,4,0,'','',9,'',1)
,(4,'com_content.article','Accent Modification for Career Success','accent-modification-for-career-success','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n',1,NULL,NULL,1,'{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',1,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',42,'','2021-08-03 08:48:32',42,'2021-08-03 08:48:32','*','2021-08-03 08:48:32',NULL,6,85,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-5.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-5.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}',0,5,0,'','',10,'',1)
,(5,'com_content.article','Learning English at 5 AM','learning-english-at-5-am','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n',1,NULL,NULL,1,'{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',1,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',42,'','2021-08-03 08:48:32',42,'2021-08-03 08:48:32','*','2021-08-03 08:48:32',NULL,7,87,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-6.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-6.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}',0,4,1,'','',10,'',1)
,(6,'com_content.article','Accessible and Relatable Grammar Instruction','accessible-and-relatable-grammar-instruction','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n',1,NULL,NULL,1,'{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',1,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',42,'','2021-08-03 08:48:32',42,'2021-08-03 08:48:32','*','2021-08-03 08:48:32',NULL,8,89,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-7.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-7.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}',0,5,1,'','',11,'',1)
,(7,'com_content.article','July\'s Featured Tutor Spotlight','july-s-featured-tutor-spotlight','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n',1,NULL,NULL,1,'{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',1,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',42,'','2021-08-03 08:48:32',42,'2021-08-03 08:48:32','*','2021-08-03 08:48:32',NULL,9,91,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-8.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-8.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}',0,6,0,'','',11,'',1)
,(8,'com_content.article','Don\'t Be Afraid to Ask Questions','don-t-be-afraid-to-ask-questions','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>\r\n',0,NULL,NULL,1,'{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',1,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',42,'','2021-08-03 08:48:32',0,'2021-08-03 08:48:32','*','2021-08-03 08:48:32',NULL,10,93,'{\"image_intro\":\"images\\/joomlart\\/blog\\/item-4.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/joomlart\\/blog\\/item-4.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}','{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}',0,4,0,'','',11,'',1);
/*!40000 ALTER TABLE `#__ucm_content` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__updates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `extension_id` int(11) DEFAULT 0,
  `name` varchar(100) DEFAULT '',
  `description` mediumtext NOT NULL,
  `element` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `folder` varchar(20) DEFAULT '',
  `client_id` tinyint(3) DEFAULT 0,
  `version` varchar(32) DEFAULT '',
  `data` mediumtext NOT NULL,
  `detailsurl` mediumtext NOT NULL,
  `infourl` mediumtext NOT NULL,
  `changelogurl` text DEFAULT NULL,
  `extra_query` varchar(1000) DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Available Updates';
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__updates` DISABLE KEYS */;
INSERT INTO `#__updates` (`update_id`, `update_site_id`, `extension_id`, `name`, `description`, `element`, `type`, `folder`, `client_id`, `version`, `data`, `detailsurl`, `infourl`, `changelogurl`, `extra_query`) VALUES 
(1046,2,0,'Afrikaans','','pkg_af-ZA','package','',0,'4.2.8.1','','https://update.joomla.org/language/details4/af-ZA_details.xml','','','')
,(1047,2,0,'Arabic Unitag','','pkg_ar-AA','package','',0,'4.0.2.1','','https://update.joomla.org/language/details4/ar-AA_details.xml','','','')
,(1048,2,0,'Bulgarian','','pkg_bg-BG','package','',0,'4.2.7.1','','https://update.joomla.org/language/details4/bg-BG_details.xml','','','')
,(1049,2,0,'Catalan','','pkg_ca-ES','package','',0,'4.0.4.2','','https://update.joomla.org/language/details4/ca-ES_details.xml','','','')
,(1050,2,0,'Chinese, Simplified','','pkg_zh-CN','package','',0,'4.2.0.1','','https://update.joomla.org/language/details4/zh-CN_details.xml','','','')
,(1051,2,0,'Chinese, Traditional','','pkg_zh-TW','package','',0,'4.2.3.1','','https://update.joomla.org/language/details4/zh-TW_details.xml','','','')
,(1052,2,0,'Czech','','pkg_cs-CZ','package','',0,'4.2.0.1','','https://update.joomla.org/language/details4/cs-CZ_details.xml','','','')
,(1053,2,0,'Danish','','pkg_da-DK','package','',0,'4.3.0.2','','https://update.joomla.org/language/details4/da-DK_details.xml','','','')
,(1054,2,0,'Dutch','','pkg_nl-NL','package','',0,'4.2.9.1','','https://update.joomla.org/language/details4/nl-NL_details.xml','','','')
,(1055,2,0,'English, Australia','','pkg_en-AU','package','',0,'4.2.8.2','','https://update.joomla.org/language/details4/en-AU_details.xml','','','')
,(1056,2,0,'English, Canada','','pkg_en-CA','package','',0,'4.2.8.1','','https://update.joomla.org/language/details4/en-CA_details.xml','','','')
,(1057,2,0,'English, New Zealand','','pkg_en-NZ','package','',0,'4.2.8.1','','https://update.joomla.org/language/details4/en-NZ_details.xml','','','')
,(1058,2,0,'English, USA','','pkg_en-US','package','',0,'4.2.8.1','','https://update.joomla.org/language/details4/en-US_details.xml','','','')
,(1059,2,0,'Estonian','','pkg_et-EE','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/et-EE_details.xml','','','')
,(1060,2,0,'Finnish','','pkg_fi-FI','package','',0,'4.1.1.2','','https://update.joomla.org/language/details4/fi-FI_details.xml','','','')
,(1061,2,0,'Flemish','','pkg_nl-BE','package','',0,'4.2.9.1','','https://update.joomla.org/language/details4/nl-BE_details.xml','','','')
,(1062,2,0,'French','','pkg_fr-FR','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/fr-FR_details.xml','','','')
,(1063,2,0,'Georgian','','pkg_ka-GE','package','',0,'4.2.9.1','','https://update.joomla.org/language/details4/ka-GE_details.xml','','','')
,(1064,2,0,'German','','pkg_de-DE','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/de-DE_details.xml','','','')
,(1065,2,0,'German, Austria','','pkg_de-AT','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/de-AT_details.xml','','','')
,(1066,2,0,'German, Liechtenstein','','pkg_de-LI','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/de-LI_details.xml','','','')
,(1067,2,0,'German, Luxembourg','','pkg_de-LU','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/de-LU_details.xml','','','')
,(1068,2,0,'German, Switzerland','','pkg_de-CH','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/de-CH_details.xml','','','')
,(1069,2,0,'Greek','','pkg_el-GR','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/el-GR_details.xml','','','')
,(1070,2,0,'Hungarian','','pkg_hu-HU','package','',0,'4.2.7.1','','https://update.joomla.org/language/details4/hu-HU_details.xml','','','')
,(1071,2,0,'Irish','','pkg_ga-IE','package','',0,'4.2.8.1','','https://update.joomla.org/language/details4/ga-IE_details.xml','','','')
,(1072,2,0,'Italian','','pkg_it-IT','package','',0,'4.2.9.1','','https://update.joomla.org/language/details4/it-IT_details.xml','','','')
,(1073,2,0,'Japanese','','pkg_ja-JP','package','',0,'4.2.9.1','','https://update.joomla.org/language/details4/ja-JP_details.xml','','','')
,(1074,2,0,'Kazakh','','pkg_kk-KZ','package','',0,'4.1.2.1','','https://update.joomla.org/language/details4/kk-KZ_details.xml','','','')
,(1075,2,0,'Latvian','','pkg_lv-LV','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/lv-LV_details.xml','','','')
,(1076,2,0,'Lithuanian','','pkg_lt-LT','package','',0,'4.2.9.1','','https://update.joomla.org/language/details4/lt-LT_details.xml','','','')
,(1077,2,0,'Macedonian','','pkg_mk-MK','package','',0,'4.2.4.1','','https://update.joomla.org/language/details4/mk-MK_details.xml','','','')
,(1078,2,0,'Norwegian Bokmål','','pkg_nb-NO','package','',0,'4.0.1.1','','https://update.joomla.org/language/details4/nb-NO_details.xml','','','')
,(1079,2,0,'Persian Farsi','','pkg_fa-IR','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/fa-IR_details.xml','','','')
,(1080,2,0,'Polish','','pkg_pl-PL','package','',0,'4.2.8.2','','https://update.joomla.org/language/details4/pl-PL_details.xml','','','')
,(1081,2,0,'Portuguese, Brazil','','pkg_pt-BR','package','',0,'4.0.3.1','','https://update.joomla.org/language/details4/pt-BR_details.xml','','','')
,(1082,2,0,'Portuguese, Portugal','','pkg_pt-PT','package','',0,'4.0.0-rc4.2','','https://update.joomla.org/language/details4/pt-PT_details.xml','','','')
,(1083,2,0,'Romanian','','pkg_ro-RO','package','',0,'4.2.7.1','','https://update.joomla.org/language/details4/ro-RO_details.xml','','','')
,(1084,2,0,'Russian','','pkg_ru-RU','package','',0,'4.2.9.1','','https://update.joomla.org/language/details4/ru-RU_details.xml','','','')
,(1085,2,0,'Serbian, Cyrillic','','pkg_sr-RS','package','',0,'4.2.7.1','','https://update.joomla.org/language/details4/sr-RS_details.xml','','','')
,(1086,2,0,'Serbian, Latin','','pkg_sr-YU','package','',0,'4.2.9.1','','https://update.joomla.org/language/details4/sr-YU_details.xml','','','')
,(1087,2,0,'Slovak','','pkg_sk-SK','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/sk-SK_details.xml','','','')
,(1088,2,0,'Slovenian','','pkg_sl-SI','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/sl-SI_details.xml','','','')
,(1089,2,0,'Spanish','','pkg_es-ES','package','',0,'4.2.3.1','','https://update.joomla.org/language/details4/es-ES_details.xml','','','')
,(1090,2,0,'Swedish','','pkg_sv-SE','package','',0,'4.2.9.1','','https://update.joomla.org/language/details4/sv-SE_details.xml','','','')
,(1091,2,0,'Tamil, India','','pkg_ta-IN','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/ta-IN_details.xml','','','')
,(1092,2,0,'Thai','','pkg_th-TH','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/th-TH_details.xml','','','')
,(1093,2,0,'Turkish','','pkg_tr-TR','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/tr-TR_details.xml','','','')
,(1094,2,0,'Ukrainian','','pkg_uk-UA','package','',0,'4.2.5.1','','https://update.joomla.org/language/details4/uk-UA_details.xml','','','')
,(1095,2,0,'Vietnamese','','pkg_vi-VN','package','',0,'4.2.2.1','','https://update.joomla.org/language/details4/vi-VN_details.xml','','','')
,(1096,2,0,'Welsh','','pkg_cy-GB','package','',0,'4.3.0.1','','https://update.joomla.org/language/details4/cy-GB_details.xml','','','')
,(1097,82,0,'Guru Search Module','','guru-search-module','module','',0,'1.0.5','','http://update.joomlart.com/service/tracking/j31/guru-search-module.xml','http://www.joomlart.com/update-steps',NULL,'')
,(1098,83,0,'AllVideos','The universal media player for Joomla','jw_allvideos','plugin','content',0,'6.1.0','','http://cdn.joomlaworks.org/updates/allvideos.xml','https://www.joomlaworks.net/blog/item/303-allvideos-6-1-0-now-available-adds-mixcloud-support',NULL,'')
,(1099,87,0,'GURU Payment Plugin - PayPal Pro','','paypalpro','plugin','paypalpro',0,'1.0.0','','http://update.joomlart.com/service/tracking/j31/paypalpro.xml','http://www.joomlart.com/update-steps',NULL,'')
,(1100,89,0,'JA Extension Manager Component','','com_jaextmanager','component','',0,'2.7.5','','http://update.joomlart.com/service/tracking/j16/com_jaextmanager.xml','http://www.joomlart.com/update-steps',NULL,'')
,(1101,90,0,'Guru Pro','','com_guru','component','',1,'6.0.0','','https://www.jomsocial.com/guru_update.xml','',NULL,'')
,(1102,91,0,'Search Extension Package','Joomla! CMS Search Package','pkg_search','package','',0,'4.0.1-dev','','https://raw.githubusercontent.com/joomla-extensions/search/main/manifest.xml','https://github.com/joomla-extensions/search/releases/tag/4.0.1-dev',NULL,'');
/*!40000 ALTER TABLE `#__updates` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__update_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `location` mediumtext NOT NULL,
  `enabled` int(11) DEFAULT 0,
  `last_check_timestamp` bigint(20) DEFAULT 0,
  `extra_query` varchar(1000) DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Update Sites';
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__update_sites` DISABLE KEYS */;
INSERT INTO `#__update_sites` (`update_site_id`, `name`, `type`, `location`, `enabled`, `last_check_timestamp`, `extra_query`, `checked_out`, `checked_out_time`) VALUES 
(1,'Joomla! Core','collection','https://update.joomla.org/core/list.xml',1,1681959283,'',NULL,NULL)
,(2,'Accredited Joomla! Translations','collection','https://update.joomla.org/language/translationlist_4.xml',1,1681959284,'',NULL,NULL)
,(3,'Joomla! Update Component Update Site','extension','https://update.joomla.org/core/extensions/com_joomlaupdate.xml',1,1681959387,'',NULL,NULL)
,(79,'','extension','http://update.joomlart.com/service/tracking/j16/mod_jamasthead.xml',1,1681959305,'',NULL,NULL)
,(80,'','extension','http://update.joomlart.com/service/tracking/j16/mod_ja_acm.xml',1,1681959305,'',NULL,NULL)
,(81,'','extension','http://update.joomlart.com/service/tracking/j16/mod_jalogin.xml',1,1681959306,'',NULL,NULL)
,(82,'','extension','http://update.joomlart.com/service/tracking/j31/guru-search-module.xml',1,1681959307,'',NULL,NULL)
,(83,'AllVideos','extension','http://cdn.joomlaworks.org/updates/allvideos.xml',1,1681959308,'',NULL,NULL)
,(84,'','extension','http://update.joomlart.com/service/tracking/j16/plg_system_t3.xml',1,1681959309,'',NULL,NULL)
,(85,'','extension','http://update.joomlart.com/service/tracking/j16/plg_system_jacontenttype.xml',1,1681959310,'',NULL,NULL)
,(86,'','extension','http://update.joomlart.com/service/tracking/j31/plg_ajax_jacontenttype.xml',1,1681959310,'',NULL,NULL)
,(87,'','extension','http://update.joomlart.com/service/tracking/j31/paypalpro.xml',1,1681959311,'',NULL,NULL)
,(88,'','extension','http://update.joomlart.com/service/tracking/j31/ja_sensei.xml',1,1681959311,'',NULL,NULL)
,(89,'JA Extension Manager','extension','http://update.joomlart.com/service/tracking/j16/com_jaextmanager.xml',1,1681959312,'',NULL,NULL)
,(90,'COM_GURU','extension','https://www.jomsocial.com/guru_update.xml',1,1681959313,'',NULL,NULL)
,(91,'Search Update Site','extension','https://raw.githubusercontent.com/joomla-extensions/search/main/manifest.xml',1,1681959314,'',NULL,NULL);
/*!40000 ALTER TABLE `#__update_sites` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__update_sites_extensions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Links extensions to update sites';
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__update_sites_extensions` DISABLE KEYS */;
INSERT INTO `#__update_sites_extensions` (`update_site_id`, `extension_id`) VALUES 
(1,700)
,(2,700)
,(2,802)
,(3,28)
,(3,600)
,(79,10001)
,(80,10000)
,(81,10016)
,(82,10013)
,(83,10024)
,(84,10002)
,(85,10023)
,(86,10017)
,(87,10021)
,(88,10003)
,(89,10015)
,(90,10004)
,(91,10085);
/*!40000 ALTER TABLE `#__update_sites_extensions` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `title` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__usergroups` DISABLE KEYS */;
INSERT INTO `#__usergroups` (`id`, `parent_id`, `lft`, `rgt`, `title`) VALUES 
(1,0,1,18,'Public')
,(2,1,8,15,'Registered')
,(3,2,9,14,'Author')
,(4,3,10,13,'Editor')
,(5,4,11,12,'Publisher')
,(6,1,4,7,'Manager')
,(7,6,5,6,'Administrator')
,(8,1,16,17,'Super Users')
,(9,1,2,3,'Guest');
/*!40000 ALTER TABLE `#__usergroups` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) NOT NULL DEFAULT '',
  `username` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT 0,
  `sendEmail` tinyint(4) DEFAULT 0,
  `registerDate` datetime NOT NULL,
  `lastvisitDate` datetime DEFAULT NULL,
  `activation` varchar(100) NOT NULL DEFAULT '',
  `params` mediumtext NOT NULL,
  `lastResetTime` datetime DEFAULT NULL,
  `resetCount` int(11) NOT NULL DEFAULT 0 COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Require user to reset password on next login',
  `authProvider` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_block` (`block`),
  KEY `email` (`email`),
  KEY `idx_name` (`name`(100))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__users` DISABLE KEYS */;
INSERT INTO `#__users` (`id`, `name`, `username`, `email`, `password`, `block`, `sendEmail`, `registerDate`, `lastvisitDate`, `activation`, `params`, `lastResetTime`, `resetCount`, `otpKey`, `otep`, `requireReset`, `authProvider`) VALUES 
(42,'Super User','admin','test@joomlart.com','f1be3433e25c5dfefea44a6b0db02884',0,1,'2023-04-20 02:54:37','2023-04-20 02:55:02','0','',NULL,0,'','',0,'')
,(43,'Travis D. Strohl','ijoomla','demo@ijoomla.com','$2y$10$6OKUoYZMyNPx1qeZmwY7LOi59MPGYkH0lgWtRdSq8ilWyOWBtj2E6',0,0,'2021-08-03 08:48:32',NULL,'','{}',NULL,0,'','',0,'')
,(44,'Lillian Lindsey','demo2','admin1@gmail.com','$2y$10$.Et7vKW3BxSyTKG2kPZSDe2wRJYdwiYRk6V4Ey9WRbK9lk9f8zxYG',0,0,'2021-08-03 08:48:32',NULL,'','{}',NULL,0,'','',0,'')
,(45,'David C. Hernandez','Hernandez','DavidCHernandez@rhyta.com','$2y$10$CLiV5b1TQODKmrVCQ7B32OoZUEGWYOmEUCiLY8f9bmBhtjPgB/C1.',0,0,'2021-08-03 08:48:32',NULL,'','{}',NULL,0,'','',0,'')
,(46,'Micchael Dam','mieni','micchael@gmail.com','$2y$10$hz.fTI4kpwzstGjXWxVoFeL7bRzA9OAGPl2QP9q68yG0WZririlEe',0,0,'2021-08-03 08:48:32',NULL,'','{}',NULL,0,'','',0,'')
,(47,'Jakob Owens','mainei','jakob@gmail.com','$2y$10$zeJxRWR.4esxHHzhMIuFPugJDQFdNhv/CTtiY1h9sfgbP2ExD0s7m',0,0,'2021-08-03 08:48:32',NULL,'','{}',NULL,0,'','',0,'')
,(48,'Warren Wong','buttenrt','buttenrt@gmail.com','$2y$10$QGONmsH8olR5QzEe31y1k.V1mlZYkClWoVius36vsQmDNcOpQBJ9O',0,0,'2021-08-03 08:48:32',NULL,'','{}',NULL,0,'','',0,'')
,(49,'Clay','clays','claybanks@gmail.com','91543c5f1655ba38f86020350a7a9008:6P8SHNPR46DY07BK87RQ30JJK23F05EOY',0,0,'2021-08-03 08:48:32',NULL,'','',NULL,0,'','',0,'')
,(50,'Marvin','marvin','marvinmeyes@gmail.com','96bc7644e23ad508d52d5033bda4dff2:JEJS9O6C2247ALHS0UP8C78VLL7270G8O',0,0,'2021-08-03 08:48:32',NULL,'','',NULL,0,'','',0,'')
,(51,'Helena','helena','helenalopes@gmail.com','f26f5fdbb911ce1b391cd9d106cb1442:91189Y6324VIHC86GL3YJ5SU3247G07EL',0,0,'2021-08-03 08:48:32',NULL,'','',NULL,0,'','',0,'')
,(52,'Ben','ben','benduchac@gmail.com','$2y$10$JN4D/egXEbDuLRPjWMwKv.0DqsiVKc6dSnHrwIypDl8VwN68eWwoq',0,0,'2021-08-03 08:48:32','2021-08-03 08:48:32','','{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}',NULL,0,'','',0,'')
,(53,'Hai NV','hainv','quanghai.ict@gail.com','$2y$10$zmtOmGAmBQA1xf1WERkB9ulZPutplYhjK.eV4xfbSFsOZXpOaVqrW',0,0,'2021-08-03 08:48:32','2021-08-03 08:48:32','','{}',NULL,0,'','',0,'');
/*!40000 ALTER TABLE `#__users` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__user_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) NOT NULL,
  `token` varchar(255) NOT NULL,
  `series` varchar(191) NOT NULL,
  `time` varchar(200) NOT NULL,
  `uastring` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__user_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__user_keys` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__user_mfa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__user_mfa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `method` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `options` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_on` datetime NOT NULL,
  `last_used` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Multi-factor Authentication settings';
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__user_mfa` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__user_mfa` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__user_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `body` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `review_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__user_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__user_notes` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__user_profiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) NOT NULL,
  `profile_value` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Simple user profile storage table';
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__user_profiles` DISABLE KEYS */;
INSERT INTO `#__user_profiles` (`user_id`, `profile_key`, `profile_value`, `ordering`) VALUES 
(42,'joomlatoken.enabled','1',2)
,(42,'joomlatoken.token','VxYdR9e6tDocSdgmOUundjc8pqAlbgnyNGWVXMNYBPU=',1);
/*!40000 ALTER TABLE `#__user_profiles` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__user_usergroup_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to j08b41_users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to j08b41_usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__user_usergroup_map` DISABLE KEYS */;
INSERT INTO `#__user_usergroup_map` (`user_id`, `group_id`) VALUES 
(43,2)
,(44,2)
,(45,2)
,(46,2)
,(47,2)
,(48,2)
,(49,2)
,(50,2)
,(51,2)
,(52,2)
,(53,2);
/*!40000 ALTER TABLE `#__user_usergroup_map` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__viewlevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__viewlevels` DISABLE KEYS */;
INSERT INTO `#__viewlevels` (`id`, `title`, `ordering`, `rules`) VALUES 
(1,'Public',0,'[1]')
,(2,'Registered',2,'[6,2,8]')
,(3,'Special',3,'[6,3,8]')
,(5,'Guest',1,'[9]')
,(6,'Super Users',4,'[8]');
/*!40000 ALTER TABLE `#__viewlevels` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__webauthn_credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__webauthn_credentials` (
  `id` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'User handle',
  `label` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(60))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__webauthn_credentials` DISABLE KEYS */;
/*!40000 ALTER TABLE `#__webauthn_credentials` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__workflows`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__workflows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_extension` (`extension`),
  KEY `idx_default` (`default`),
  KEY `idx_created` (`created`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_modified` (`modified`),
  KEY `idx_modified_by` (`modified_by`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__workflows` DISABLE KEYS */;
INSERT INTO `#__workflows` (`id`, `asset_id`, `published`, `title`, `description`, `extension`, `default`, `ordering`, `created`, `created_by`, `modified`, `modified_by`, `checked_out_time`, `checked_out`) VALUES 
(1,0,1,'COM_WORKFLOW_BASIC_WORKFLOW','','com_content.article',1,1,'2021-08-03 15:54:34',0,'2021-08-03 15:54:34',0,NULL,NULL);
/*!40000 ALTER TABLE `#__workflows` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__workflow_associations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__workflow_associations` (
  `item_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Extension table id value',
  `stage_id` int(11) NOT NULL COMMENT 'Foreign Key to j08b41_workflow_stages.id',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__workflow_associations` DISABLE KEYS */;
INSERT INTO `#__workflow_associations` (`item_id`, `stage_id`, `extension`) VALUES 
(1,1,'com_content.article')
,(2,1,'com_content.article')
,(3,1,'com_content.article')
,(4,1,'com_content.article')
,(5,1,'com_content.article')
,(6,1,'com_content.article')
,(7,1,'com_content.article')
,(8,1,'com_content.article')
,(9,1,'com_content.article')
,(10,1,'com_content.article')
,(11,1,'com_content.article')
,(12,1,'com_content.article')
,(13,1,'com_content.article')
,(14,1,'com_content.article');
/*!40000 ALTER TABLE `#__workflow_associations` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__workflow_stages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__workflow_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__workflow_stages` DISABLE KEYS */;
INSERT INTO `#__workflow_stages` (`id`, `asset_id`, `ordering`, `workflow_id`, `published`, `title`, `description`, `default`, `checked_out_time`, `checked_out`) VALUES 
(1,0,1,1,1,'COM_WORKFLOW_BASIC_STAGE','',1,NULL,NULL);
/*!40000 ALTER TABLE `#__workflow_stages` ENABLE KEYS */;

DROP TABLE IF EXISTS `#__workflow_transitions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `#__workflow_transitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_stage_id` int(11) NOT NULL,
  `to_stage_id` int(11) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40000 ALTER TABLE `#__workflow_transitions` DISABLE KEYS */;
INSERT INTO `#__workflow_transitions` (`id`, `asset_id`, `ordering`, `workflow_id`, `published`, `title`, `description`, `from_stage_id`, `to_stage_id`, `options`, `checked_out_time`, `checked_out`) VALUES 
(1,0,1,1,1,'Unpublish','',-1,1,'{\"publishing\":\"0\"}',NULL,NULL)
,(2,0,2,1,1,'Publish','',-1,1,'{\"publishing\":\"1\"}',NULL,NULL)
,(3,0,3,1,1,'Trash','',-1,1,'{\"publishing\":\"-2\"}',NULL,NULL)
,(4,0,4,1,1,'Archive','',-1,1,'{\"publishing\":\"2\"}',NULL,NULL)
,(5,0,5,1,1,'Feature','',-1,1,'{\"featuring\":\"1\"}',NULL,NULL)
,(6,0,6,1,1,'Unfeature','',-1,1,'{\"featuring\":\"0\"}',NULL,NULL)
,(7,0,7,1,1,'Publish & Feature','',-1,1,'{\"publishing\":\"1\",\"featuring\":\"1\"}',NULL,NULL);
/*!40000 ALTER TABLE `#__workflow_transitions` ENABLE KEYS */;

/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

